@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.alb.kotlin.inputs

import com.pulumi.aws.alb.inputs.ListenerDefaultActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property authenticateCognito Configuration block for using Amazon Cognito to authenticate users. Specify only when `type` is `authenticate-cognito`. Detailed below.
 * @property authenticateOidc Configuration block for an identity provider that is compliant with OpenID Connect (OIDC). Specify only when `type` is `authenticate-oidc`. Detailed below.
 * @property fixedResponse Information for creating an action that returns a custom HTTP response. Required if `type` is `fixed-response`.
 * @property forward Configuration block for creating an action that distributes requests among one or more target groups. Specify only if `type` is `forward`. If you specify both `forward` block and `target_group_arn` attribute, you can specify only one target group using `forward` and it must be the same target group specified in `target_group_arn`. Detailed below.
 * @property order Order for the action. This value is required for rules with multiple actions. The action with the lowest value for order is performed first. Valid values are between `1` and `50000`.
 * @property redirect Configuration block for creating a redirect action. Required if `type` is `redirect`. Detailed below.
 * @property targetGroupArn ARN of the Target Group to which to route traffic. Specify only if `type` is `forward` and you want to route to a single target group. To route to one or more target groups, use a `forward` block instead.
 * @property type Type of routing action. Valid values are `forward`, `redirect`, `fixed-response`, `authenticate-cognito` and `authenticate-oidc`.
 * The following arguments are optional:
 */
public data class ListenerDefaultActionArgs(
    public val authenticateCognito: Output<ListenerDefaultActionAuthenticateCognitoArgs>? = null,
    public val authenticateOidc: Output<ListenerDefaultActionAuthenticateOidcArgs>? = null,
    public val fixedResponse: Output<ListenerDefaultActionFixedResponseArgs>? = null,
    public val forward: Output<ListenerDefaultActionForwardArgs>? = null,
    public val order: Output<Int>? = null,
    public val redirect: Output<ListenerDefaultActionRedirectArgs>? = null,
    public val targetGroupArn: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.alb.inputs.ListenerDefaultActionArgs> {
    override fun toJava(): com.pulumi.aws.alb.inputs.ListenerDefaultActionArgs =
        com.pulumi.aws.alb.inputs.ListenerDefaultActionArgs.builder()
            .authenticateCognito(
                authenticateCognito?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .authenticateOidc(authenticateOidc?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fixedResponse(fixedResponse?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .forward(forward?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .order(order?.applyValue({ args0 -> args0 }))
            .redirect(redirect?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .targetGroupArn(targetGroupArn?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerDefaultActionArgs].
 */
@PulumiTagMarker
public class ListenerDefaultActionArgsBuilder internal constructor() {
    private var authenticateCognito: Output<ListenerDefaultActionAuthenticateCognitoArgs>? = null

    private var authenticateOidc: Output<ListenerDefaultActionAuthenticateOidcArgs>? = null

    private var fixedResponse: Output<ListenerDefaultActionFixedResponseArgs>? = null

    private var forward: Output<ListenerDefaultActionForwardArgs>? = null

    private var order: Output<Int>? = null

    private var redirect: Output<ListenerDefaultActionRedirectArgs>? = null

    private var targetGroupArn: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Configuration block for using Amazon Cognito to authenticate users. Specify only when `type` is `authenticate-cognito`. Detailed below.
     */
    @JvmName("kofcfgxwylntggyg")
    public suspend
    fun authenticateCognito(`value`: Output<ListenerDefaultActionAuthenticateCognitoArgs>) {
        this.authenticateCognito = value
    }

    /**
     * @param value Configuration block for an identity provider that is compliant with OpenID Connect (OIDC). Specify only when `type` is `authenticate-oidc`. Detailed below.
     */
    @JvmName("sbghgjymdkqidlgp")
    public suspend fun authenticateOidc(`value`: Output<ListenerDefaultActionAuthenticateOidcArgs>) {
        this.authenticateOidc = value
    }

    /**
     * @param value Information for creating an action that returns a custom HTTP response. Required if `type` is `fixed-response`.
     */
    @JvmName("eflekwcjmyrwnqpb")
    public suspend fun fixedResponse(`value`: Output<ListenerDefaultActionFixedResponseArgs>) {
        this.fixedResponse = value
    }

    /**
     * @param value Configuration block for creating an action that distributes requests among one or more target groups. Specify only if `type` is `forward`. If you specify both `forward` block and `target_group_arn` attribute, you can specify only one target group using `forward` and it must be the same target group specified in `target_group_arn`. Detailed below.
     */
    @JvmName("yhcjycdxvjbkctyr")
    public suspend fun forward(`value`: Output<ListenerDefaultActionForwardArgs>) {
        this.forward = value
    }

    /**
     * @param value Order for the action. This value is required for rules with multiple actions. The action with the lowest value for order is performed first. Valid values are between `1` and `50000`.
     */
    @JvmName("ftsxekkxmlbfdeun")
    public suspend fun order(`value`: Output<Int>) {
        this.order = value
    }

    /**
     * @param value Configuration block for creating a redirect action. Required if `type` is `redirect`. Detailed below.
     */
    @JvmName("sagphvqihasovboc")
    public suspend fun redirect(`value`: Output<ListenerDefaultActionRedirectArgs>) {
        this.redirect = value
    }

    /**
     * @param value ARN of the Target Group to which to route traffic. Specify only if `type` is `forward` and you want to route to a single target group. To route to one or more target groups, use a `forward` block instead.
     */
    @JvmName("afelbtbhipilycei")
    public suspend fun targetGroupArn(`value`: Output<String>) {
        this.targetGroupArn = value
    }

    /**
     * @param value Type of routing action. Valid values are `forward`, `redirect`, `fixed-response`, `authenticate-cognito` and `authenticate-oidc`.
     * The following arguments are optional:
     */
    @JvmName("yvglrampeiqtwnbk")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Configuration block for using Amazon Cognito to authenticate users. Specify only when `type` is `authenticate-cognito`. Detailed below.
     */
    @JvmName("dxkbfjnfqwsvpcyx")
    public suspend fun authenticateCognito(`value`: ListenerDefaultActionAuthenticateCognitoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticateCognito = mapped
    }

    /**
     * @param argument Configuration block for using Amazon Cognito to authenticate users. Specify only when `type` is `authenticate-cognito`. Detailed below.
     */
    @JvmName("infpynjujgnycews")
    public suspend
    fun authenticateCognito(argument: suspend ListenerDefaultActionAuthenticateCognitoArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerDefaultActionAuthenticateCognitoArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.authenticateCognito = mapped
    }

    /**
     * @param value Configuration block for an identity provider that is compliant with OpenID Connect (OIDC). Specify only when `type` is `authenticate-oidc`. Detailed below.
     */
    @JvmName("grsysjpigkpghxgv")
    public suspend fun authenticateOidc(`value`: ListenerDefaultActionAuthenticateOidcArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticateOidc = mapped
    }

    /**
     * @param argument Configuration block for an identity provider that is compliant with OpenID Connect (OIDC). Specify only when `type` is `authenticate-oidc`. Detailed below.
     */
    @JvmName("jcyoflltfwusikme")
    public suspend
    fun authenticateOidc(argument: suspend ListenerDefaultActionAuthenticateOidcArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerDefaultActionAuthenticateOidcArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.authenticateOidc = mapped
    }

    /**
     * @param value Information for creating an action that returns a custom HTTP response. Required if `type` is `fixed-response`.
     */
    @JvmName("pfwotgcbtinkiish")
    public suspend fun fixedResponse(`value`: ListenerDefaultActionFixedResponseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fixedResponse = mapped
    }

    /**
     * @param argument Information for creating an action that returns a custom HTTP response. Required if `type` is `fixed-response`.
     */
    @JvmName("qtevwwlubkwmrsww")
    public suspend
    fun fixedResponse(argument: suspend ListenerDefaultActionFixedResponseArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerDefaultActionFixedResponseArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.fixedResponse = mapped
    }

    /**
     * @param value Configuration block for creating an action that distributes requests among one or more target groups. Specify only if `type` is `forward`. If you specify both `forward` block and `target_group_arn` attribute, you can specify only one target group using `forward` and it must be the same target group specified in `target_group_arn`. Detailed below.
     */
    @JvmName("hqvdsfbohhgsorwr")
    public suspend fun forward(`value`: ListenerDefaultActionForwardArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forward = mapped
    }

    /**
     * @param argument Configuration block for creating an action that distributes requests among one or more target groups. Specify only if `type` is `forward`. If you specify both `forward` block and `target_group_arn` attribute, you can specify only one target group using `forward` and it must be the same target group specified in `target_group_arn`. Detailed below.
     */
    @JvmName("eutnvwejtvnuqdnc")
    public suspend fun forward(argument: suspend ListenerDefaultActionForwardArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerDefaultActionForwardArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.forward = mapped
    }

    /**
     * @param value Order for the action. This value is required for rules with multiple actions. The action with the lowest value for order is performed first. Valid values are between `1` and `50000`.
     */
    @JvmName("rnxrkkpuxkvjsuyk")
    public suspend fun order(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.order = mapped
    }

    /**
     * @param value Configuration block for creating a redirect action. Required if `type` is `redirect`. Detailed below.
     */
    @JvmName("yhjqbtvqxrvsjwqy")
    public suspend fun redirect(`value`: ListenerDefaultActionRedirectArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redirect = mapped
    }

    /**
     * @param argument Configuration block for creating a redirect action. Required if `type` is `redirect`. Detailed below.
     */
    @JvmName("tnrjcxkxwoaffvoa")
    public suspend
    fun redirect(argument: suspend ListenerDefaultActionRedirectArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerDefaultActionRedirectArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.redirect = mapped
    }

    /**
     * @param value ARN of the Target Group to which to route traffic. Specify only if `type` is `forward` and you want to route to a single target group. To route to one or more target groups, use a `forward` block instead.
     */
    @JvmName("jdjotntnmywwbkgd")
    public suspend fun targetGroupArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetGroupArn = mapped
    }

    /**
     * @param value Type of routing action. Valid values are `forward`, `redirect`, `fixed-response`, `authenticate-cognito` and `authenticate-oidc`.
     * The following arguments are optional:
     */
    @JvmName("owhvtuprsfwcxaxj")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ListenerDefaultActionArgs = ListenerDefaultActionArgs(
        authenticateCognito = authenticateCognito,
        authenticateOidc = authenticateOidc,
        fixedResponse = fixedResponse,
        forward = forward,
        order = order,
        redirect = redirect,
        targetGroupArn = targetGroupArn,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
