@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.alb.kotlin.inputs

import com.pulumi.aws.alb.inputs.ListenerDefaultActionForwardStickinessArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property duration Time period, in seconds, during which requests from a client should be routed to the same target group. The range is 1-604800 seconds (7 days).
 * The following arguments are optional:
 * @property enabled Whether target group stickiness is enabled. Default is `false`.
 */
public data class ListenerDefaultActionForwardStickinessArgs(
    public val duration: Output<Int>,
    public val enabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.alb.inputs.ListenerDefaultActionForwardStickinessArgs> {
    override fun toJava(): com.pulumi.aws.alb.inputs.ListenerDefaultActionForwardStickinessArgs =
        com.pulumi.aws.alb.inputs.ListenerDefaultActionForwardStickinessArgs.builder()
            .duration(duration.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerDefaultActionForwardStickinessArgs].
 */
@PulumiTagMarker
public class ListenerDefaultActionForwardStickinessArgsBuilder internal constructor() {
    private var duration: Output<Int>? = null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value Time period, in seconds, during which requests from a client should be routed to the same target group. The range is 1-604800 seconds (7 days).
     * The following arguments are optional:
     */
    @JvmName("jwotckmokmmtbhrc")
    public suspend fun duration(`value`: Output<Int>) {
        this.duration = value
    }

    /**
     * @param value Whether target group stickiness is enabled. Default is `false`.
     */
    @JvmName("svsqrgifhewqetdf")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Time period, in seconds, during which requests from a client should be routed to the same target group. The range is 1-604800 seconds (7 days).
     * The following arguments are optional:
     */
    @JvmName("lfrlchltswbspknj")
    public suspend fun duration(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    /**
     * @param value Whether target group stickiness is enabled. Default is `false`.
     */
    @JvmName("ngykperupqbseyfu")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): ListenerDefaultActionForwardStickinessArgs =
        ListenerDefaultActionForwardStickinessArgs(
            duration = duration ?: throw PulumiNullFieldException("duration"),
            enabled = enabled,
        )
}
