@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.alb.kotlin.inputs

import com.pulumi.aws.alb.inputs.ListenerRuleActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property authenticateCognito Information for creating an authenticate action using Cognito. Required if `type` is `authenticate-cognito`.
 * @property authenticateOidc Information for creating an authenticate action using OIDC. Required if `type` is `authenticate-oidc`.
 * @property fixedResponse Information for creating an action that returns a custom HTTP response. Required if `type` is `fixed-response`.
 * @property forward Information for creating an action that distributes requests among one or more target groups. Specify only if `type` is `forward`. If you specify both `forward` block and `target_group_arn` attribute, you can specify only one target group using `forward` and it must be the same target group specified in `target_group_arn`.
 * @property order
 * @property redirect Information for creating a redirect action. Required if `type` is `redirect`.
 * @property targetGroupArn The ARN of the Target Group to which to route traffic. Specify only if `type` is `forward` and you want to route to a single target group. To route to one or more target groups, use a `forward` block instead.
 * @property type The type of routing action. Valid values are `forward`, `redirect`, `fixed-response`, `authenticate-cognito` and `authenticate-oidc`.
 */
public data class ListenerRuleActionArgs(
    public val authenticateCognito: Output<ListenerRuleActionAuthenticateCognitoArgs>? = null,
    public val authenticateOidc: Output<ListenerRuleActionAuthenticateOidcArgs>? = null,
    public val fixedResponse: Output<ListenerRuleActionFixedResponseArgs>? = null,
    public val forward: Output<ListenerRuleActionForwardArgs>? = null,
    public val order: Output<Int>? = null,
    public val redirect: Output<ListenerRuleActionRedirectArgs>? = null,
    public val targetGroupArn: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.alb.inputs.ListenerRuleActionArgs> {
    override fun toJava(): com.pulumi.aws.alb.inputs.ListenerRuleActionArgs =
        com.pulumi.aws.alb.inputs.ListenerRuleActionArgs.builder()
            .authenticateCognito(
                authenticateCognito?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .authenticateOidc(authenticateOidc?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fixedResponse(fixedResponse?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .forward(forward?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .order(order?.applyValue({ args0 -> args0 }))
            .redirect(redirect?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .targetGroupArn(targetGroupArn?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ListenerRuleActionArgs].
 */
@PulumiTagMarker
public class ListenerRuleActionArgsBuilder internal constructor() {
    private var authenticateCognito: Output<ListenerRuleActionAuthenticateCognitoArgs>? = null

    private var authenticateOidc: Output<ListenerRuleActionAuthenticateOidcArgs>? = null

    private var fixedResponse: Output<ListenerRuleActionFixedResponseArgs>? = null

    private var forward: Output<ListenerRuleActionForwardArgs>? = null

    private var order: Output<Int>? = null

    private var redirect: Output<ListenerRuleActionRedirectArgs>? = null

    private var targetGroupArn: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Information for creating an authenticate action using Cognito. Required if `type` is `authenticate-cognito`.
     */
    @JvmName("vviftpqejcevpgla")
    public suspend
    fun authenticateCognito(`value`: Output<ListenerRuleActionAuthenticateCognitoArgs>) {
        this.authenticateCognito = value
    }

    /**
     * @param value Information for creating an authenticate action using OIDC. Required if `type` is `authenticate-oidc`.
     */
    @JvmName("pqgktkcgqhqnjude")
    public suspend fun authenticateOidc(`value`: Output<ListenerRuleActionAuthenticateOidcArgs>) {
        this.authenticateOidc = value
    }

    /**
     * @param value Information for creating an action that returns a custom HTTP response. Required if `type` is `fixed-response`.
     */
    @JvmName("lbbxgkqbjptgvfgw")
    public suspend fun fixedResponse(`value`: Output<ListenerRuleActionFixedResponseArgs>) {
        this.fixedResponse = value
    }

    /**
     * @param value Information for creating an action that distributes requests among one or more target groups. Specify only if `type` is `forward`. If you specify both `forward` block and `target_group_arn` attribute, you can specify only one target group using `forward` and it must be the same target group specified in `target_group_arn`.
     */
    @JvmName("pqwcxnsqwaboffff")
    public suspend fun forward(`value`: Output<ListenerRuleActionForwardArgs>) {
        this.forward = value
    }

    /**
     * @param value
     */
    @JvmName("wnatcxgxmpturqgx")
    public suspend fun order(`value`: Output<Int>) {
        this.order = value
    }

    /**
     * @param value Information for creating a redirect action. Required if `type` is `redirect`.
     */
    @JvmName("aqgrjrojbtyugmpa")
    public suspend fun redirect(`value`: Output<ListenerRuleActionRedirectArgs>) {
        this.redirect = value
    }

    /**
     * @param value The ARN of the Target Group to which to route traffic. Specify only if `type` is `forward` and you want to route to a single target group. To route to one or more target groups, use a `forward` block instead.
     */
    @JvmName("agwkthehndhudcak")
    public suspend fun targetGroupArn(`value`: Output<String>) {
        this.targetGroupArn = value
    }

    /**
     * @param value The type of routing action. Valid values are `forward`, `redirect`, `fixed-response`, `authenticate-cognito` and `authenticate-oidc`.
     */
    @JvmName("myynvlcaxipjowbu")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Information for creating an authenticate action using Cognito. Required if `type` is `authenticate-cognito`.
     */
    @JvmName("xbougkicugjkkgnf")
    public suspend fun authenticateCognito(`value`: ListenerRuleActionAuthenticateCognitoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticateCognito = mapped
    }

    /**
     * @param argument Information for creating an authenticate action using Cognito. Required if `type` is `authenticate-cognito`.
     */
    @JvmName("egbfnymytqcqfyka")
    public suspend
    fun authenticateCognito(argument: suspend ListenerRuleActionAuthenticateCognitoArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerRuleActionAuthenticateCognitoArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.authenticateCognito = mapped
    }

    /**
     * @param value Information for creating an authenticate action using OIDC. Required if `type` is `authenticate-oidc`.
     */
    @JvmName("qampiwdjwrwmpjvw")
    public suspend fun authenticateOidc(`value`: ListenerRuleActionAuthenticateOidcArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticateOidc = mapped
    }

    /**
     * @param argument Information for creating an authenticate action using OIDC. Required if `type` is `authenticate-oidc`.
     */
    @JvmName("kdkilqvscxjphwwm")
    public suspend
    fun authenticateOidc(argument: suspend ListenerRuleActionAuthenticateOidcArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerRuleActionAuthenticateOidcArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.authenticateOidc = mapped
    }

    /**
     * @param value Information for creating an action that returns a custom HTTP response. Required if `type` is `fixed-response`.
     */
    @JvmName("fhtdjjmwxpwbcogl")
    public suspend fun fixedResponse(`value`: ListenerRuleActionFixedResponseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fixedResponse = mapped
    }

    /**
     * @param argument Information for creating an action that returns a custom HTTP response. Required if `type` is `fixed-response`.
     */
    @JvmName("ejrosldguwpoanxw")
    public suspend
    fun fixedResponse(argument: suspend ListenerRuleActionFixedResponseArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerRuleActionFixedResponseArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.fixedResponse = mapped
    }

    /**
     * @param value Information for creating an action that distributes requests among one or more target groups. Specify only if `type` is `forward`. If you specify both `forward` block and `target_group_arn` attribute, you can specify only one target group using `forward` and it must be the same target group specified in `target_group_arn`.
     */
    @JvmName("jescaxuspfqkvyml")
    public suspend fun forward(`value`: ListenerRuleActionForwardArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forward = mapped
    }

    /**
     * @param argument Information for creating an action that distributes requests among one or more target groups. Specify only if `type` is `forward`. If you specify both `forward` block and `target_group_arn` attribute, you can specify only one target group using `forward` and it must be the same target group specified in `target_group_arn`.
     */
    @JvmName("myylspdenscmqiuq")
    public suspend fun forward(argument: suspend ListenerRuleActionForwardArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerRuleActionForwardArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.forward = mapped
    }

    /**
     * @param value
     */
    @JvmName("gfoblwhqejwpiabw")
    public suspend fun order(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.order = mapped
    }

    /**
     * @param value Information for creating a redirect action. Required if `type` is `redirect`.
     */
    @JvmName("cmwigokyktcjtutu")
    public suspend fun redirect(`value`: ListenerRuleActionRedirectArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redirect = mapped
    }

    /**
     * @param argument Information for creating a redirect action. Required if `type` is `redirect`.
     */
    @JvmName("xhtjgvnrmuerorkf")
    public suspend fun redirect(argument: suspend ListenerRuleActionRedirectArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerRuleActionRedirectArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.redirect = mapped
    }

    /**
     * @param value The ARN of the Target Group to which to route traffic. Specify only if `type` is `forward` and you want to route to a single target group. To route to one or more target groups, use a `forward` block instead.
     */
    @JvmName("ocrfbegdfskiaqvr")
    public suspend fun targetGroupArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetGroupArn = mapped
    }

    /**
     * @param value The type of routing action. Valid values are `forward`, `redirect`, `fixed-response`, `authenticate-cognito` and `authenticate-oidc`.
     */
    @JvmName("opimcekbsfvsboto")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ListenerRuleActionArgs = ListenerRuleActionArgs(
        authenticateCognito = authenticateCognito,
        authenticateOidc = authenticateOidc,
        fixedResponse = fixedResponse,
        forward = forward,
        order = order,
        redirect = redirect,
        targetGroupArn = targetGroupArn,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
