@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.alb.kotlin.inputs

import com.pulumi.aws.alb.inputs.ListenerRuleConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property hostHeader Contains a single `values` item which is a list of host header patterns to match. The maximum size of each pattern is 128 characters. Comparison is case insensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). Only one pattern needs to match for the condition to be satisfied.
 * @property httpHeader HTTP headers to match. HTTP Header block fields documented below.
 * @property httpRequestMethod Contains a single `values` item which is a list of HTTP request methods or verbs to match. Maximum size is 40 characters. Only allowed characters are A-Z, hyphen (-) and underscore (\_). Comparison is case sensitive. Wildcards are not supported. Only one needs to match for the condition to be satisfied. AWS recommends that GET and HEAD requests are routed in the same way because the response to a HEAD request may be cached.
 * @property pathPattern Contains a single `values` item which is a list of path patterns to match against the request URL. Maximum size of each pattern is 128 characters. Comparison is case sensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). Only one pattern needs to match for the condition to be satisfied. Path pattern is compared only to the path of the URL, not to its query string. To compare against the query string, use a `query_string` condition.
 * @property queryStrings Query strings to match. Query String block fields documented below.
 * @property sourceIp Contains a single `values` item which is a list of source IP CIDR notations to match. You can use both IPv4 and IPv6 addresses. Wildcards are not supported. Condition is satisfied if the source IP address of the request matches one of the CIDR blocks. Condition is not satisfied by the addresses in the `X-Forwarded-For` header, use `http_header` condition instead.
 * > **NOTE::** Exactly one of `host_header`, `http_header`, `http_request_method`, `path_pattern`, `query_string` or `source_ip` must be set per condition.
 */
public data class ListenerRuleConditionArgs(
    public val hostHeader: Output<ListenerRuleConditionHostHeaderArgs>? = null,
    public val httpHeader: Output<ListenerRuleConditionHttpHeaderArgs>? = null,
    public val httpRequestMethod: Output<ListenerRuleConditionHttpRequestMethodArgs>? = null,
    public val pathPattern: Output<ListenerRuleConditionPathPatternArgs>? = null,
    public val queryStrings: Output<List<ListenerRuleConditionQueryStringArgs>>? = null,
    public val sourceIp: Output<ListenerRuleConditionSourceIpArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.alb.inputs.ListenerRuleConditionArgs> {
    override fun toJava(): com.pulumi.aws.alb.inputs.ListenerRuleConditionArgs =
        com.pulumi.aws.alb.inputs.ListenerRuleConditionArgs.builder()
            .hostHeader(hostHeader?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .httpHeader(httpHeader?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .httpRequestMethod(httpRequestMethod?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .pathPattern(pathPattern?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .queryStrings(
                queryStrings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sourceIp(sourceIp?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ListenerRuleConditionArgs].
 */
@PulumiTagMarker
public class ListenerRuleConditionArgsBuilder internal constructor() {
    private var hostHeader: Output<ListenerRuleConditionHostHeaderArgs>? = null

    private var httpHeader: Output<ListenerRuleConditionHttpHeaderArgs>? = null

    private var httpRequestMethod: Output<ListenerRuleConditionHttpRequestMethodArgs>? = null

    private var pathPattern: Output<ListenerRuleConditionPathPatternArgs>? = null

    private var queryStrings: Output<List<ListenerRuleConditionQueryStringArgs>>? = null

    private var sourceIp: Output<ListenerRuleConditionSourceIpArgs>? = null

    /**
     * @param value Contains a single `values` item which is a list of host header patterns to match. The maximum size of each pattern is 128 characters. Comparison is case insensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). Only one pattern needs to match for the condition to be satisfied.
     */
    @JvmName("kootpdfsoehesufl")
    public suspend fun hostHeader(`value`: Output<ListenerRuleConditionHostHeaderArgs>) {
        this.hostHeader = value
    }

    /**
     * @param value HTTP headers to match. HTTP Header block fields documented below.
     */
    @JvmName("hqashaidyamvjpfi")
    public suspend fun httpHeader(`value`: Output<ListenerRuleConditionHttpHeaderArgs>) {
        this.httpHeader = value
    }

    /**
     * @param value Contains a single `values` item which is a list of HTTP request methods or verbs to match. Maximum size is 40 characters. Only allowed characters are A-Z, hyphen (-) and underscore (\_). Comparison is case sensitive. Wildcards are not supported. Only one needs to match for the condition to be satisfied. AWS recommends that GET and HEAD requests are routed in the same way because the response to a HEAD request may be cached.
     */
    @JvmName("bpslgkkhrhulwwfv")
    public suspend
    fun httpRequestMethod(`value`: Output<ListenerRuleConditionHttpRequestMethodArgs>) {
        this.httpRequestMethod = value
    }

    /**
     * @param value Contains a single `values` item which is a list of path patterns to match against the request URL. Maximum size of each pattern is 128 characters. Comparison is case sensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). Only one pattern needs to match for the condition to be satisfied. Path pattern is compared only to the path of the URL, not to its query string. To compare against the query string, use a `query_string` condition.
     */
    @JvmName("ollrqbddlfdngemn")
    public suspend fun pathPattern(`value`: Output<ListenerRuleConditionPathPatternArgs>) {
        this.pathPattern = value
    }

    /**
     * @param value Query strings to match. Query String block fields documented below.
     */
    @JvmName("yymupbntjojaasgq")
    public suspend fun queryStrings(`value`: Output<List<ListenerRuleConditionQueryStringArgs>>) {
        this.queryStrings = value
    }

    @JvmName("viljdgldavkunele")
    public suspend fun queryStrings(vararg values: Output<ListenerRuleConditionQueryStringArgs>) {
        this.queryStrings = Output.all(values.asList())
    }

    /**
     * @param values Query strings to match. Query String block fields documented below.
     */
    @JvmName("pcowijfqvevkqqoq")
    public suspend fun queryStrings(values: List<Output<ListenerRuleConditionQueryStringArgs>>) {
        this.queryStrings = Output.all(values)
    }

    /**
     * @param value Contains a single `values` item which is a list of source IP CIDR notations to match. You can use both IPv4 and IPv6 addresses. Wildcards are not supported. Condition is satisfied if the source IP address of the request matches one of the CIDR blocks. Condition is not satisfied by the addresses in the `X-Forwarded-For` header, use `http_header` condition instead.
     * > **NOTE::** Exactly one of `host_header`, `http_header`, `http_request_method`, `path_pattern`, `query_string` or `source_ip` must be set per condition.
     */
    @JvmName("cshemnbkoxjelikk")
    public suspend fun sourceIp(`value`: Output<ListenerRuleConditionSourceIpArgs>) {
        this.sourceIp = value
    }

    /**
     * @param value Contains a single `values` item which is a list of host header patterns to match. The maximum size of each pattern is 128 characters. Comparison is case insensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). Only one pattern needs to match for the condition to be satisfied.
     */
    @JvmName("ocybepuensyuxmtv")
    public suspend fun hostHeader(`value`: ListenerRuleConditionHostHeaderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostHeader = mapped
    }

    /**
     * @param argument Contains a single `values` item which is a list of host header patterns to match. The maximum size of each pattern is 128 characters. Comparison is case insensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). Only one pattern needs to match for the condition to be satisfied.
     */
    @JvmName("pydgfjkauhfjmomu")
    public suspend
    fun hostHeader(argument: suspend ListenerRuleConditionHostHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerRuleConditionHostHeaderArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hostHeader = mapped
    }

    /**
     * @param value HTTP headers to match. HTTP Header block fields documented below.
     */
    @JvmName("pcodwmgsselymqxg")
    public suspend fun httpHeader(`value`: ListenerRuleConditionHttpHeaderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpHeader = mapped
    }

    /**
     * @param argument HTTP headers to match. HTTP Header block fields documented below.
     */
    @JvmName("ufdlgjekptbwjfer")
    public suspend
    fun httpHeader(argument: suspend ListenerRuleConditionHttpHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerRuleConditionHttpHeaderArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.httpHeader = mapped
    }

    /**
     * @param value Contains a single `values` item which is a list of HTTP request methods or verbs to match. Maximum size is 40 characters. Only allowed characters are A-Z, hyphen (-) and underscore (\_). Comparison is case sensitive. Wildcards are not supported. Only one needs to match for the condition to be satisfied. AWS recommends that GET and HEAD requests are routed in the same way because the response to a HEAD request may be cached.
     */
    @JvmName("ahegjnmtnlmvvchd")
    public suspend fun httpRequestMethod(`value`: ListenerRuleConditionHttpRequestMethodArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpRequestMethod = mapped
    }

    /**
     * @param argument Contains a single `values` item which is a list of HTTP request methods or verbs to match. Maximum size is 40 characters. Only allowed characters are A-Z, hyphen (-) and underscore (\_). Comparison is case sensitive. Wildcards are not supported. Only one needs to match for the condition to be satisfied. AWS recommends that GET and HEAD requests are routed in the same way because the response to a HEAD request may be cached.
     */
    @JvmName("rhaltvhdbwbviktd")
    public suspend
    fun httpRequestMethod(argument: suspend ListenerRuleConditionHttpRequestMethodArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerRuleConditionHttpRequestMethodArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.httpRequestMethod = mapped
    }

    /**
     * @param value Contains a single `values` item which is a list of path patterns to match against the request URL. Maximum size of each pattern is 128 characters. Comparison is case sensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). Only one pattern needs to match for the condition to be satisfied. Path pattern is compared only to the path of the URL, not to its query string. To compare against the query string, use a `query_string` condition.
     */
    @JvmName("qpfpalppfpafphna")
    public suspend fun pathPattern(`value`: ListenerRuleConditionPathPatternArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pathPattern = mapped
    }

    /**
     * @param argument Contains a single `values` item which is a list of path patterns to match against the request URL. Maximum size of each pattern is 128 characters. Comparison is case sensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). Only one pattern needs to match for the condition to be satisfied. Path pattern is compared only to the path of the URL, not to its query string. To compare against the query string, use a `query_string` condition.
     */
    @JvmName("qvmnniixkwrguiql")
    public suspend
    fun pathPattern(argument: suspend ListenerRuleConditionPathPatternArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerRuleConditionPathPatternArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.pathPattern = mapped
    }

    /**
     * @param value Query strings to match. Query String block fields documented below.
     */
    @JvmName("bcbxomqklltaisry")
    public suspend fun queryStrings(`value`: List<ListenerRuleConditionQueryStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryStrings = mapped
    }

    /**
     * @param argument Query strings to match. Query String block fields documented below.
     */
    @JvmName("wnlfueelrickovjq")
    public suspend
    fun queryStrings(argument: List<suspend ListenerRuleConditionQueryStringArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ListenerRuleConditionQueryStringArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.queryStrings = mapped
    }

    /**
     * @param argument Query strings to match. Query String block fields documented below.
     */
    @JvmName("kxttxxyfajmehepm")
    public suspend fun queryStrings(
        vararg
        argument: suspend ListenerRuleConditionQueryStringArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ListenerRuleConditionQueryStringArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.queryStrings = mapped
    }

    /**
     * @param argument Query strings to match. Query String block fields documented below.
     */
    @JvmName("gotokxamjhytodck")
    public suspend
    fun queryStrings(argument: suspend ListenerRuleConditionQueryStringArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ListenerRuleConditionQueryStringArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.queryStrings = mapped
    }

    /**
     * @param values Query strings to match. Query String block fields documented below.
     */
    @JvmName("athpdkgblubqgigf")
    public suspend fun queryStrings(vararg values: ListenerRuleConditionQueryStringArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryStrings = mapped
    }

    /**
     * @param value Contains a single `values` item which is a list of source IP CIDR notations to match. You can use both IPv4 and IPv6 addresses. Wildcards are not supported. Condition is satisfied if the source IP address of the request matches one of the CIDR blocks. Condition is not satisfied by the addresses in the `X-Forwarded-For` header, use `http_header` condition instead.
     * > **NOTE::** Exactly one of `host_header`, `http_header`, `http_request_method`, `path_pattern`, `query_string` or `source_ip` must be set per condition.
     */
    @JvmName("qujewxskphidravo")
    public suspend fun sourceIp(`value`: ListenerRuleConditionSourceIpArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIp = mapped
    }

    /**
     * @param argument Contains a single `values` item which is a list of source IP CIDR notations to match. You can use both IPv4 and IPv6 addresses. Wildcards are not supported. Condition is satisfied if the source IP address of the request matches one of the CIDR blocks. Condition is not satisfied by the addresses in the `X-Forwarded-For` header, use `http_header` condition instead.
     * > **NOTE::** Exactly one of `host_header`, `http_header`, `http_request_method`, `path_pattern`, `query_string` or `source_ip` must be set per condition.
     */
    @JvmName("bahgcndnkenkqjbl")
    public suspend
    fun sourceIp(argument: suspend ListenerRuleConditionSourceIpArgsBuilder.() -> Unit) {
        val toBeMapped = ListenerRuleConditionSourceIpArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceIp = mapped
    }

    internal fun build(): ListenerRuleConditionArgs = ListenerRuleConditionArgs(
        hostHeader = hostHeader,
        httpHeader = httpHeader,
        httpRequestMethod = httpRequestMethod,
        pathPattern = pathPattern,
        queryStrings = queryStrings,
        sourceIp = sourceIp,
    )
}
