@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.alb.kotlin.inputs

import com.pulumi.aws.alb.inputs.TargetGroupStickinessArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cookieDuration Only used when the type is `lb_cookie`. The time period, in seconds, during which requests from a client should be routed to the same target. After this time period expires, the load balancer-generated cookie is considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day (86400 seconds).
 * @property cookieName Name of the application based cookie. AWSALB, AWSALBAPP, and AWSALBTG prefixes are reserved and cannot be used. Only needed when type is `app_cookie`.
 * @property enabled Boolean to enable / disable `stickiness`. Default is `true`.
 * @property type The type of sticky sessions. The only current possible values are `lb_cookie`, `app_cookie` for ALBs, `source_ip` for NLBs, and `source_ip_dest_ip`, `source_ip_dest_ip_proto` for GWLBs.
 */
public data class TargetGroupStickinessArgs(
    public val cookieDuration: Output<Int>? = null,
    public val cookieName: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.alb.inputs.TargetGroupStickinessArgs> {
    override fun toJava(): com.pulumi.aws.alb.inputs.TargetGroupStickinessArgs =
        com.pulumi.aws.alb.inputs.TargetGroupStickinessArgs.builder()
            .cookieDuration(cookieDuration?.applyValue({ args0 -> args0 }))
            .cookieName(cookieName?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TargetGroupStickinessArgs].
 */
@PulumiTagMarker
public class TargetGroupStickinessArgsBuilder internal constructor() {
    private var cookieDuration: Output<Int>? = null

    private var cookieName: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var type: Output<String>? = null

    /**
     * @param value Only used when the type is `lb_cookie`. The time period, in seconds, during which requests from a client should be routed to the same target. After this time period expires, the load balancer-generated cookie is considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day (86400 seconds).
     */
    @JvmName("mlefucsydynbqpqg")
    public suspend fun cookieDuration(`value`: Output<Int>) {
        this.cookieDuration = value
    }

    /**
     * @param value Name of the application based cookie. AWSALB, AWSALBAPP, and AWSALBTG prefixes are reserved and cannot be used. Only needed when type is `app_cookie`.
     */
    @JvmName("sbujjtyqlpabqksk")
    public suspend fun cookieName(`value`: Output<String>) {
        this.cookieName = value
    }

    /**
     * @param value Boolean to enable / disable `stickiness`. Default is `true`.
     */
    @JvmName("cpuxifldutbdbqrd")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The type of sticky sessions. The only current possible values are `lb_cookie`, `app_cookie` for ALBs, `source_ip` for NLBs, and `source_ip_dest_ip`, `source_ip_dest_ip_proto` for GWLBs.
     */
    @JvmName("nfuaubtuadttuotd")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Only used when the type is `lb_cookie`. The time period, in seconds, during which requests from a client should be routed to the same target. After this time period expires, the load balancer-generated cookie is considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day (86400 seconds).
     */
    @JvmName("faygqfwgkanowfpg")
    public suspend fun cookieDuration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cookieDuration = mapped
    }

    /**
     * @param value Name of the application based cookie. AWSALB, AWSALBAPP, and AWSALBTG prefixes are reserved and cannot be used. Only needed when type is `app_cookie`.
     */
    @JvmName("qakfmspdvxfjiwfe")
    public suspend fun cookieName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cookieName = mapped
    }

    /**
     * @param value Boolean to enable / disable `stickiness`. Default is `true`.
     */
    @JvmName("hfpsghwwlaayfjev")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The type of sticky sessions. The only current possible values are `lb_cookie`, `app_cookie` for ALBs, `source_ip` for NLBs, and `source_ip_dest_ip`, `source_ip_dest_ip_proto` for GWLBs.
     */
    @JvmName("srtsoqcjhdyqgssd")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): TargetGroupStickinessArgs = TargetGroupStickinessArgs(
        cookieDuration = cookieDuration,
        cookieName = cookieName,
        enabled = enabled,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
