@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.alb.kotlin.inputs

import com.pulumi.aws.alb.inputs.TargetGroupTargetHealthStateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enableUnhealthyConnectionTermination Indicates whether the load balancer terminates connections to unhealthy targets. Possible values are `true` or `false`. Default: `true`.
 */
public data class TargetGroupTargetHealthStateArgs(
    public val enableUnhealthyConnectionTermination: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.aws.alb.inputs.TargetGroupTargetHealthStateArgs> {
    override fun toJava(): com.pulumi.aws.alb.inputs.TargetGroupTargetHealthStateArgs =
        com.pulumi.aws.alb.inputs.TargetGroupTargetHealthStateArgs.builder()
            .enableUnhealthyConnectionTermination(
                enableUnhealthyConnectionTermination.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [TargetGroupTargetHealthStateArgs].
 */
@PulumiTagMarker
public class TargetGroupTargetHealthStateArgsBuilder internal constructor() {
    private var enableUnhealthyConnectionTermination: Output<Boolean>? = null

    /**
     * @param value Indicates whether the load balancer terminates connections to unhealthy targets. Possible values are `true` or `false`. Default: `true`.
     */
    @JvmName("gyvaqhpfuoygsieg")
    public suspend fun enableUnhealthyConnectionTermination(`value`: Output<Boolean>) {
        this.enableUnhealthyConnectionTermination = value
    }

    /**
     * @param value Indicates whether the load balancer terminates connections to unhealthy targets. Possible values are `true` or `false`. Default: `true`.
     */
    @JvmName("hynekeqqhvcnxljh")
    public suspend fun enableUnhealthyConnectionTermination(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enableUnhealthyConnectionTermination = mapped
    }

    internal fun build(): TargetGroupTargetHealthStateArgs = TargetGroupTargetHealthStateArgs(
        enableUnhealthyConnectionTermination = enableUnhealthyConnectionTermination ?: throw
            PulumiNullFieldException("enableUnhealthyConnectionTermination"),
    )
}
