@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.alb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property authenticationRequestExtraParams
 * @property authorizationEndpoint
 * @property clientId
 * @property clientSecret
 * @property issuer
 * @property onUnauthenticatedRequest
 * @property scope
 * @property sessionCookieName
 * @property sessionTimeout
 * @property tokenEndpoint
 * @property userInfoEndpoint
 */
public data class GetListenerDefaultActionAuthenticateOidc(
    public val authenticationRequestExtraParams: Map<String, String>,
    public val authorizationEndpoint: String,
    public val clientId: String,
    public val clientSecret: String,
    public val issuer: String,
    public val onUnauthenticatedRequest: String,
    public val scope: String,
    public val sessionCookieName: String,
    public val sessionTimeout: Int,
    public val tokenEndpoint: String,
    public val userInfoEndpoint: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.alb.outputs.GetListenerDefaultActionAuthenticateOidc):
            GetListenerDefaultActionAuthenticateOidc = GetListenerDefaultActionAuthenticateOidc(
            authenticationRequestExtraParams = javaType.authenticationRequestExtraParams().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            authorizationEndpoint = javaType.authorizationEndpoint(),
            clientId = javaType.clientId(),
            clientSecret = javaType.clientSecret(),
            issuer = javaType.issuer(),
            onUnauthenticatedRequest = javaType.onUnauthenticatedRequest(),
            scope = javaType.scope(),
            sessionCookieName = javaType.sessionCookieName(),
            sessionTimeout = javaType.sessionTimeout(),
            tokenEndpoint = javaType.tokenEndpoint(),
            userInfoEndpoint = javaType.userInfoEndpoint(),
        )
    }
}
