@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.alb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getListener.
 * @property alpnPolicy
 * @property arn
 * @property certificateArn
 * @property defaultActions
 * @property id The provider-assigned unique ID for this managed resource.
 * @property loadBalancerArn
 * @property port
 * @property protocol
 * @property sslPolicy
 * @property tags
 */
public data class GetListenerResult(
    public val alpnPolicy: String,
    public val arn: String,
    public val certificateArn: String,
    public val defaultActions: List<GetListenerDefaultAction>,
    public val id: String,
    public val loadBalancerArn: String,
    public val port: Int,
    public val protocol: String,
    public val sslPolicy: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.alb.outputs.GetListenerResult): GetListenerResult =
            GetListenerResult(
                alpnPolicy = javaType.alpnPolicy(),
                arn = javaType.arn(),
                certificateArn = javaType.certificateArn(),
                defaultActions = javaType.defaultActions().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.alb.kotlin.outputs.GetListenerDefaultAction.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                loadBalancerArn = javaType.loadBalancerArn(),
                port = javaType.port(),
                protocol = javaType.protocol(),
                sslPolicy = javaType.sslPolicy(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            )
    }
}
