@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.alb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property authenticateCognito Configuration block for using Amazon Cognito to authenticate users. Specify only when `type` is `authenticate-cognito`. Detailed below.
 * @property authenticateOidc Configuration block for an identity provider that is compliant with OpenID Connect (OIDC). Specify only when `type` is `authenticate-oidc`. Detailed below.
 * @property fixedResponse Information for creating an action that returns a custom HTTP response. Required if `type` is `fixed-response`.
 * @property forward Configuration block for creating an action that distributes requests among one or more target groups. Specify only if `type` is `forward`. If you specify both `forward` block and `target_group_arn` attribute, you can specify only one target group using `forward` and it must be the same target group specified in `target_group_arn`. Detailed below.
 * @property order Order for the action. This value is required for rules with multiple actions. The action with the lowest value for order is performed first. Valid values are between `1` and `50000`.
 * @property redirect Configuration block for creating a redirect action. Required if `type` is `redirect`. Detailed below.
 * @property targetGroupArn ARN of the Target Group to which to route traffic. Specify only if `type` is `forward` and you want to route to a single target group. To route to one or more target groups, use a `forward` block instead.
 * @property type Type of routing action. Valid values are `forward`, `redirect`, `fixed-response`, `authenticate-cognito` and `authenticate-oidc`.
 * The following arguments are optional:
 */
public data class ListenerDefaultAction(
    public val authenticateCognito: ListenerDefaultActionAuthenticateCognito? = null,
    public val authenticateOidc: ListenerDefaultActionAuthenticateOidc? = null,
    public val fixedResponse: ListenerDefaultActionFixedResponse? = null,
    public val forward: ListenerDefaultActionForward? = null,
    public val order: Int? = null,
    public val redirect: ListenerDefaultActionRedirect? = null,
    public val targetGroupArn: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.alb.outputs.ListenerDefaultAction):
            ListenerDefaultAction = ListenerDefaultAction(
            authenticateCognito = javaType.authenticateCognito().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.alb.kotlin.outputs.ListenerDefaultActionAuthenticateCognito.Companion.toKotlin(args0)
                })
            }).orElse(null),
            authenticateOidc = javaType.authenticateOidc().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.alb.kotlin.outputs.ListenerDefaultActionAuthenticateOidc.Companion.toKotlin(args0)
                })
            }).orElse(null),
            fixedResponse = javaType.fixedResponse().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.alb.kotlin.outputs.ListenerDefaultActionFixedResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            forward = javaType.forward().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.alb.kotlin.outputs.ListenerDefaultActionForward.Companion.toKotlin(args0)
                })
            }).orElse(null),
            order = javaType.order().map({ args0 -> args0 }).orElse(null),
            redirect = javaType.redirect().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.alb.kotlin.outputs.ListenerDefaultActionRedirect.Companion.toKotlin(args0)
                })
            }).orElse(null),
            targetGroupArn = javaType.targetGroupArn().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
