@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.alb.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucket The S3 bucket name to store the logs in.
 * @property enabled Boolean to enable / disable `access_logs`. Defaults to `false`, even when `bucket` is specified.
 * @property prefix The S3 bucket prefix. Logs are stored in the root if not configured.
 */
public data class LoadBalancerAccessLogs(
    public val bucket: String,
    public val enabled: Boolean? = null,
    public val prefix: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.alb.outputs.LoadBalancerAccessLogs):
            LoadBalancerAccessLogs = LoadBalancerAccessLogs(
            bucket = javaType.bucket(),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
        )
    }
}
