@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amp.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AlertManagerDefinition].
 */
@PulumiTagMarker
public class AlertManagerDefinitionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AlertManagerDefinitionArgs = AlertManagerDefinitionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AlertManagerDefinitionArgsBuilder.() -> Unit) {
        val builder = AlertManagerDefinitionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AlertManagerDefinition {
        val builtJavaResource = com.pulumi.aws.amp.AlertManagerDefinition(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AlertManagerDefinition(builtJavaResource)
    }
}

/**
 * Manages an Amazon Managed Service for Prometheus (AMP) Alert Manager Definition
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amp.Workspace;
 * import com.pulumi.aws.amp.AlertManagerDefinition;
 * import com.pulumi.aws.amp.AlertManagerDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var demoWorkspace = new Workspace("demoWorkspace");
 *         var demoAlertManagerDefinition = new AlertManagerDefinition("demoAlertManagerDefinition", AlertManagerDefinitionArgs.builder()
 *             .workspaceId(demoWorkspace.id())
 *             .definition("""
 * alertmanager_config: |
 *   route:
 *     receiver: 'default'
 *   receivers:
 *     - name: 'default'
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import the prometheus alert manager definition using the workspace identifier. For example:
 * ```sh
 *  $ pulumi import aws:amp/alertManagerDefinition:AlertManagerDefinition demo ws-C6DCB907-F2D7-4D96-957B-66691F865D8B
 * ```
 *
 */
public class AlertManagerDefinition internal constructor(
    override val javaResource: com.pulumi.aws.amp.AlertManagerDefinition,
) : KotlinCustomResource(javaResource, AlertManagerDefinitionMapper) {
    /**
     * the alert manager definition that you want to be applied. See more [in AWS Docs](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-alert-manager.html).
     */
    public val definition: Output<String>
        get() = javaResource.definition().applyValue({ args0 -> args0 })

    /**
     * ID of the prometheus workspace the alert manager definition should be linked to
     */
    public val workspaceId: Output<String>
        get() = javaResource.workspaceId().applyValue({ args0 -> args0 })
}

public object AlertManagerDefinitionMapper : ResourceMapper<AlertManagerDefinition> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.amp.AlertManagerDefinition::class == javaResource::class

    override fun map(javaResource: Resource): AlertManagerDefinition =
        AlertManagerDefinition(javaResource as com.pulumi.aws.amp.AlertManagerDefinition)
}

/**
 * @see [AlertManagerDefinition].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AlertManagerDefinition].
 */
public suspend fun alertManagerDefinition(
    name: String,
    block: suspend AlertManagerDefinitionResourceBuilder.() -> Unit,
): AlertManagerDefinition {
    val builder = AlertManagerDefinitionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AlertManagerDefinition].
 * @param name The _unique_ name of the resulting resource.
 */
public fun alertManagerDefinition(name: String): AlertManagerDefinition {
    val builder = AlertManagerDefinitionResourceBuilder()
    builder.name(name)
    return builder.build()
}
