@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amp.kotlin

import com.pulumi.aws.amp.AlertManagerDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages an Amazon Managed Service for Prometheus (AMP) Alert Manager Definition
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amp.Workspace;
 * import com.pulumi.aws.amp.AlertManagerDefinition;
 * import com.pulumi.aws.amp.AlertManagerDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var demoWorkspace = new Workspace("demoWorkspace");
 *         var demoAlertManagerDefinition = new AlertManagerDefinition("demoAlertManagerDefinition", AlertManagerDefinitionArgs.builder()
 *             .workspaceId(demoWorkspace.id())
 *             .definition("""
 * alertmanager_config: |
 *   route:
 *     receiver: 'default'
 *   receivers:
 *     - name: 'default'
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import the prometheus alert manager definition using the workspace identifier. For example:
 * ```sh
 *  $ pulumi import aws:amp/alertManagerDefinition:AlertManagerDefinition demo ws-C6DCB907-F2D7-4D96-957B-66691F865D8B
 * ```
 * @property definition the alert manager definition that you want to be applied. See more [in AWS Docs](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-alert-manager.html).
 * @property workspaceId ID of the prometheus workspace the alert manager definition should be linked to
 */
public data class AlertManagerDefinitionArgs(
    public val definition: Output<String>? = null,
    public val workspaceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.amp.AlertManagerDefinitionArgs> {
    override fun toJava(): com.pulumi.aws.amp.AlertManagerDefinitionArgs =
        com.pulumi.aws.amp.AlertManagerDefinitionArgs.builder()
            .definition(definition?.applyValue({ args0 -> args0 }))
            .workspaceId(workspaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlertManagerDefinitionArgs].
 */
@PulumiTagMarker
public class AlertManagerDefinitionArgsBuilder internal constructor() {
    private var definition: Output<String>? = null

    private var workspaceId: Output<String>? = null

    /**
     * @param value the alert manager definition that you want to be applied. See more [in AWS Docs](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-alert-manager.html).
     */
    @JvmName("deemwvdgjubvxbrx")
    public suspend fun definition(`value`: Output<String>) {
        this.definition = value
    }

    /**
     * @param value ID of the prometheus workspace the alert manager definition should be linked to
     */
    @JvmName("bnxebtqkvduenqua")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value the alert manager definition that you want to be applied. See more [in AWS Docs](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-alert-manager.html).
     */
    @JvmName("kbttcfycscicakka")
    public suspend fun definition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.definition = mapped
    }

    /**
     * @param value ID of the prometheus workspace the alert manager definition should be linked to
     */
    @JvmName("wvhsxpoypqtvxtdt")
    public suspend fun workspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    internal fun build(): AlertManagerDefinitionArgs = AlertManagerDefinitionArgs(
        definition = definition,
        workspaceId = workspaceId,
    )
}
