@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amp.kotlin

import com.pulumi.aws.amp.AmpFunctions.getWorkspacePlain
import com.pulumi.aws.amp.AmpFunctions.getWorkspacesPlain
import com.pulumi.aws.amp.kotlin.inputs.GetWorkspacePlainArgs
import com.pulumi.aws.amp.kotlin.inputs.GetWorkspacePlainArgsBuilder
import com.pulumi.aws.amp.kotlin.inputs.GetWorkspacesPlainArgs
import com.pulumi.aws.amp.kotlin.inputs.GetWorkspacesPlainArgsBuilder
import com.pulumi.aws.amp.kotlin.outputs.GetWorkspaceResult
import com.pulumi.aws.amp.kotlin.outputs.GetWorkspacesResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.amp.kotlin.outputs.GetWorkspaceResult.Companion.toKotlin as getWorkspaceResultToKotlin
import com.pulumi.aws.amp.kotlin.outputs.GetWorkspacesResult.Companion.toKotlin as getWorkspacesResultToKotlin

public object AmpFunctions {
    /**
     * Provides an Amazon Managed Prometheus workspace data source.
     * ## Example Usage
     * ### Basic configuration
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.amp.AmpFunctions;
     * import com.pulumi.aws.amp.inputs.GetWorkspaceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = AmpFunctions.getWorkspace(GetWorkspaceArgs.builder()
     *             .workspaceId("ws-41det8a1-2c67-6a1a-9381-9b83d3d78ef7")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getWorkspace.
     * @return A collection of values returned by getWorkspace.
     */
    public suspend fun getWorkspace(argument: GetWorkspacePlainArgs): GetWorkspaceResult =
        getWorkspaceResultToKotlin(getWorkspacePlain(argument.toJava()).await())

    /**
     * @see [getWorkspace].
     * @param tags Tags assigned to the resource.
     * @param workspaceId Prometheus workspace ID.
     * @return A collection of values returned by getWorkspace.
     */
    public suspend fun getWorkspace(tags: Map<String, String>? = null, workspaceId: String):
        GetWorkspaceResult {
        val argument = GetWorkspacePlainArgs(
            tags = tags,
            workspaceId = workspaceId,
        )
        return getWorkspaceResultToKotlin(getWorkspacePlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspace].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;amp&#46;kotlin&#46;inputs&#46;GetWorkspacePlainArgs].
     * @return A collection of values returned by getWorkspace.
     */
    public suspend fun getWorkspace(argument: suspend GetWorkspacePlainArgsBuilder.() -> Unit):
        GetWorkspaceResult {
        val builder = GetWorkspacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceResultToKotlin(getWorkspacePlain(builtArgument.toJava()).await())
    }

    /**
     * Provides the aliases, ARNs, and workspace IDs of Amazon Prometheus workspaces.
     * ## Example Usage
     * The following example returns all of the workspaces in a region:
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.amp.AmpFunctions;
     * import com.pulumi.aws.amp.inputs.GetWorkspacesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = AmpFunctions.getWorkspaces();
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getWorkspaces.
     * @return A collection of values returned by getWorkspaces.
     */
    public suspend fun getWorkspaces(argument: GetWorkspacesPlainArgs): GetWorkspacesResult =
        getWorkspacesResultToKotlin(getWorkspacesPlain(argument.toJava()).await())

    /**
     * @see [getWorkspaces].
     * @param aliasPrefix Limits results to workspaces with aliases that begin with this value.
     * @return A collection of values returned by getWorkspaces.
     */
    public suspend fun getWorkspaces(aliasPrefix: String? = null): GetWorkspacesResult {
        val argument = GetWorkspacesPlainArgs(
            aliasPrefix = aliasPrefix,
        )
        return getWorkspacesResultToKotlin(getWorkspacesPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspaces].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;amp&#46;kotlin&#46;inputs&#46;GetWorkspacesPlainArgs].
     * @return A collection of values returned by getWorkspaces.
     */
    public suspend fun getWorkspaces(argument: suspend GetWorkspacesPlainArgsBuilder.() -> Unit):
        GetWorkspacesResult {
        val builder = GetWorkspacesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspacesResultToKotlin(getWorkspacesPlain(builtArgument.toJava()).await())
    }
}
