@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amp.kotlin

import com.pulumi.aws.amp.RuleGroupNamespaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages an Amazon Managed Service for Prometheus (AMP) Rule Group Namespace
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amp.Workspace;
 * import com.pulumi.aws.amp.RuleGroupNamespace;
 * import com.pulumi.aws.amp.RuleGroupNamespaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var demoWorkspace = new Workspace("demoWorkspace");
 *         var demoRuleGroupNamespace = new RuleGroupNamespace("demoRuleGroupNamespace", RuleGroupNamespaceArgs.builder()
 *             .workspaceId(demoWorkspace.id())
 *             .data("""
 * groups:
 *   - name: test
 *     rules:
 *     - record: metric:recording_rule
 *       expr: avg(rate(container_cpu_usage_seconds_total[5m]))
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import the prometheus rule group namespace using the arn. For example:
 * ```sh
 *  $ pulumi import aws:amp/ruleGroupNamespace:RuleGroupNamespace demo arn:aws:aps:us-west-2:123456789012:rulegroupsnamespace/IDstring/namespace_name
 * ```
 * @property data the rule group namespace data that you want to be applied. See more [in AWS Docs](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-Ruler.html).
 * @property name The name of the rule group namespace
 * @property workspaceId ID of the prometheus workspace the rule group namespace should be linked to
 */
public data class RuleGroupNamespaceArgs(
    public val `data`: Output<String>? = null,
    public val name: Output<String>? = null,
    public val workspaceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.amp.RuleGroupNamespaceArgs> {
    override fun toJava(): com.pulumi.aws.amp.RuleGroupNamespaceArgs =
        com.pulumi.aws.amp.RuleGroupNamespaceArgs.builder()
            .`data`(`data`?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .workspaceId(workspaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleGroupNamespaceArgs].
 */
@PulumiTagMarker
public class RuleGroupNamespaceArgsBuilder internal constructor() {
    private var `data`: Output<String>? = null

    private var name: Output<String>? = null

    private var workspaceId: Output<String>? = null

    /**
     * @param value the rule group namespace data that you want to be applied. See more [in AWS Docs](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-Ruler.html).
     */
    @JvmName("mmdxjijchqdlgget")
    public suspend fun `data`(`value`: Output<String>) {
        this.`data` = value
    }

    /**
     * @param value The name of the rule group namespace
     */
    @JvmName("wnhuhkyldllqynkn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value ID of the prometheus workspace the rule group namespace should be linked to
     */
    @JvmName("wujjdhcapkgynaqi")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value the rule group namespace data that you want to be applied. See more [in AWS Docs](https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-Ruler.html).
     */
    @JvmName("ojywubaqtyuvsxnp")
    public suspend fun `data`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`data` = mapped
    }

    /**
     * @param value The name of the rule group namespace
     */
    @JvmName("jjcdoelwyefmaoxx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value ID of the prometheus workspace the rule group namespace should be linked to
     */
    @JvmName("botushjfmpdfjcqa")
    public suspend fun workspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    internal fun build(): RuleGroupNamespaceArgs = RuleGroupNamespaceArgs(
        `data` = `data`,
        name = name,
        workspaceId = workspaceId,
    )
}
