@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amp.kotlin.inputs

import com.pulumi.aws.amp.inputs.GetWorkspacesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getWorkspaces.
 * @property aliasPrefix Limits results to workspaces with aliases that begin with this value.
 */
public data class GetWorkspacesPlainArgs(
    public val aliasPrefix: String? = null,
) : ConvertibleToJava<com.pulumi.aws.amp.inputs.GetWorkspacesPlainArgs> {
    override fun toJava(): com.pulumi.aws.amp.inputs.GetWorkspacesPlainArgs =
        com.pulumi.aws.amp.inputs.GetWorkspacesPlainArgs.builder()
            .aliasPrefix(aliasPrefix?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkspacesPlainArgs].
 */
@PulumiTagMarker
public class GetWorkspacesPlainArgsBuilder internal constructor() {
    private var aliasPrefix: String? = null

    /**
     * @param value Limits results to workspaces with aliases that begin with this value.
     */
    @JvmName("qnqsoqfdmcysuonb")
    public suspend fun aliasPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.aliasPrefix = mapped
    }

    internal fun build(): GetWorkspacesPlainArgs = GetWorkspacesPlainArgs(
        aliasPrefix = aliasPrefix,
    )
}
