@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amp.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getWorkspace.
 * @property alias Prometheus workspace alias.
 * @property arn ARN of the Prometheus workspace.
 * @property createdDate Creation date of the Prometheus workspace.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property prometheusEndpoint Endpoint of the Prometheus workspace.
 * @property status Status of the Prometheus workspace.
 * @property tags Tags assigned to the resource.
 * @property workspaceId
 */
public data class GetWorkspaceResult(
    public val alias: String,
    public val arn: String,
    public val createdDate: String,
    public val id: String,
    public val prometheusEndpoint: String,
    public val status: String,
    public val tags: Map<String, String>,
    public val workspaceId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.amp.outputs.GetWorkspaceResult): GetWorkspaceResult =
            GetWorkspaceResult(
                alias = javaType.alias(),
                arn = javaType.arn(),
                createdDate = javaType.createdDate(),
                id = javaType.id(),
                prometheusEndpoint = javaType.prometheusEndpoint(),
                status = javaType.status(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                workspaceId = javaType.workspaceId(),
            )
    }
}
