@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amplify.kotlin

import com.pulumi.aws.amplify.kotlin.outputs.AppAutoBranchCreationConfig
import com.pulumi.aws.amplify.kotlin.outputs.AppCustomRule
import com.pulumi.aws.amplify.kotlin.outputs.AppProductionBranch
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.amplify.kotlin.outputs.AppAutoBranchCreationConfig.Companion.toKotlin as appAutoBranchCreationConfigToKotlin
import com.pulumi.aws.amplify.kotlin.outputs.AppCustomRule.Companion.toKotlin as appCustomRuleToKotlin
import com.pulumi.aws.amplify.kotlin.outputs.AppProductionBranch.Companion.toKotlin as appProductionBranchToKotlin

/**
 * Builder for [App].
 */
@PulumiTagMarker
public class AppResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AppArgs = AppArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AppArgsBuilder.() -> Unit) {
        val builder = AppArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): App {
        val builtJavaResource = com.pulumi.aws.amplify.App(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return App(builtJavaResource)
    }
}

/**
 *  /* /* /*
 * Provides an Amplify App resource, a fullstack serverless app hosted on the [AWS Amplify Console](https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html).
 * > **Note:** When you create/update an Amplify App from the provider, you may end up with the error "BadRequestException: You should at least provide one valid token" because of authentication issues. See the section "Repository with Tokens" below.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amplify.App;
 * import com.pulumi.aws.amplify.AppArgs;
 * import com.pulumi.aws.amplify.inputs.AppCustomRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new App("example", AppArgs.builder()
 *             .buildSpec("""
 *   version: 0.1
 *   frontend:
 *     phases:
 *       preBuild:
 *         commands:
 *           - yarn install
 *       build:
 *         commands:
 *           - yarn run build
 *     artifacts:
 *       baseDirectory: build
 *       files:
 *         - '**/*'
 *     cache:
 *       paths:
 *         - node_modules/**/*
 *             """)
 *             .customRules(AppCustomRuleArgs.builder()
 *                 .source("/<*>")
 *                 .status("404")
 *                 .target("/index.html")
 *                 .build())
 *             .environmentVariables(Map.of("ENV", "test"))
 *             .repository("https://github.com/example/app")
 *             .build());
 *     }
 * }
 * ```
 * ### Repository with Tokens
 * If you create a new Amplify App with the `repository` argument, you also need to set `oauth_token` or `access_token` for authentication. For GitHub, get a [personal access token](https://help.github.com/en/github/authenticating-to-github/creating-a-personal-access-token-for-the-command-line) and set `access_token` as follows:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amplify.App;
 * import com.pulumi.aws.amplify.AppArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new App("example", AppArgs.builder()
 *             .accessToken("...")
 *             .repository("https://github.com/example/app")
 *             .build());
 *     }
 * }
 * ```
 * ### Auto Branch Creation
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amplify.App;
 * import com.pulumi.aws.amplify.AppArgs;
 * import com.pulumi.aws.amplify.inputs.AppAutoBranchCreationConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new App("example", AppArgs.builder()
 *             .autoBranchCreationConfig(AppAutoBranchCreationConfigArgs.builder()
 *                 .enableAutoBuild(true)
 *                 .build())
 *             .autoBranchCreationPatterns(
 *                 "*",
 *                 "*/**")
 *             .enableAutoBranchCreation(true)
 *             .build());
 *     }
 * }
 * ```
 * ### Rewrites and Redirects
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amplify.App;
 * import com.pulumi.aws.amplify.AppArgs;
 * import com.pulumi.aws.amplify.inputs.AppCustomRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new App("example", AppArgs.builder()
 *             .customRules(
 *                 AppCustomRuleArgs.builder()
 *                     .source("/api/<*>")
 *                     .status("200")
 *                     .target("https://api.example.com/api/<*>")
 *                     .build(),
 *                 AppCustomRuleArgs.builder()
 *                     .source("</^[^.]+$|\\.(?!(css|gif|ico|jpg|js|png|txt|svg|woff|ttf|map|json)$)([^.]+$)/>")
 *                     .status("200")
 *                     .target("/index.html")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Custom Image
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amplify.App;
 * import com.pulumi.aws.amplify.AppArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new App("example", AppArgs.builder()
 *             .environmentVariables(Map.of("_CUSTOM_IMAGE", "node:16"))
 *             .build());
 *     }
 * }
 * ```
 * ### Custom Headers
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amplify.App;
 * import com.pulumi.aws.amplify.AppArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new App("example", AppArgs.builder()
 *             .customHeaders("""
 *   customHeaders:
 *     - pattern: '**'
 *       headers:
 *         - key: 'Strict-Transport-Security'
 *           value: 'max-age=31536000; includeSubDomains'
 *         - key: 'X-Frame-Options'
 *           value: 'SAMEORIGIN'
 *         - key: 'X-XSS-Protection'
 *           value: '1; mode=block'
 *         - key: 'X-Content-Type-Options'
 *           value: 'nosniff'
 *         - key: 'Content-Security-Policy'
 *           value: "default-src 'self'"
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Amplify App using Amplify App ID (appId). For example:
 * ```sh
 *  $ pulumi import aws:amplify/app:App example d2ypk4k47z8u6
 * ```
 *  App ID can be obtained from App ARN (e.g., `arn:aws:amplify:us-east-1:12345678:apps/d2ypk4k47z8u6`).
 * */
 */
public class App internal constructor(
    override val javaResource: com.pulumi.aws.amplify.App,
) : KotlinCustomResource(javaResource, AppMapper) {
    /**
     * Personal access token for a third-party source control system for an Amplify app. The personal access token is used to create a webhook and a read-only deploy key. The token is not stored.
     */
    public val accessToken: Output<String>?
        get() = javaResource.accessToken().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN of the Amplify app.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Automated branch creation configuration for an Amplify app. An `auto_branch_creation_config` block is documented below.
     */
    public val autoBranchCreationConfig: Output<AppAutoBranchCreationConfig>
        get() = javaResource.autoBranchCreationConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                appAutoBranchCreationConfigToKotlin(args0)
            })
        })

    /**
     * Automated branch creation glob patterns for an Amplify app.
     */
    public val autoBranchCreationPatterns: Output<List<String>>?
        get() = javaResource.autoBranchCreationPatterns().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Credentials for basic authorization for an Amplify app.
     */
    public val basicAuthCredentials: Output<String>?
        get() = javaResource.basicAuthCredentials().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The [build specification](https://docs.aws.amazon.com/amplify/latest/userguide/build-settings.html) (build spec) for an Amplify app.
     */
    public val buildSpec: Output<String>
        get() = javaResource.buildSpec().applyValue({ args0 -> args0 })

    /**
     * The [custom HTTP headers](https://docs.aws.amazon.com/amplify/latest/userguide/custom-headers.html) for an Amplify app.
     */
    public val customHeaders: Output<String>
        get() = javaResource.customHeaders().applyValue({ args0 -> args0 })

    /**
     * Custom rewrite and redirect rules for an Amplify app. A `custom_rule` block is documented below.
     */
    public val customRules: Output<List<AppCustomRule>>?
        get() = javaResource.customRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> appCustomRuleToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Default domain for the Amplify app.
     */
    public val defaultDomain: Output<String>
        get() = javaResource.defaultDomain().applyValue({ args0 -> args0 })

    /**
     * Description for an Amplify app.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enables automated branch creation for an Amplify app.
     */
    public val enableAutoBranchCreation: Output<Boolean>?
        get() = javaResource.enableAutoBranchCreation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enables basic authorization for an Amplify app. This will apply to all branches that are part of this app.
     */
    public val enableBasicAuth: Output<Boolean>?
        get() = javaResource.enableBasicAuth().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enables auto-building of branches for the Amplify App.
     */
    public val enableBranchAutoBuild: Output<Boolean>?
        get() = javaResource.enableBranchAutoBuild().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository.
     */
    public val enableBranchAutoDeletion: Output<Boolean>?
        get() = javaResource.enableBranchAutoDeletion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Environment variables map for an Amplify app.
     */
    public val environmentVariables: Output<Map<String, String>>?
        get() = javaResource.environmentVariables().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * AWS Identity and Access Management (IAM) service role for an Amplify app.
     */
    public val iamServiceRoleArn: Output<String>?
        get() = javaResource.iamServiceRoleArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name for an Amplify app.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key. The OAuth token is not stored.
     */
    public val oauthToken: Output<String>?
        get() = javaResource.oauthToken().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Platform or framework for an Amplify app. Valid values: `WEB`, `WEB_COMPUTE`. Default value: `WEB`.
     */
    public val platform: Output<String>?
        get() = javaResource.platform().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Describes the information about a production branch for an Amplify app. A `production_branch` block is documented below.
     */
    public val productionBranches: Output<List<AppProductionBranch>>
        get() = javaResource.productionBranches().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> appProductionBranchToKotlin(args0) })
            })
        })

    /**
     * Repository for an Amplify app.
     */
    public val repository: Output<String>?
        get() = javaResource.repository().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object AppMapper : ResourceMapper<App> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.amplify.App::class == javaResource::class

    override fun map(javaResource: Resource): App = App(javaResource as com.pulumi.aws.amplify.App)
}

/**
 * @see [App].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [App].
 */
public suspend fun app(name: String, block: suspend AppResourceBuilder.() -> Unit): App {
    val builder = AppResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [App].
 * @param name The _unique_ name of the resulting resource.
 */
public fun app(name: String): App {
    val builder = AppResourceBuilder()
    builder.name(name)
    return builder.build()
}
