@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amplify.kotlin

import com.pulumi.aws.amplify.AppArgs.builder
import com.pulumi.aws.amplify.kotlin.inputs.AppAutoBranchCreationConfigArgs
import com.pulumi.aws.amplify.kotlin.inputs.AppAutoBranchCreationConfigArgsBuilder
import com.pulumi.aws.amplify.kotlin.inputs.AppCustomRuleArgs
import com.pulumi.aws.amplify.kotlin.inputs.AppCustomRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *  /* /* /*
 * Provides an Amplify App resource, a fullstack serverless app hosted on the [AWS Amplify Console](https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html).
 * > **Note:** When you create/update an Amplify App from the provider, you may end up with the error "BadRequestException: You should at least provide one valid token" because of authentication issues. See the section "Repository with Tokens" below.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amplify.App;
 * import com.pulumi.aws.amplify.AppArgs;
 * import com.pulumi.aws.amplify.inputs.AppCustomRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new App("example", AppArgs.builder()
 *             .buildSpec("""
 *   version: 0.1
 *   frontend:
 *     phases:
 *       preBuild:
 *         commands:
 *           - yarn install
 *       build:
 *         commands:
 *           - yarn run build
 *     artifacts:
 *       baseDirectory: build
 *       files:
 *         - '**/*'
 *     cache:
 *       paths:
 *         - node_modules/**/*
 *             """)
 *             .customRules(AppCustomRuleArgs.builder()
 *                 .source("/<*>")
 *                 .status("404")
 *                 .target("/index.html")
 *                 .build())
 *             .environmentVariables(Map.of("ENV", "test"))
 *             .repository("https://github.com/example/app")
 *             .build());
 *     }
 * }
 * ```
 * ### Repository with Tokens
 * If you create a new Amplify App with the `repository` argument, you also need to set `oauth_token` or `access_token` for authentication. For GitHub, get a [personal access token](https://help.github.com/en/github/authenticating-to-github/creating-a-personal-access-token-for-the-command-line) and set `access_token` as follows:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amplify.App;
 * import com.pulumi.aws.amplify.AppArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new App("example", AppArgs.builder()
 *             .accessToken("...")
 *             .repository("https://github.com/example/app")
 *             .build());
 *     }
 * }
 * ```
 * ### Auto Branch Creation
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amplify.App;
 * import com.pulumi.aws.amplify.AppArgs;
 * import com.pulumi.aws.amplify.inputs.AppAutoBranchCreationConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new App("example", AppArgs.builder()
 *             .autoBranchCreationConfig(AppAutoBranchCreationConfigArgs.builder()
 *                 .enableAutoBuild(true)
 *                 .build())
 *             .autoBranchCreationPatterns(
 *                 "*",
 *                 "*/**")
 *             .enableAutoBranchCreation(true)
 *             .build());
 *     }
 * }
 * ```
 * ### Rewrites and Redirects
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amplify.App;
 * import com.pulumi.aws.amplify.AppArgs;
 * import com.pulumi.aws.amplify.inputs.AppCustomRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new App("example", AppArgs.builder()
 *             .customRules(
 *                 AppCustomRuleArgs.builder()
 *                     .source("/api/<*>")
 *                     .status("200")
 *                     .target("https://api.example.com/api/<*>")
 *                     .build(),
 *                 AppCustomRuleArgs.builder()
 *                     .source("</^[^.]+$|\\.(?!(css|gif|ico|jpg|js|png|txt|svg|woff|ttf|map|json)$)([^.]+$)/>")
 *                     .status("200")
 *                     .target("/index.html")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Custom Image
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amplify.App;
 * import com.pulumi.aws.amplify.AppArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new App("example", AppArgs.builder()
 *             .environmentVariables(Map.of("_CUSTOM_IMAGE", "node:16"))
 *             .build());
 *     }
 * }
 * ```
 * ### Custom Headers
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amplify.App;
 * import com.pulumi.aws.amplify.AppArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new App("example", AppArgs.builder()
 *             .customHeaders("""
 *   customHeaders:
 *     - pattern: '**'
 *       headers:
 *         - key: 'Strict-Transport-Security'
 *           value: 'max-age=31536000; includeSubDomains'
 *         - key: 'X-Frame-Options'
 *           value: 'SAMEORIGIN'
 *         - key: 'X-XSS-Protection'
 *           value: '1; mode=block'
 *         - key: 'X-Content-Type-Options'
 *           value: 'nosniff'
 *         - key: 'Content-Security-Policy'
 *           value: "default-src 'self'"
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Amplify App using Amplify App ID (appId). For example:
 * ```sh
 *  $ pulumi import aws:amplify/app:App example d2ypk4k47z8u6
 * ```
 *  App ID can be obtained from App ARN (e.g., `arn:aws:amplify:us-east-1:12345678:apps/d2ypk4k47z8u6`).
 * @property accessToken Personal access token for a third-party source control system for an Amplify app. The personal access token is used to create a webhook and a read-only deploy key. The token is not stored.
 * @property autoBranchCreationConfig Automated branch creation configuration for an Amplify app. An `auto_branch_creation_config` block is documented below.
 * @property autoBranchCreationPatterns Automated branch creation glob patterns for an Amplify app.
 * @property basicAuthCredentials Credentials for basic authorization for an Amplify app.
 * @property buildSpec The [build specification](https://docs.aws.amazon.com/amplify/latest/userguide/build-settings.html) (build spec) for an Amplify app.
 * @property customHeaders The [custom HTTP headers](https://docs.aws.amazon.com/amplify/latest/userguide/custom-headers.html) for an Amplify app.
 * @property customRules Custom rewrite and redirect rules for an Amplify app. A `custom_rule` block is documented below.
 * @property description Description for an Amplify app.
 * @property enableAutoBranchCreation Enables automated branch creation for an Amplify app.
 * @property enableBasicAuth Enables basic authorization for an Amplify app. This will apply to all branches that are part of this app.
 * @property enableBranchAutoBuild Enables auto-building of branches for the Amplify App.
 * @property enableBranchAutoDeletion Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository.
 * @property environmentVariables Environment variables map for an Amplify app.
 * @property iamServiceRoleArn AWS Identity and Access Management (IAM) service role for an Amplify app.
 * @property name Name for an Amplify app.
 * @property oauthToken OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key. The OAuth token is not stored.
 * @property platform Platform or framework for an Amplify app. Valid values: `WEB`, `WEB_COMPUTE`. Default value: `WEB`.
 * @property repository Repository for an Amplify app.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * */
 */
public data class AppArgs(
    public val accessToken: Output<String>? = null,
    public val autoBranchCreationConfig: Output<AppAutoBranchCreationConfigArgs>? = null,
    public val autoBranchCreationPatterns: Output<List<String>>? = null,
    public val basicAuthCredentials: Output<String>? = null,
    public val buildSpec: Output<String>? = null,
    public val customHeaders: Output<String>? = null,
    public val customRules: Output<List<AppCustomRuleArgs>>? = null,
    public val description: Output<String>? = null,
    public val enableAutoBranchCreation: Output<Boolean>? = null,
    public val enableBasicAuth: Output<Boolean>? = null,
    public val enableBranchAutoBuild: Output<Boolean>? = null,
    public val enableBranchAutoDeletion: Output<Boolean>? = null,
    public val environmentVariables: Output<Map<String, String>>? = null,
    public val iamServiceRoleArn: Output<String>? = null,
    public val name: Output<String>? = null,
    public val oauthToken: Output<String>? = null,
    public val platform: Output<String>? = null,
    public val repository: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.amplify.AppArgs> {
    override fun toJava(): com.pulumi.aws.amplify.AppArgs = com.pulumi.aws.amplify.AppArgs.builder()
        .accessToken(accessToken?.applyValue({ args0 -> args0 }))
        .autoBranchCreationConfig(
            autoBranchCreationConfig?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .autoBranchCreationPatterns(
            autoBranchCreationPatterns?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }),
        )
        .basicAuthCredentials(basicAuthCredentials?.applyValue({ args0 -> args0 }))
        .buildSpec(buildSpec?.applyValue({ args0 -> args0 }))
        .customHeaders(customHeaders?.applyValue({ args0 -> args0 }))
        .customRules(
            customRules?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .description(description?.applyValue({ args0 -> args0 }))
        .enableAutoBranchCreation(enableAutoBranchCreation?.applyValue({ args0 -> args0 }))
        .enableBasicAuth(enableBasicAuth?.applyValue({ args0 -> args0 }))
        .enableBranchAutoBuild(enableBranchAutoBuild?.applyValue({ args0 -> args0 }))
        .enableBranchAutoDeletion(enableBranchAutoDeletion?.applyValue({ args0 -> args0 }))
        .environmentVariables(
            environmentVariables?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        )
        .iamServiceRoleArn(iamServiceRoleArn?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .oauthToken(oauthToken?.applyValue({ args0 -> args0 }))
        .platform(platform?.applyValue({ args0 -> args0 }))
        .repository(repository?.applyValue({ args0 -> args0 }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [AppArgs].
 */
@PulumiTagMarker
public class AppArgsBuilder internal constructor() {
    private var accessToken: Output<String>? = null

    private var autoBranchCreationConfig: Output<AppAutoBranchCreationConfigArgs>? = null

    private var autoBranchCreationPatterns: Output<List<String>>? = null

    private var basicAuthCredentials: Output<String>? = null

    private var buildSpec: Output<String>? = null

    private var customHeaders: Output<String>? = null

    private var customRules: Output<List<AppCustomRuleArgs>>? = null

    private var description: Output<String>? = null

    private var enableAutoBranchCreation: Output<Boolean>? = null

    private var enableBasicAuth: Output<Boolean>? = null

    private var enableBranchAutoBuild: Output<Boolean>? = null

    private var enableBranchAutoDeletion: Output<Boolean>? = null

    private var environmentVariables: Output<Map<String, String>>? = null

    private var iamServiceRoleArn: Output<String>? = null

    private var name: Output<String>? = null

    private var oauthToken: Output<String>? = null

    private var platform: Output<String>? = null

    private var repository: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Personal access token for a third-party source control system for an Amplify app. The personal access token is used to create a webhook and a read-only deploy key. The token is not stored.
     */
    @JvmName("pokaswlivwsmceje")
    public suspend fun accessToken(`value`: Output<String>) {
        this.accessToken = value
    }

    /**
     * @param value Automated branch creation configuration for an Amplify app. An `auto_branch_creation_config` block is documented below.
     */
    @JvmName("olvyieddoatrsfop")
    public suspend fun autoBranchCreationConfig(`value`: Output<AppAutoBranchCreationConfigArgs>) {
        this.autoBranchCreationConfig = value
    }

    /**
     * @param value Automated branch creation glob patterns for an Amplify app.
     */
    @JvmName("hunhowmuecwvdwag")
    public suspend fun autoBranchCreationPatterns(`value`: Output<List<String>>) {
        this.autoBranchCreationPatterns = value
    }

    @JvmName("cvyabqcfbkbjkqmr")
    public suspend fun autoBranchCreationPatterns(vararg values: Output<String>) {
        this.autoBranchCreationPatterns = Output.all(values.asList())
    }

    /**
     * @param values Automated branch creation glob patterns for an Amplify app.
     */
    @JvmName("ywymcksjaewahraf")
    public suspend fun autoBranchCreationPatterns(values: List<Output<String>>) {
        this.autoBranchCreationPatterns = Output.all(values)
    }

    /**
     * @param value Credentials for basic authorization for an Amplify app.
     */
    @JvmName("uwyirsolfkyjpqqm")
    public suspend fun basicAuthCredentials(`value`: Output<String>) {
        this.basicAuthCredentials = value
    }

    /**
     * @param value The [build specification](https://docs.aws.amazon.com/amplify/latest/userguide/build-settings.html) (build spec) for an Amplify app.
     */
    @JvmName("iccsbhppdjjrypcp")
    public suspend fun buildSpec(`value`: Output<String>) {
        this.buildSpec = value
    }

    /**
     * @param value The [custom HTTP headers](https://docs.aws.amazon.com/amplify/latest/userguide/custom-headers.html) for an Amplify app.
     */
    @JvmName("jycsmefgacvenkxu")
    public suspend fun customHeaders(`value`: Output<String>) {
        this.customHeaders = value
    }

    /**
     * @param value Custom rewrite and redirect rules for an Amplify app. A `custom_rule` block is documented below.
     */
    @JvmName("dvmkcmdfpwemcsuo")
    public suspend fun customRules(`value`: Output<List<AppCustomRuleArgs>>) {
        this.customRules = value
    }

    @JvmName("fkvwdihpuotrqqqs")
    public suspend fun customRules(vararg values: Output<AppCustomRuleArgs>) {
        this.customRules = Output.all(values.asList())
    }

    /**
     * @param values Custom rewrite and redirect rules for an Amplify app. A `custom_rule` block is documented below.
     */
    @JvmName("cbaqfjuvijplldel")
    public suspend fun customRules(values: List<Output<AppCustomRuleArgs>>) {
        this.customRules = Output.all(values)
    }

    /**
     * @param value Description for an Amplify app.
     */
    @JvmName("piirxaejapglfsxj")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Enables automated branch creation for an Amplify app.
     */
    @JvmName("emokrekkrdmyulna")
    public suspend fun enableAutoBranchCreation(`value`: Output<Boolean>) {
        this.enableAutoBranchCreation = value
    }

    /**
     * @param value Enables basic authorization for an Amplify app. This will apply to all branches that are part of this app.
     */
    @JvmName("tgxxbpxsypgprrwd")
    public suspend fun enableBasicAuth(`value`: Output<Boolean>) {
        this.enableBasicAuth = value
    }

    /**
     * @param value Enables auto-building of branches for the Amplify App.
     */
    @JvmName("shpcyjkptnduamxj")
    public suspend fun enableBranchAutoBuild(`value`: Output<Boolean>) {
        this.enableBranchAutoBuild = value
    }

    /**
     * @param value Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository.
     */
    @JvmName("qxvjpwxkqqyetiaa")
    public suspend fun enableBranchAutoDeletion(`value`: Output<Boolean>) {
        this.enableBranchAutoDeletion = value
    }

    /**
     * @param value Environment variables map for an Amplify app.
     */
    @JvmName("xiikxhvwsytxlsgu")
    public suspend fun environmentVariables(`value`: Output<Map<String, String>>) {
        this.environmentVariables = value
    }

    /**
     * @param value AWS Identity and Access Management (IAM) service role for an Amplify app.
     */
    @JvmName("ibedcgjxvxhgtqwd")
    public suspend fun iamServiceRoleArn(`value`: Output<String>) {
        this.iamServiceRoleArn = value
    }

    /**
     * @param value Name for an Amplify app.
     */
    @JvmName("tgqwinyilpxqdmrw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key. The OAuth token is not stored.
     */
    @JvmName("vrbiylfwygbqcgmx")
    public suspend fun oauthToken(`value`: Output<String>) {
        this.oauthToken = value
    }

    /**
     * @param value Platform or framework for an Amplify app. Valid values: `WEB`, `WEB_COMPUTE`. Default value: `WEB`.
     */
    @JvmName("xhhobmqxvadfmlnr")
    public suspend fun platform(`value`: Output<String>) {
        this.platform = value
    }

    /**
     * @param value Repository for an Amplify app.
     */
    @JvmName("meiaistfoewrkljg")
    public suspend fun repository(`value`: Output<String>) {
        this.repository = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hweybnbqxxtyjxpm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Personal access token for a third-party source control system for an Amplify app. The personal access token is used to create a webhook and a read-only deploy key. The token is not stored.
     */
    @JvmName("eibkiwevovtypdcj")
    public suspend fun accessToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessToken = mapped
    }

    /**
     * @param value Automated branch creation configuration for an Amplify app. An `auto_branch_creation_config` block is documented below.
     */
    @JvmName("fpxnhdrduvrbnyqh")
    public suspend fun autoBranchCreationConfig(`value`: AppAutoBranchCreationConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoBranchCreationConfig = mapped
    }

    /**
     * @param argument Automated branch creation configuration for an Amplify app. An `auto_branch_creation_config` block is documented below.
     */
    @JvmName("dkoycnprnyshsajx")
    public suspend
    fun autoBranchCreationConfig(argument: suspend AppAutoBranchCreationConfigArgsBuilder.() -> Unit) {
        val toBeMapped = AppAutoBranchCreationConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.autoBranchCreationConfig = mapped
    }

    /**
     * @param value Automated branch creation glob patterns for an Amplify app.
     */
    @JvmName("dxyqnxdiiufsyvwh")
    public suspend fun autoBranchCreationPatterns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoBranchCreationPatterns = mapped
    }

    /**
     * @param values Automated branch creation glob patterns for an Amplify app.
     */
    @JvmName("ylqqpesgxsmfmqib")
    public suspend fun autoBranchCreationPatterns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoBranchCreationPatterns = mapped
    }

    /**
     * @param value Credentials for basic authorization for an Amplify app.
     */
    @JvmName("cahmaimiolicsvkc")
    public suspend fun basicAuthCredentials(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.basicAuthCredentials = mapped
    }

    /**
     * @param value The [build specification](https://docs.aws.amazon.com/amplify/latest/userguide/build-settings.html) (build spec) for an Amplify app.
     */
    @JvmName("fnxudfcnleosiats")
    public suspend fun buildSpec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buildSpec = mapped
    }

    /**
     * @param value The [custom HTTP headers](https://docs.aws.amazon.com/amplify/latest/userguide/custom-headers.html) for an Amplify app.
     */
    @JvmName("poeedrdjtwvdxsac")
    public suspend fun customHeaders(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customHeaders = mapped
    }

    /**
     * @param value Custom rewrite and redirect rules for an Amplify app. A `custom_rule` block is documented below.
     */
    @JvmName("nmobkpuvhpolffgp")
    public suspend fun customRules(`value`: List<AppCustomRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customRules = mapped
    }

    /**
     * @param argument Custom rewrite and redirect rules for an Amplify app. A `custom_rule` block is documented below.
     */
    @JvmName("momqujqbbijsbqqm")
    public suspend fun customRules(argument: List<suspend AppCustomRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AppCustomRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customRules = mapped
    }

    /**
     * @param argument Custom rewrite and redirect rules for an Amplify app. A `custom_rule` block is documented below.
     */
    @JvmName("fcbqxcufcbjdahnv")
    public suspend fun customRules(vararg argument: suspend AppCustomRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AppCustomRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customRules = mapped
    }

    /**
     * @param argument Custom rewrite and redirect rules for an Amplify app. A `custom_rule` block is documented below.
     */
    @JvmName("whnekrhptkiugtbt")
    public suspend fun customRules(argument: suspend AppCustomRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AppCustomRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.customRules = mapped
    }

    /**
     * @param values Custom rewrite and redirect rules for an Amplify app. A `custom_rule` block is documented below.
     */
    @JvmName("uvwluowgddhbjhbe")
    public suspend fun customRules(vararg values: AppCustomRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customRules = mapped
    }

    /**
     * @param value Description for an Amplify app.
     */
    @JvmName("efrwlgwyyaebmayr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Enables automated branch creation for an Amplify app.
     */
    @JvmName("lqkgvucocfuqdrsu")
    public suspend fun enableAutoBranchCreation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAutoBranchCreation = mapped
    }

    /**
     * @param value Enables basic authorization for an Amplify app. This will apply to all branches that are part of this app.
     */
    @JvmName("hffiiswrtcecuysb")
    public suspend fun enableBasicAuth(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableBasicAuth = mapped
    }

    /**
     * @param value Enables auto-building of branches for the Amplify App.
     */
    @JvmName("xsytvvilubkdyedf")
    public suspend fun enableBranchAutoBuild(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableBranchAutoBuild = mapped
    }

    /**
     * @param value Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository.
     */
    @JvmName("tveumfmalntcuuvf")
    public suspend fun enableBranchAutoDeletion(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableBranchAutoDeletion = mapped
    }

    /**
     * @param value Environment variables map for an Amplify app.
     */
    @JvmName("btooefyjjrpkufwk")
    public suspend fun environmentVariables(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param values Environment variables map for an Amplify app.
     */
    @JvmName("dfxfqftlxkpwvcfq")
    public fun environmentVariables(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param value AWS Identity and Access Management (IAM) service role for an Amplify app.
     */
    @JvmName("ouqrxasjhqwijgyw")
    public suspend fun iamServiceRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamServiceRoleArn = mapped
    }

    /**
     * @param value Name for an Amplify app.
     */
    @JvmName("uaqkbvpgfoqmuuqw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key. The OAuth token is not stored.
     */
    @JvmName("ebesolclmysiqbqu")
    public suspend fun oauthToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oauthToken = mapped
    }

    /**
     * @param value Platform or framework for an Amplify app. Valid values: `WEB`, `WEB_COMPUTE`. Default value: `WEB`.
     */
    @JvmName("ntojwduqdjfawpxe")
    public suspend fun platform(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platform = mapped
    }

    /**
     * @param value Repository for an Amplify app.
     */
    @JvmName("eguekhwpuduenqiu")
    public suspend fun repository(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repository = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("trxhbrtnuhqvcxtc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bspesumlfrmsugfx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AppArgs = AppArgs(
        accessToken = accessToken,
        autoBranchCreationConfig = autoBranchCreationConfig,
        autoBranchCreationPatterns = autoBranchCreationPatterns,
        basicAuthCredentials = basicAuthCredentials,
        buildSpec = buildSpec,
        customHeaders = customHeaders,
        customRules = customRules,
        description = description,
        enableAutoBranchCreation = enableAutoBranchCreation,
        enableBasicAuth = enableBasicAuth,
        enableBranchAutoBuild = enableBranchAutoBuild,
        enableBranchAutoDeletion = enableBranchAutoDeletion,
        environmentVariables = environmentVariables,
        iamServiceRoleArn = iamServiceRoleArn,
        name = name,
        oauthToken = oauthToken,
        platform = platform,
        repository = repository,
        tags = tags,
    )
}
