@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amplify.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BackendEnvironment].
 */
@PulumiTagMarker
public class BackendEnvironmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BackendEnvironmentArgs = BackendEnvironmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BackendEnvironmentArgsBuilder.() -> Unit) {
        val builder = BackendEnvironmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BackendEnvironment {
        val builtJavaResource = com.pulumi.aws.amplify.BackendEnvironment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BackendEnvironment(builtJavaResource)
    }
}

/**
 * Provides an Amplify Backend Environment resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amplify.App;
 * import com.pulumi.aws.amplify.BackendEnvironment;
 * import com.pulumi.aws.amplify.BackendEnvironmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleApp = new App("exampleApp");
 *         var exampleBackendEnvironment = new BackendEnvironment("exampleBackendEnvironment", BackendEnvironmentArgs.builder()
 *             .appId(exampleApp.id())
 *             .environmentName("example")
 *             .deploymentArtifacts("app-example-deployment")
 *             .stackName("amplify-app-example")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Amplify backend environment using `app_id` and `environment_name`. For example:
 * ```sh
 *  $ pulumi import aws:amplify/backendEnvironment:BackendEnvironment example d2ypk4k47z8u6/example
 * ```
 *
 */
public class BackendEnvironment internal constructor(
    override val javaResource: com.pulumi.aws.amplify.BackendEnvironment,
) : KotlinCustomResource(javaResource, BackendEnvironmentMapper) {
    /**
     * Unique ID for an Amplify app.
     */
    public val appId: Output<String>
        get() = javaResource.appId().applyValue({ args0 -> args0 })

    /**
     * ARN for a backend environment that is part of an Amplify app.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Name of deployment artifacts.
     */
    public val deploymentArtifacts: Output<String>
        get() = javaResource.deploymentArtifacts().applyValue({ args0 -> args0 })

    /**
     * Name for the backend environment.
     */
    public val environmentName: Output<String>
        get() = javaResource.environmentName().applyValue({ args0 -> args0 })

    /**
     * AWS CloudFormation stack name of a backend environment.
     */
    public val stackName: Output<String>
        get() = javaResource.stackName().applyValue({ args0 -> args0 })
}

public object BackendEnvironmentMapper : ResourceMapper<BackendEnvironment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.amplify.BackendEnvironment::class == javaResource::class

    override fun map(javaResource: Resource): BackendEnvironment = BackendEnvironment(
        javaResource as
            com.pulumi.aws.amplify.BackendEnvironment,
    )
}

/**
 * @see [BackendEnvironment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BackendEnvironment].
 */
public suspend fun backendEnvironment(
    name: String,
    block: suspend BackendEnvironmentResourceBuilder.() -> Unit,
): BackendEnvironment {
    val builder = BackendEnvironmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BackendEnvironment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun backendEnvironment(name: String): BackendEnvironment {
    val builder = BackendEnvironmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
