@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amplify.kotlin

import com.pulumi.aws.amplify.BackendEnvironmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an Amplify Backend Environment resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amplify.App;
 * import com.pulumi.aws.amplify.BackendEnvironment;
 * import com.pulumi.aws.amplify.BackendEnvironmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleApp = new App("exampleApp");
 *         var exampleBackendEnvironment = new BackendEnvironment("exampleBackendEnvironment", BackendEnvironmentArgs.builder()
 *             .appId(exampleApp.id())
 *             .environmentName("example")
 *             .deploymentArtifacts("app-example-deployment")
 *             .stackName("amplify-app-example")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Amplify backend environment using `app_id` and `environment_name`. For example:
 * ```sh
 *  $ pulumi import aws:amplify/backendEnvironment:BackendEnvironment example d2ypk4k47z8u6/example
 * ```
 * @property appId Unique ID for an Amplify app.
 * @property deploymentArtifacts Name of deployment artifacts.
 * @property environmentName Name for the backend environment.
 * @property stackName AWS CloudFormation stack name of a backend environment.
 */
public data class BackendEnvironmentArgs(
    public val appId: Output<String>? = null,
    public val deploymentArtifacts: Output<String>? = null,
    public val environmentName: Output<String>? = null,
    public val stackName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.amplify.BackendEnvironmentArgs> {
    override fun toJava(): com.pulumi.aws.amplify.BackendEnvironmentArgs =
        com.pulumi.aws.amplify.BackendEnvironmentArgs.builder()
            .appId(appId?.applyValue({ args0 -> args0 }))
            .deploymentArtifacts(deploymentArtifacts?.applyValue({ args0 -> args0 }))
            .environmentName(environmentName?.applyValue({ args0 -> args0 }))
            .stackName(stackName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BackendEnvironmentArgs].
 */
@PulumiTagMarker
public class BackendEnvironmentArgsBuilder internal constructor() {
    private var appId: Output<String>? = null

    private var deploymentArtifacts: Output<String>? = null

    private var environmentName: Output<String>? = null

    private var stackName: Output<String>? = null

    /**
     * @param value Unique ID for an Amplify app.
     */
    @JvmName("vfpkysplgxsevpyl")
    public suspend fun appId(`value`: Output<String>) {
        this.appId = value
    }

    /**
     * @param value Name of deployment artifacts.
     */
    @JvmName("ffnxqbiyihlkcnxp")
    public suspend fun deploymentArtifacts(`value`: Output<String>) {
        this.deploymentArtifacts = value
    }

    /**
     * @param value Name for the backend environment.
     */
    @JvmName("eneimdenoxuvspmr")
    public suspend fun environmentName(`value`: Output<String>) {
        this.environmentName = value
    }

    /**
     * @param value AWS CloudFormation stack name of a backend environment.
     */
    @JvmName("flgpfjljpnraygos")
    public suspend fun stackName(`value`: Output<String>) {
        this.stackName = value
    }

    /**
     * @param value Unique ID for an Amplify app.
     */
    @JvmName("irljdkhwbluvipus")
    public suspend fun appId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appId = mapped
    }

    /**
     * @param value Name of deployment artifacts.
     */
    @JvmName("obnarbgcxyfqdtxu")
    public suspend fun deploymentArtifacts(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentArtifacts = mapped
    }

    /**
     * @param value Name for the backend environment.
     */
    @JvmName("erwesfuuvuvkcjpr")
    public suspend fun environmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentName = mapped
    }

    /**
     * @param value AWS CloudFormation stack name of a backend environment.
     */
    @JvmName("ymwpavauhudkjcif")
    public suspend fun stackName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackName = mapped
    }

    internal fun build(): BackendEnvironmentArgs = BackendEnvironmentArgs(
        appId = appId,
        deploymentArtifacts = deploymentArtifacts,
        environmentName = environmentName,
        stackName = stackName,
    )
}
