@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amplify.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Branch].
 */
@PulumiTagMarker
public class BranchResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BranchArgs = BranchArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BranchArgsBuilder.() -> Unit) {
        val builder = BranchArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Branch {
        val builtJavaResource = com.pulumi.aws.amplify.Branch(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Branch(builtJavaResource)
    }
}

/**
 * Provides an Amplify Branch resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amplify.App;
 * import com.pulumi.aws.amplify.Branch;
 * import com.pulumi.aws.amplify.BranchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new App("example");
 *         var master = new Branch("master", BranchArgs.builder()
 *             .appId(example.id())
 *             .branchName("master")
 *             .framework("React")
 *             .stage("PRODUCTION")
 *             .environmentVariables(Map.of("REACT_APP_API_SERVER", "https://api.example.com"))
 *             .build());
 *     }
 * }
 * ```
 * ### Notifications
 * Amplify Console uses EventBridge (formerly known as CloudWatch Events) and SNS for email notifications.  To implement the same functionality, you need to set `enable_notification` in a `aws.amplify.Branch` resource, as well as creating an EventBridge Rule, an SNS topic, and SNS subscriptions.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amplify.App;
 * import com.pulumi.aws.amplify.Branch;
 * import com.pulumi.aws.amplify.BranchArgs;
 * import com.pulumi.aws.cloudwatch.EventRule;
 * import com.pulumi.aws.cloudwatch.EventRuleArgs;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.cloudwatch.EventTarget;
 * import com.pulumi.aws.cloudwatch.EventTargetArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventTargetInputTransformerArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.sns.TopicPolicy;
 * import com.pulumi.aws.sns.TopicPolicyArgs;
 * import com.pulumi.aws.sns.TopicSubscription;
 * import com.pulumi.aws.sns.TopicSubscriptionArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new App("example");
 *         var master = new Branch("master", BranchArgs.builder()
 *             .appId(example.id())
 *             .branchName("master")
 *             .enableNotification(true)
 *             .build());
 *         var amplifyAppMasterEventRule = new EventRule("amplifyAppMasterEventRule", EventRuleArgs.builder()
 *             .description(master.branchName().applyValue(branchName -> String.format("AWS Amplify build notifications for :  App: %s Branch: %s", aws_amplify_app.app().id(),branchName)))
 *             .eventPattern(Output.tuple(example.id(), master.branchName()).applyValue(values -> {
 *                 var id = values.t1;
 *                 var branchName = values.t2;
 *                 return serializeJson(
 *                     jsonObject(
 *                         jsonProperty("detail", jsonObject(
 *                             jsonProperty("appId", jsonArray(id)),
 *                             jsonProperty("branchName", jsonArray(branchName)),
 *                             jsonProperty("jobStatus", jsonArray(
 *                                 "SUCCEED",
 *                                 "FAILED",
 *                                 "STARTED"
 *                             ))
 *                         )),
 *                         jsonProperty("detail-type", jsonArray("Amplify Deployment Status Change")),
 *                         jsonProperty("source", jsonArray("aws.amplify"))
 *                     ));
 *             }))
 *             .build());
 *         var amplifyAppMasterTopic = new Topic("amplifyAppMasterTopic");
 *         var amplifyAppMasterEventTarget = new EventTarget("amplifyAppMasterEventTarget", EventTargetArgs.builder()
 *             .rule(amplifyAppMasterEventRule.name())
 *             .arn(amplifyAppMasterTopic.arn())
 *             .inputTransformer(EventTargetInputTransformerArgs.builder()
 *                 .inputPaths(Map.ofEntries(
 *                     Map.entry("jobId", "$.detail.jobId"),
 *                     Map.entry("appId", "$.detail.appId"),
 *                     Map.entry("region", "$.region"),
 *                     Map.entry("branch", "$.detail.branchName"),
 *                     Map.entry("status", "$.detail.jobStatus")
 *                 ))
 *                 .inputTemplate("\"Build notification from the AWS Amplify Console for app: https://<branch>.<appId>.amplifyapp.com/. Your build status is <status>. Go to https://console.aws.amazon.com/amplify/home?region=<region>#<appId>/<branch>/<jobId> to view details on your build. \"")
 *                 .build())
 *             .build());
 *         final var amplifyAppMasterPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid(master.arn().applyValue(arn -> String.format("Allow_Publish_Events %s", arn)))
 *                 .effect("Allow")
 *                 .actions("SNS:Publish")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("events.amazonaws.com")
 *                     .build())
 *                 .resources(amplifyAppMasterTopic.arn())
 *                 .build())
 *             .build());
 *         var amplifyAppMasterTopicPolicy = new TopicPolicy("amplifyAppMasterTopicPolicy", TopicPolicyArgs.builder()
 *             .arn(amplifyAppMasterTopic.arn())
 *             .policy(amplifyAppMasterPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(amplifyAppMasterPolicyDocument -> amplifyAppMasterPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var this_ = new TopicSubscription("this", TopicSubscriptionArgs.builder()
 *             .topic(amplifyAppMasterTopic.arn())
 *             .protocol("email")
 *             .endpoint("user@acme.com")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Amplify branch using `app_id` and `branch_name`. For example:
 * ```sh
 *  $ pulumi import aws:amplify/branch:Branch master d2ypk4k47z8u6/master
 * ```
 *
 */
public class Branch internal constructor(
    override val javaResource: com.pulumi.aws.amplify.Branch,
) : KotlinCustomResource(javaResource, BranchMapper) {
    /**
     * Unique ID for an Amplify app.
     */
    public val appId: Output<String>
        get() = javaResource.appId().applyValue({ args0 -> args0 })

    /**
     * ARN for the branch.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A list of custom resources that are linked to this branch.
     */
    public val associatedResources: Output<List<String>>
        get() = javaResource.associatedResources().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * ARN for a backend environment that is part of an Amplify app.
     */
    public val backendEnvironmentArn: Output<String>?
        get() = javaResource.backendEnvironmentArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Basic authorization credentials for the branch.
     */
    public val basicAuthCredentials: Output<String>?
        get() = javaResource.basicAuthCredentials().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name for the branch.
     */
    public val branchName: Output<String>
        get() = javaResource.branchName().applyValue({ args0 -> args0 })

    /**
     * Custom domains for the branch.
     */
    public val customDomains: Output<List<String>>
        get() = javaResource.customDomains().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Description for the branch.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Destination branch if the branch is a pull request branch.
     */
    public val destinationBranch: Output<String>
        get() = javaResource.destinationBranch().applyValue({ args0 -> args0 })

    /**
     * Display name for a branch. This is used as the default domain prefix.
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * Enables auto building for the branch.
     */
    public val enableAutoBuild: Output<Boolean>?
        get() = javaResource.enableAutoBuild().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enables basic authorization for the branch.
     */
    public val enableBasicAuth: Output<Boolean>?
        get() = javaResource.enableBasicAuth().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enables notifications for the branch.
     */
    public val enableNotification: Output<Boolean>?
        get() = javaResource.enableNotification().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enables performance mode for the branch.
     */
    public val enablePerformanceMode: Output<Boolean>?
        get() = javaResource.enablePerformanceMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enables pull request previews for this branch.
     */
    public val enablePullRequestPreview: Output<Boolean>?
        get() = javaResource.enablePullRequestPreview().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Environment variables for the branch.
     */
    public val environmentVariables: Output<Map<String, String>>?
        get() = javaResource.environmentVariables().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * Framework for the branch.
     */
    public val framework: Output<String>?
        get() = javaResource.framework().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Amplify environment name for the pull request.
     */
    public val pullRequestEnvironmentName: Output<String>?
        get() = javaResource.pullRequestEnvironmentName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Source branch if the branch is a pull request branch.
     */
    public val sourceBranch: Output<String>
        get() = javaResource.sourceBranch().applyValue({ args0 -> args0 })

    /**
     * Describes the current stage for the branch. Valid values: `PRODUCTION`, `BETA`, `DEVELOPMENT`, `EXPERIMENTAL`, `PULL_REQUEST`.
     */
    public val stage: Output<String>?
        get() = javaResource.stage().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Content Time To Live (TTL) for the website in seconds.
     */
    public val ttl: Output<String>?
        get() = javaResource.ttl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object BranchMapper : ResourceMapper<Branch> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.amplify.Branch::class == javaResource::class

    override fun map(javaResource: Resource): Branch = Branch(
        javaResource as
            com.pulumi.aws.amplify.Branch,
    )
}

/**
 * @see [Branch].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Branch].
 */
public suspend fun branch(name: String, block: suspend BranchResourceBuilder.() -> Unit): Branch {
    val builder = BranchResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Branch].
 * @param name The _unique_ name of the resulting resource.
 */
public fun branch(name: String): Branch {
    val builder = BranchResourceBuilder()
    builder.name(name)
    return builder.build()
}
