@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amplify.kotlin

import com.pulumi.aws.amplify.BranchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Amplify Branch resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amplify.App;
 * import com.pulumi.aws.amplify.Branch;
 * import com.pulumi.aws.amplify.BranchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new App("example");
 *         var master = new Branch("master", BranchArgs.builder()
 *             .appId(example.id())
 *             .branchName("master")
 *             .framework("React")
 *             .stage("PRODUCTION")
 *             .environmentVariables(Map.of("REACT_APP_API_SERVER", "https://api.example.com"))
 *             .build());
 *     }
 * }
 * ```
 * ### Notifications
 * Amplify Console uses EventBridge (formerly known as CloudWatch Events) and SNS for email notifications.  To implement the same functionality, you need to set `enable_notification` in a `aws.amplify.Branch` resource, as well as creating an EventBridge Rule, an SNS topic, and SNS subscriptions.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amplify.App;
 * import com.pulumi.aws.amplify.Branch;
 * import com.pulumi.aws.amplify.BranchArgs;
 * import com.pulumi.aws.cloudwatch.EventRule;
 * import com.pulumi.aws.cloudwatch.EventRuleArgs;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.cloudwatch.EventTarget;
 * import com.pulumi.aws.cloudwatch.EventTargetArgs;
 * import com.pulumi.aws.cloudwatch.inputs.EventTargetInputTransformerArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.sns.TopicPolicy;
 * import com.pulumi.aws.sns.TopicPolicyArgs;
 * import com.pulumi.aws.sns.TopicSubscription;
 * import com.pulumi.aws.sns.TopicSubscriptionArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new App("example");
 *         var master = new Branch("master", BranchArgs.builder()
 *             .appId(example.id())
 *             .branchName("master")
 *             .enableNotification(true)
 *             .build());
 *         var amplifyAppMasterEventRule = new EventRule("amplifyAppMasterEventRule", EventRuleArgs.builder()
 *             .description(master.branchName().applyValue(branchName -> String.format("AWS Amplify build notifications for :  App: %s Branch: %s", aws_amplify_app.app().id(),branchName)))
 *             .eventPattern(Output.tuple(example.id(), master.branchName()).applyValue(values -> {
 *                 var id = values.t1;
 *                 var branchName = values.t2;
 *                 return serializeJson(
 *                     jsonObject(
 *                         jsonProperty("detail", jsonObject(
 *                             jsonProperty("appId", jsonArray(id)),
 *                             jsonProperty("branchName", jsonArray(branchName)),
 *                             jsonProperty("jobStatus", jsonArray(
 *                                 "SUCCEED",
 *                                 "FAILED",
 *                                 "STARTED"
 *                             ))
 *                         )),
 *                         jsonProperty("detail-type", jsonArray("Amplify Deployment Status Change")),
 *                         jsonProperty("source", jsonArray("aws.amplify"))
 *                     ));
 *             }))
 *             .build());
 *         var amplifyAppMasterTopic = new Topic("amplifyAppMasterTopic");
 *         var amplifyAppMasterEventTarget = new EventTarget("amplifyAppMasterEventTarget", EventTargetArgs.builder()
 *             .rule(amplifyAppMasterEventRule.name())
 *             .arn(amplifyAppMasterTopic.arn())
 *             .inputTransformer(EventTargetInputTransformerArgs.builder()
 *                 .inputPaths(Map.ofEntries(
 *                     Map.entry("jobId", "$.detail.jobId"),
 *                     Map.entry("appId", "$.detail.appId"),
 *                     Map.entry("region", "$.region"),
 *                     Map.entry("branch", "$.detail.branchName"),
 *                     Map.entry("status", "$.detail.jobStatus")
 *                 ))
 *                 .inputTemplate("\"Build notification from the AWS Amplify Console for app: https://<branch>.<appId>.amplifyapp.com/. Your build status is <status>. Go to https://console.aws.amazon.com/amplify/home?region=<region>#<appId>/<branch>/<jobId> to view details on your build. \"")
 *                 .build())
 *             .build());
 *         final var amplifyAppMasterPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid(master.arn().applyValue(arn -> String.format("Allow_Publish_Events %s", arn)))
 *                 .effect("Allow")
 *                 .actions("SNS:Publish")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("events.amazonaws.com")
 *                     .build())
 *                 .resources(amplifyAppMasterTopic.arn())
 *                 .build())
 *             .build());
 *         var amplifyAppMasterTopicPolicy = new TopicPolicy("amplifyAppMasterTopicPolicy", TopicPolicyArgs.builder()
 *             .arn(amplifyAppMasterTopic.arn())
 *             .policy(amplifyAppMasterPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(amplifyAppMasterPolicyDocument -> amplifyAppMasterPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var this_ = new TopicSubscription("this", TopicSubscriptionArgs.builder()
 *             .topic(amplifyAppMasterTopic.arn())
 *             .protocol("email")
 *             .endpoint("user@acme.com")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Amplify branch using `app_id` and `branch_name`. For example:
 * ```sh
 *  $ pulumi import aws:amplify/branch:Branch master d2ypk4k47z8u6/master
 * ```
 * @property appId Unique ID for an Amplify app.
 * @property backendEnvironmentArn ARN for a backend environment that is part of an Amplify app.
 * @property basicAuthCredentials Basic authorization credentials for the branch.
 * @property branchName Name for the branch.
 * @property description Description for the branch.
 * @property displayName Display name for a branch. This is used as the default domain prefix.
 * @property enableAutoBuild Enables auto building for the branch.
 * @property enableBasicAuth Enables basic authorization for the branch.
 * @property enableNotification Enables notifications for the branch.
 * @property enablePerformanceMode Enables performance mode for the branch.
 * @property enablePullRequestPreview Enables pull request previews for this branch.
 * @property environmentVariables Environment variables for the branch.
 * @property framework Framework for the branch.
 * @property pullRequestEnvironmentName Amplify environment name for the pull request.
 * @property stage Describes the current stage for the branch. Valid values: `PRODUCTION`, `BETA`, `DEVELOPMENT`, `EXPERIMENTAL`, `PULL_REQUEST`.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property ttl Content Time To Live (TTL) for the website in seconds.
 */
public data class BranchArgs(
    public val appId: Output<String>? = null,
    public val backendEnvironmentArn: Output<String>? = null,
    public val basicAuthCredentials: Output<String>? = null,
    public val branchName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val enableAutoBuild: Output<Boolean>? = null,
    public val enableBasicAuth: Output<Boolean>? = null,
    public val enableNotification: Output<Boolean>? = null,
    public val enablePerformanceMode: Output<Boolean>? = null,
    public val enablePullRequestPreview: Output<Boolean>? = null,
    public val environmentVariables: Output<Map<String, String>>? = null,
    public val framework: Output<String>? = null,
    public val pullRequestEnvironmentName: Output<String>? = null,
    public val stage: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val ttl: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.amplify.BranchArgs> {
    override fun toJava(): com.pulumi.aws.amplify.BranchArgs =
        com.pulumi.aws.amplify.BranchArgs.builder()
            .appId(appId?.applyValue({ args0 -> args0 }))
            .backendEnvironmentArn(backendEnvironmentArn?.applyValue({ args0 -> args0 }))
            .basicAuthCredentials(basicAuthCredentials?.applyValue({ args0 -> args0 }))
            .branchName(branchName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .enableAutoBuild(enableAutoBuild?.applyValue({ args0 -> args0 }))
            .enableBasicAuth(enableBasicAuth?.applyValue({ args0 -> args0 }))
            .enableNotification(enableNotification?.applyValue({ args0 -> args0 }))
            .enablePerformanceMode(enablePerformanceMode?.applyValue({ args0 -> args0 }))
            .enablePullRequestPreview(enablePullRequestPreview?.applyValue({ args0 -> args0 }))
            .environmentVariables(
                environmentVariables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .framework(framework?.applyValue({ args0 -> args0 }))
            .pullRequestEnvironmentName(pullRequestEnvironmentName?.applyValue({ args0 -> args0 }))
            .stage(stage?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .ttl(ttl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BranchArgs].
 */
@PulumiTagMarker
public class BranchArgsBuilder internal constructor() {
    private var appId: Output<String>? = null

    private var backendEnvironmentArn: Output<String>? = null

    private var basicAuthCredentials: Output<String>? = null

    private var branchName: Output<String>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var enableAutoBuild: Output<Boolean>? = null

    private var enableBasicAuth: Output<Boolean>? = null

    private var enableNotification: Output<Boolean>? = null

    private var enablePerformanceMode: Output<Boolean>? = null

    private var enablePullRequestPreview: Output<Boolean>? = null

    private var environmentVariables: Output<Map<String, String>>? = null

    private var framework: Output<String>? = null

    private var pullRequestEnvironmentName: Output<String>? = null

    private var stage: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var ttl: Output<String>? = null

    /**
     * @param value Unique ID for an Amplify app.
     */
    @JvmName("nabsgffpbtboalfx")
    public suspend fun appId(`value`: Output<String>) {
        this.appId = value
    }

    /**
     * @param value ARN for a backend environment that is part of an Amplify app.
     */
    @JvmName("hcrnwiqodmjskwqd")
    public suspend fun backendEnvironmentArn(`value`: Output<String>) {
        this.backendEnvironmentArn = value
    }

    /**
     * @param value Basic authorization credentials for the branch.
     */
    @JvmName("sbynlaryijcapnji")
    public suspend fun basicAuthCredentials(`value`: Output<String>) {
        this.basicAuthCredentials = value
    }

    /**
     * @param value Name for the branch.
     */
    @JvmName("nuornbbksndvciue")
    public suspend fun branchName(`value`: Output<String>) {
        this.branchName = value
    }

    /**
     * @param value Description for the branch.
     */
    @JvmName("ceslccfkkxdfeipw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Display name for a branch. This is used as the default domain prefix.
     */
    @JvmName("xmiqviwovidiadir")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Enables auto building for the branch.
     */
    @JvmName("fmyykbbvqonltsla")
    public suspend fun enableAutoBuild(`value`: Output<Boolean>) {
        this.enableAutoBuild = value
    }

    /**
     * @param value Enables basic authorization for the branch.
     */
    @JvmName("wjqcjinsswcgxppm")
    public suspend fun enableBasicAuth(`value`: Output<Boolean>) {
        this.enableBasicAuth = value
    }

    /**
     * @param value Enables notifications for the branch.
     */
    @JvmName("qmieuuhqliatfxkj")
    public suspend fun enableNotification(`value`: Output<Boolean>) {
        this.enableNotification = value
    }

    /**
     * @param value Enables performance mode for the branch.
     */
    @JvmName("bhhhyrujfnkvnvmx")
    public suspend fun enablePerformanceMode(`value`: Output<Boolean>) {
        this.enablePerformanceMode = value
    }

    /**
     * @param value Enables pull request previews for this branch.
     */
    @JvmName("dfulsrdqikyggswo")
    public suspend fun enablePullRequestPreview(`value`: Output<Boolean>) {
        this.enablePullRequestPreview = value
    }

    /**
     * @param value Environment variables for the branch.
     */
    @JvmName("rulgxmhxqeqdicmw")
    public suspend fun environmentVariables(`value`: Output<Map<String, String>>) {
        this.environmentVariables = value
    }

    /**
     * @param value Framework for the branch.
     */
    @JvmName("rvxxuomqshoqmwpx")
    public suspend fun framework(`value`: Output<String>) {
        this.framework = value
    }

    /**
     * @param value Amplify environment name for the pull request.
     */
    @JvmName("mdmagefnllmtypkb")
    public suspend fun pullRequestEnvironmentName(`value`: Output<String>) {
        this.pullRequestEnvironmentName = value
    }

    /**
     * @param value Describes the current stage for the branch. Valid values: `PRODUCTION`, `BETA`, `DEVELOPMENT`, `EXPERIMENTAL`, `PULL_REQUEST`.
     */
    @JvmName("nmhbrnjqcoxoklhb")
    public suspend fun stage(`value`: Output<String>) {
        this.stage = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hvowkhyljcwuohti")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Content Time To Live (TTL) for the website in seconds.
     */
    @JvmName("emesjorkxfxpwrwm")
    public suspend fun ttl(`value`: Output<String>) {
        this.ttl = value
    }

    /**
     * @param value Unique ID for an Amplify app.
     */
    @JvmName("hqglrdejgkcatgxh")
    public suspend fun appId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appId = mapped
    }

    /**
     * @param value ARN for a backend environment that is part of an Amplify app.
     */
    @JvmName("peopbpipkvtvsigw")
    public suspend fun backendEnvironmentArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendEnvironmentArn = mapped
    }

    /**
     * @param value Basic authorization credentials for the branch.
     */
    @JvmName("ulwixjmcjsxvibfa")
    public suspend fun basicAuthCredentials(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.basicAuthCredentials = mapped
    }

    /**
     * @param value Name for the branch.
     */
    @JvmName("dhhbbhnspwqiripl")
    public suspend fun branchName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.branchName = mapped
    }

    /**
     * @param value Description for the branch.
     */
    @JvmName("ksmguqneldqlwgai")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Display name for a branch. This is used as the default domain prefix.
     */
    @JvmName("hkhprbuejbihvchw")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Enables auto building for the branch.
     */
    @JvmName("rxnyddrollmpklcr")
    public suspend fun enableAutoBuild(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAutoBuild = mapped
    }

    /**
     * @param value Enables basic authorization for the branch.
     */
    @JvmName("uuegjstddgfpeqda")
    public suspend fun enableBasicAuth(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableBasicAuth = mapped
    }

    /**
     * @param value Enables notifications for the branch.
     */
    @JvmName("kodfrpcmseekrdvg")
    public suspend fun enableNotification(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableNotification = mapped
    }

    /**
     * @param value Enables performance mode for the branch.
     */
    @JvmName("qmpixwbbvvsrdmkx")
    public suspend fun enablePerformanceMode(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePerformanceMode = mapped
    }

    /**
     * @param value Enables pull request previews for this branch.
     */
    @JvmName("tcyhbrmhgxxvgsci")
    public suspend fun enablePullRequestPreview(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePullRequestPreview = mapped
    }

    /**
     * @param value Environment variables for the branch.
     */
    @JvmName("selqnbscrcluponp")
    public suspend fun environmentVariables(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param values Environment variables for the branch.
     */
    @JvmName("chjncgfavuyibksa")
    public fun environmentVariables(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param value Framework for the branch.
     */
    @JvmName("gdcxltalljcmkhwh")
    public suspend fun framework(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.framework = mapped
    }

    /**
     * @param value Amplify environment name for the pull request.
     */
    @JvmName("rhpgbmnerfctqujr")
    public suspend fun pullRequestEnvironmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pullRequestEnvironmentName = mapped
    }

    /**
     * @param value Describes the current stage for the branch. Valid values: `PRODUCTION`, `BETA`, `DEVELOPMENT`, `EXPERIMENTAL`, `PULL_REQUEST`.
     */
    @JvmName("ovpjptpaelqeltfb")
    public suspend fun stage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stage = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("icwensnuoyktvblw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jnbfwkybrfnulksv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Content Time To Live (TTL) for the website in seconds.
     */
    @JvmName("nufwtjbsblaxnvjj")
    public suspend fun ttl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ttl = mapped
    }

    internal fun build(): BranchArgs = BranchArgs(
        appId = appId,
        backendEnvironmentArn = backendEnvironmentArn,
        basicAuthCredentials = basicAuthCredentials,
        branchName = branchName,
        description = description,
        displayName = displayName,
        enableAutoBuild = enableAutoBuild,
        enableBasicAuth = enableBasicAuth,
        enableNotification = enableNotification,
        enablePerformanceMode = enablePerformanceMode,
        enablePullRequestPreview = enablePullRequestPreview,
        environmentVariables = environmentVariables,
        framework = framework,
        pullRequestEnvironmentName = pullRequestEnvironmentName,
        stage = stage,
        tags = tags,
        ttl = ttl,
    )
}
