@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amplify.kotlin

import com.pulumi.aws.amplify.DomainAssociationArgs.builder
import com.pulumi.aws.amplify.kotlin.inputs.DomainAssociationSubDomainArgs
import com.pulumi.aws.amplify.kotlin.inputs.DomainAssociationSubDomainArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an Amplify Domain Association resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amplify.App;
 * import com.pulumi.aws.amplify.AppArgs;
 * import com.pulumi.aws.amplify.inputs.AppCustomRuleArgs;
 * import com.pulumi.aws.amplify.Branch;
 * import com.pulumi.aws.amplify.BranchArgs;
 * import com.pulumi.aws.amplify.DomainAssociation;
 * import com.pulumi.aws.amplify.DomainAssociationArgs;
 * import com.pulumi.aws.amplify.inputs.DomainAssociationSubDomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleApp = new App("exampleApp", AppArgs.builder()
 *             .customRules(AppCustomRuleArgs.builder()
 *                 .source("https://example.com")
 *                 .status("302")
 *                 .target("https://www.example.com")
 *                 .build())
 *             .build());
 *         var master = new Branch("master", BranchArgs.builder()
 *             .appId(exampleApp.id())
 *             .branchName("master")
 *             .build());
 *         var exampleDomainAssociation = new DomainAssociation("exampleDomainAssociation", DomainAssociationArgs.builder()
 *             .appId(exampleApp.id())
 *             .domainName("example.com")
 *             .subDomains(
 *                 DomainAssociationSubDomainArgs.builder()
 *                     .branchName(master.branchName())
 *                     .prefix("")
 *                     .build(),
 *                 DomainAssociationSubDomainArgs.builder()
 *                     .branchName(master.branchName())
 *                     .prefix("www")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Amplify domain association using `app_id` and `domain_name`. For example:
 * ```sh
 *  $ pulumi import aws:amplify/domainAssociation:DomainAssociation app d2ypk4k47z8u6/example.com
 * ```
 * @property appId Unique ID for an Amplify app.
 * @property domainName Domain name for the domain association.
 * @property enableAutoSubDomain Enables the automated creation of subdomains for branches.
 * @property subDomains Setting for the subdomain. Documented below.
 * @property waitForVerification If enabled, the resource will wait for the domain association status to change to `PENDING_DEPLOYMENT` or `AVAILABLE`. Setting this to `false` will skip the process. Default: `true`.
 */
public data class DomainAssociationArgs(
    public val appId: Output<String>? = null,
    public val domainName: Output<String>? = null,
    public val enableAutoSubDomain: Output<Boolean>? = null,
    public val subDomains: Output<List<DomainAssociationSubDomainArgs>>? = null,
    public val waitForVerification: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.amplify.DomainAssociationArgs> {
    override fun toJava(): com.pulumi.aws.amplify.DomainAssociationArgs =
        com.pulumi.aws.amplify.DomainAssociationArgs.builder()
            .appId(appId?.applyValue({ args0 -> args0 }))
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .enableAutoSubDomain(enableAutoSubDomain?.applyValue({ args0 -> args0 }))
            .subDomains(
                subDomains?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .waitForVerification(waitForVerification?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainAssociationArgs].
 */
@PulumiTagMarker
public class DomainAssociationArgsBuilder internal constructor() {
    private var appId: Output<String>? = null

    private var domainName: Output<String>? = null

    private var enableAutoSubDomain: Output<Boolean>? = null

    private var subDomains: Output<List<DomainAssociationSubDomainArgs>>? = null

    private var waitForVerification: Output<Boolean>? = null

    /**
     * @param value Unique ID for an Amplify app.
     */
    @JvmName("gxcbrmnlxpxpmcml")
    public suspend fun appId(`value`: Output<String>) {
        this.appId = value
    }

    /**
     * @param value Domain name for the domain association.
     */
    @JvmName("jlqmbhaxmpiblgce")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value Enables the automated creation of subdomains for branches.
     */
    @JvmName("wusofjsunekujwnm")
    public suspend fun enableAutoSubDomain(`value`: Output<Boolean>) {
        this.enableAutoSubDomain = value
    }

    /**
     * @param value Setting for the subdomain. Documented below.
     */
    @JvmName("amooprrjudkcqybq")
    public suspend fun subDomains(`value`: Output<List<DomainAssociationSubDomainArgs>>) {
        this.subDomains = value
    }

    @JvmName("mbwrxcxmqtrjkwqq")
    public suspend fun subDomains(vararg values: Output<DomainAssociationSubDomainArgs>) {
        this.subDomains = Output.all(values.asList())
    }

    /**
     * @param values Setting for the subdomain. Documented below.
     */
    @JvmName("wcpodtueiqgiattc")
    public suspend fun subDomains(values: List<Output<DomainAssociationSubDomainArgs>>) {
        this.subDomains = Output.all(values)
    }

    /**
     * @param value If enabled, the resource will wait for the domain association status to change to `PENDING_DEPLOYMENT` or `AVAILABLE`. Setting this to `false` will skip the process. Default: `true`.
     */
    @JvmName("dcoojceyejfkvtyn")
    public suspend fun waitForVerification(`value`: Output<Boolean>) {
        this.waitForVerification = value
    }

    /**
     * @param value Unique ID for an Amplify app.
     */
    @JvmName("sffsjurvbpnuhjpm")
    public suspend fun appId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appId = mapped
    }

    /**
     * @param value Domain name for the domain association.
     */
    @JvmName("rycvwtsfnwgxmbja")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value Enables the automated creation of subdomains for branches.
     */
    @JvmName("isyphllnsokesruh")
    public suspend fun enableAutoSubDomain(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAutoSubDomain = mapped
    }

    /**
     * @param value Setting for the subdomain. Documented below.
     */
    @JvmName("xlnqymylbomvcsmi")
    public suspend fun subDomains(`value`: List<DomainAssociationSubDomainArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subDomains = mapped
    }

    /**
     * @param argument Setting for the subdomain. Documented below.
     */
    @JvmName("wexqvalckuvsuujc")
    public suspend
    fun subDomains(argument: List<suspend DomainAssociationSubDomainArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DomainAssociationSubDomainArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.subDomains = mapped
    }

    /**
     * @param argument Setting for the subdomain. Documented below.
     */
    @JvmName("frndxijhlxcvieog")
    public suspend fun subDomains(
        vararg
        argument: suspend DomainAssociationSubDomainArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DomainAssociationSubDomainArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.subDomains = mapped
    }

    /**
     * @param argument Setting for the subdomain. Documented below.
     */
    @JvmName("vxmmlwndmpcaexie")
    public suspend
    fun subDomains(argument: suspend DomainAssociationSubDomainArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DomainAssociationSubDomainArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.subDomains = mapped
    }

    /**
     * @param values Setting for the subdomain. Documented below.
     */
    @JvmName("eplotynjtxwhofvb")
    public suspend fun subDomains(vararg values: DomainAssociationSubDomainArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subDomains = mapped
    }

    /**
     * @param value If enabled, the resource will wait for the domain association status to change to `PENDING_DEPLOYMENT` or `AVAILABLE`. Setting this to `false` will skip the process. Default: `true`.
     */
    @JvmName("chbsyfijwgklvgsk")
    public suspend fun waitForVerification(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.waitForVerification = mapped
    }

    internal fun build(): DomainAssociationArgs = DomainAssociationArgs(
        appId = appId,
        domainName = domainName,
        enableAutoSubDomain = enableAutoSubDomain,
        subDomains = subDomains,
        waitForVerification = waitForVerification,
    )
}
