@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amplify.kotlin

import com.pulumi.aws.amplify.WebhookArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an Amplify Webhook resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.amplify.App;
 * import com.pulumi.aws.amplify.Branch;
 * import com.pulumi.aws.amplify.BranchArgs;
 * import com.pulumi.aws.amplify.Webhook;
 * import com.pulumi.aws.amplify.WebhookArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new App("example");
 *         var masterBranch = new Branch("masterBranch", BranchArgs.builder()
 *             .appId(example.id())
 *             .branchName("master")
 *             .build());
 *         var masterWebhook = new Webhook("masterWebhook", WebhookArgs.builder()
 *             .appId(example.id())
 *             .branchName(masterBranch.branchName())
 *             .description("triggermaster")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Amplify webhook using a webhook ID. For example:
 * ```sh
 *  $ pulumi import aws:amplify/webhook:Webhook master a26b22a0-748b-4b57-b9a0-ae7e601fe4b1
 * ```
 * @property appId Unique ID for an Amplify app.
 * @property branchName Name for a branch that is part of the Amplify app.
 * @property description Description for a webhook.
 */
public data class WebhookArgs(
    public val appId: Output<String>? = null,
    public val branchName: Output<String>? = null,
    public val description: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.amplify.WebhookArgs> {
    override fun toJava(): com.pulumi.aws.amplify.WebhookArgs =
        com.pulumi.aws.amplify.WebhookArgs.builder()
            .appId(appId?.applyValue({ args0 -> args0 }))
            .branchName(branchName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebhookArgs].
 */
@PulumiTagMarker
public class WebhookArgsBuilder internal constructor() {
    private var appId: Output<String>? = null

    private var branchName: Output<String>? = null

    private var description: Output<String>? = null

    /**
     * @param value Unique ID for an Amplify app.
     */
    @JvmName("ojnwfmamcbtxpkmd")
    public suspend fun appId(`value`: Output<String>) {
        this.appId = value
    }

    /**
     * @param value Name for a branch that is part of the Amplify app.
     */
    @JvmName("errmynbivhlyudre")
    public suspend fun branchName(`value`: Output<String>) {
        this.branchName = value
    }

    /**
     * @param value Description for a webhook.
     */
    @JvmName("eckbafdinlrawcid")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Unique ID for an Amplify app.
     */
    @JvmName("bnrnpesegatqdlag")
    public suspend fun appId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appId = mapped
    }

    /**
     * @param value Name for a branch that is part of the Amplify app.
     */
    @JvmName("uqxsvxctcqbgeyfw")
    public suspend fun branchName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.branchName = mapped
    }

    /**
     * @param value Description for a webhook.
     */
    @JvmName("rrymfncbibhlsdwt")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    internal fun build(): WebhookArgs = WebhookArgs(
        appId = appId,
        branchName = branchName,
        description = description,
    )
}
