@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amplify.kotlin.inputs

import com.pulumi.aws.amplify.inputs.AppAutoBranchCreationConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property basicAuthCredentials Basic authorization credentials for the autocreated branch.
 * @property buildSpec Build specification (build spec) for the autocreated branch.
 * @property enableAutoBuild Enables auto building for the autocreated branch.
 * @property enableBasicAuth Enables basic authorization for the autocreated branch.
 * @property enablePerformanceMode Enables performance mode for the branch.
 * @property enablePullRequestPreview Enables pull request previews for the autocreated branch.
 * @property environmentVariables Environment variables for the autocreated branch.
 * @property framework Framework for the autocreated branch.
 * @property pullRequestEnvironmentName Amplify environment name for the pull request.
 * @property stage Describes the current stage for the autocreated branch. Valid values: `PRODUCTION`, `BETA`, `DEVELOPMENT`, `EXPERIMENTAL`, `PULL_REQUEST`.
 */
public data class AppAutoBranchCreationConfigArgs(
    public val basicAuthCredentials: Output<String>? = null,
    public val buildSpec: Output<String>? = null,
    public val enableAutoBuild: Output<Boolean>? = null,
    public val enableBasicAuth: Output<Boolean>? = null,
    public val enablePerformanceMode: Output<Boolean>? = null,
    public val enablePullRequestPreview: Output<Boolean>? = null,
    public val environmentVariables: Output<Map<String, String>>? = null,
    public val framework: Output<String>? = null,
    public val pullRequestEnvironmentName: Output<String>? = null,
    public val stage: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.amplify.inputs.AppAutoBranchCreationConfigArgs> {
    override fun toJava(): com.pulumi.aws.amplify.inputs.AppAutoBranchCreationConfigArgs =
        com.pulumi.aws.amplify.inputs.AppAutoBranchCreationConfigArgs.builder()
            .basicAuthCredentials(basicAuthCredentials?.applyValue({ args0 -> args0 }))
            .buildSpec(buildSpec?.applyValue({ args0 -> args0 }))
            .enableAutoBuild(enableAutoBuild?.applyValue({ args0 -> args0 }))
            .enableBasicAuth(enableBasicAuth?.applyValue({ args0 -> args0 }))
            .enablePerformanceMode(enablePerformanceMode?.applyValue({ args0 -> args0 }))
            .enablePullRequestPreview(enablePullRequestPreview?.applyValue({ args0 -> args0 }))
            .environmentVariables(
                environmentVariables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .framework(framework?.applyValue({ args0 -> args0 }))
            .pullRequestEnvironmentName(pullRequestEnvironmentName?.applyValue({ args0 -> args0 }))
            .stage(stage?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppAutoBranchCreationConfigArgs].
 */
@PulumiTagMarker
public class AppAutoBranchCreationConfigArgsBuilder internal constructor() {
    private var basicAuthCredentials: Output<String>? = null

    private var buildSpec: Output<String>? = null

    private var enableAutoBuild: Output<Boolean>? = null

    private var enableBasicAuth: Output<Boolean>? = null

    private var enablePerformanceMode: Output<Boolean>? = null

    private var enablePullRequestPreview: Output<Boolean>? = null

    private var environmentVariables: Output<Map<String, String>>? = null

    private var framework: Output<String>? = null

    private var pullRequestEnvironmentName: Output<String>? = null

    private var stage: Output<String>? = null

    /**
     * @param value Basic authorization credentials for the autocreated branch.
     */
    @JvmName("sxpsnkmckdutjere")
    public suspend fun basicAuthCredentials(`value`: Output<String>) {
        this.basicAuthCredentials = value
    }

    /**
     * @param value Build specification (build spec) for the autocreated branch.
     */
    @JvmName("auhqncxbrrhnccgj")
    public suspend fun buildSpec(`value`: Output<String>) {
        this.buildSpec = value
    }

    /**
     * @param value Enables auto building for the autocreated branch.
     */
    @JvmName("qppswrttvshthgvc")
    public suspend fun enableAutoBuild(`value`: Output<Boolean>) {
        this.enableAutoBuild = value
    }

    /**
     * @param value Enables basic authorization for the autocreated branch.
     */
    @JvmName("gxacaqgsfstbkikk")
    public suspend fun enableBasicAuth(`value`: Output<Boolean>) {
        this.enableBasicAuth = value
    }

    /**
     * @param value Enables performance mode for the branch.
     */
    @JvmName("lomsgmpcuctpmoci")
    public suspend fun enablePerformanceMode(`value`: Output<Boolean>) {
        this.enablePerformanceMode = value
    }

    /**
     * @param value Enables pull request previews for the autocreated branch.
     */
    @JvmName("bkhedrrauwaywjgd")
    public suspend fun enablePullRequestPreview(`value`: Output<Boolean>) {
        this.enablePullRequestPreview = value
    }

    /**
     * @param value Environment variables for the autocreated branch.
     */
    @JvmName("leypmxcuuluihmbk")
    public suspend fun environmentVariables(`value`: Output<Map<String, String>>) {
        this.environmentVariables = value
    }

    /**
     * @param value Framework for the autocreated branch.
     */
    @JvmName("mtheauvlthpkfhtq")
    public suspend fun framework(`value`: Output<String>) {
        this.framework = value
    }

    /**
     * @param value Amplify environment name for the pull request.
     */
    @JvmName("jviggbfkehvxrign")
    public suspend fun pullRequestEnvironmentName(`value`: Output<String>) {
        this.pullRequestEnvironmentName = value
    }

    /**
     * @param value Describes the current stage for the autocreated branch. Valid values: `PRODUCTION`, `BETA`, `DEVELOPMENT`, `EXPERIMENTAL`, `PULL_REQUEST`.
     */
    @JvmName("gvrgpfxtqyjrecpn")
    public suspend fun stage(`value`: Output<String>) {
        this.stage = value
    }

    /**
     * @param value Basic authorization credentials for the autocreated branch.
     */
    @JvmName("fdfdrpeohadhhfic")
    public suspend fun basicAuthCredentials(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.basicAuthCredentials = mapped
    }

    /**
     * @param value Build specification (build spec) for the autocreated branch.
     */
    @JvmName("rkphwwniuiqjckqc")
    public suspend fun buildSpec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buildSpec = mapped
    }

    /**
     * @param value Enables auto building for the autocreated branch.
     */
    @JvmName("gnlfgfwyvvbvwnfr")
    public suspend fun enableAutoBuild(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAutoBuild = mapped
    }

    /**
     * @param value Enables basic authorization for the autocreated branch.
     */
    @JvmName("qypsmjqjrmflbsjm")
    public suspend fun enableBasicAuth(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableBasicAuth = mapped
    }

    /**
     * @param value Enables performance mode for the branch.
     */
    @JvmName("sesnxhluqxavonpo")
    public suspend fun enablePerformanceMode(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePerformanceMode = mapped
    }

    /**
     * @param value Enables pull request previews for the autocreated branch.
     */
    @JvmName("hukefgsxlqigeywr")
    public suspend fun enablePullRequestPreview(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePullRequestPreview = mapped
    }

    /**
     * @param value Environment variables for the autocreated branch.
     */
    @JvmName("omkumflybokaisvv")
    public suspend fun environmentVariables(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param values Environment variables for the autocreated branch.
     */
    @JvmName("joinkkcwnbojrjfu")
    public fun environmentVariables(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param value Framework for the autocreated branch.
     */
    @JvmName("fqkyukjqdtwioqwk")
    public suspend fun framework(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.framework = mapped
    }

    /**
     * @param value Amplify environment name for the pull request.
     */
    @JvmName("umiwnpgrvypnlyui")
    public suspend fun pullRequestEnvironmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pullRequestEnvironmentName = mapped
    }

    /**
     * @param value Describes the current stage for the autocreated branch. Valid values: `PRODUCTION`, `BETA`, `DEVELOPMENT`, `EXPERIMENTAL`, `PULL_REQUEST`.
     */
    @JvmName("hclkkhnaifkjbwuj")
    public suspend fun stage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stage = mapped
    }

    internal fun build(): AppAutoBranchCreationConfigArgs = AppAutoBranchCreationConfigArgs(
        basicAuthCredentials = basicAuthCredentials,
        buildSpec = buildSpec,
        enableAutoBuild = enableAutoBuild,
        enableBasicAuth = enableBasicAuth,
        enablePerformanceMode = enablePerformanceMode,
        enablePullRequestPreview = enablePullRequestPreview,
        environmentVariables = environmentVariables,
        framework = framework,
        pullRequestEnvironmentName = pullRequestEnvironmentName,
        stage = stage,
    )
}
