@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amplify.kotlin.inputs

import com.pulumi.aws.amplify.inputs.AppCustomRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property condition Condition for a URL rewrite or redirect rule, such as a country code.
 * @property source Source pattern for a URL rewrite or redirect rule.
 * @property status Status code for a URL rewrite or redirect rule. Valid values: `200`, `301`, `302`, `404`, `404-200`.
 * @property target Target pattern for a URL rewrite or redirect rule.
 */
public data class AppCustomRuleArgs(
    public val condition: Output<String>? = null,
    public val source: Output<String>,
    public val status: Output<String>? = null,
    public val target: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.amplify.inputs.AppCustomRuleArgs> {
    override fun toJava(): com.pulumi.aws.amplify.inputs.AppCustomRuleArgs =
        com.pulumi.aws.amplify.inputs.AppCustomRuleArgs.builder()
            .condition(condition?.applyValue({ args0 -> args0 }))
            .source(source.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .target(target.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppCustomRuleArgs].
 */
@PulumiTagMarker
public class AppCustomRuleArgsBuilder internal constructor() {
    private var condition: Output<String>? = null

    private var source: Output<String>? = null

    private var status: Output<String>? = null

    private var target: Output<String>? = null

    /**
     * @param value Condition for a URL rewrite or redirect rule, such as a country code.
     */
    @JvmName("axfiswjrwxatdkkw")
    public suspend fun condition(`value`: Output<String>) {
        this.condition = value
    }

    /**
     * @param value Source pattern for a URL rewrite or redirect rule.
     */
    @JvmName("nklrrqlyrdcytvlm")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value Status code for a URL rewrite or redirect rule. Valid values: `200`, `301`, `302`, `404`, `404-200`.
     */
    @JvmName("lxypxojheoepedcp")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Target pattern for a URL rewrite or redirect rule.
     */
    @JvmName("ksthqpgaesamjhwq")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value Condition for a URL rewrite or redirect rule, such as a country code.
     */
    @JvmName("ngjoebikcinwpmsn")
    public suspend fun condition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.condition = mapped
    }

    /**
     * @param value Source pattern for a URL rewrite or redirect rule.
     */
    @JvmName("hldcfsfkterewxsr")
    public suspend fun source(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value Status code for a URL rewrite or redirect rule. Valid values: `200`, `301`, `302`, `404`, `404-200`.
     */
    @JvmName("bnhbutcepmdirgkl")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Target pattern for a URL rewrite or redirect rule.
     */
    @JvmName("eodfyfsscmbsicen")
    public suspend fun target(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.target = mapped
    }

    internal fun build(): AppCustomRuleArgs = AppCustomRuleArgs(
        condition = condition,
        source = source ?: throw PulumiNullFieldException("source"),
        status = status,
        target = target ?: throw PulumiNullFieldException("target"),
    )
}
