@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amplify.kotlin.inputs

import com.pulumi.aws.amplify.inputs.DomainAssociationSubDomainArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property branchName Branch name setting for the subdomain.
 * @property dnsRecord DNS record for the subdomain.
 * @property prefix Prefix setting for the subdomain.
 * @property verified Verified status of the subdomain.
 */
public data class DomainAssociationSubDomainArgs(
    public val branchName: Output<String>,
    public val dnsRecord: Output<String>? = null,
    public val prefix: Output<String>,
    public val verified: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.amplify.inputs.DomainAssociationSubDomainArgs> {
    override fun toJava(): com.pulumi.aws.amplify.inputs.DomainAssociationSubDomainArgs =
        com.pulumi.aws.amplify.inputs.DomainAssociationSubDomainArgs.builder()
            .branchName(branchName.applyValue({ args0 -> args0 }))
            .dnsRecord(dnsRecord?.applyValue({ args0 -> args0 }))
            .prefix(prefix.applyValue({ args0 -> args0 }))
            .verified(verified?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainAssociationSubDomainArgs].
 */
@PulumiTagMarker
public class DomainAssociationSubDomainArgsBuilder internal constructor() {
    private var branchName: Output<String>? = null

    private var dnsRecord: Output<String>? = null

    private var prefix: Output<String>? = null

    private var verified: Output<Boolean>? = null

    /**
     * @param value Branch name setting for the subdomain.
     */
    @JvmName("kuiikumocxcounvr")
    public suspend fun branchName(`value`: Output<String>) {
        this.branchName = value
    }

    /**
     * @param value DNS record for the subdomain.
     */
    @JvmName("btulbpyokogjkecj")
    public suspend fun dnsRecord(`value`: Output<String>) {
        this.dnsRecord = value
    }

    /**
     * @param value Prefix setting for the subdomain.
     */
    @JvmName("hpmpmxrjvygmmqkw")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value Verified status of the subdomain.
     */
    @JvmName("qudtndldobwkisca")
    public suspend fun verified(`value`: Output<Boolean>) {
        this.verified = value
    }

    /**
     * @param value Branch name setting for the subdomain.
     */
    @JvmName("gwqlntgfvrxwlbxg")
    public suspend fun branchName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.branchName = mapped
    }

    /**
     * @param value DNS record for the subdomain.
     */
    @JvmName("olslwacaefxlyncd")
    public suspend fun dnsRecord(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsRecord = mapped
    }

    /**
     * @param value Prefix setting for the subdomain.
     */
    @JvmName("qhljssjyacmuabos")
    public suspend fun prefix(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value Verified status of the subdomain.
     */
    @JvmName("hbttqxamciwghrgh")
    public suspend fun verified(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.verified = mapped
    }

    internal fun build(): DomainAssociationSubDomainArgs = DomainAssociationSubDomainArgs(
        branchName = branchName ?: throw PulumiNullFieldException("branchName"),
        dnsRecord = dnsRecord,
        prefix = prefix ?: throw PulumiNullFieldException("prefix"),
        verified = verified,
    )
}
