@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amplify.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property basicAuthCredentials Basic authorization credentials for the autocreated branch.
 * @property buildSpec Build specification (build spec) for the autocreated branch.
 * @property enableAutoBuild Enables auto building for the autocreated branch.
 * @property enableBasicAuth Enables basic authorization for the autocreated branch.
 * @property enablePerformanceMode Enables performance mode for the branch.
 * @property enablePullRequestPreview Enables pull request previews for the autocreated branch.
 * @property environmentVariables Environment variables for the autocreated branch.
 * @property framework Framework for the autocreated branch.
 * @property pullRequestEnvironmentName Amplify environment name for the pull request.
 * @property stage Describes the current stage for the autocreated branch. Valid values: `PRODUCTION`, `BETA`, `DEVELOPMENT`, `EXPERIMENTAL`, `PULL_REQUEST`.
 */
public data class AppAutoBranchCreationConfig(
    public val basicAuthCredentials: String? = null,
    public val buildSpec: String? = null,
    public val enableAutoBuild: Boolean? = null,
    public val enableBasicAuth: Boolean? = null,
    public val enablePerformanceMode: Boolean? = null,
    public val enablePullRequestPreview: Boolean? = null,
    public val environmentVariables: Map<String, String>? = null,
    public val framework: String? = null,
    public val pullRequestEnvironmentName: String? = null,
    public val stage: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.amplify.outputs.AppAutoBranchCreationConfig):
            AppAutoBranchCreationConfig = AppAutoBranchCreationConfig(
            basicAuthCredentials = javaType.basicAuthCredentials().map({ args0 -> args0 }).orElse(null),
            buildSpec = javaType.buildSpec().map({ args0 -> args0 }).orElse(null),
            enableAutoBuild = javaType.enableAutoBuild().map({ args0 -> args0 }).orElse(null),
            enableBasicAuth = javaType.enableBasicAuth().map({ args0 -> args0 }).orElse(null),
            enablePerformanceMode = javaType.enablePerformanceMode().map({ args0 -> args0 }).orElse(null),
            enablePullRequestPreview = javaType.enablePullRequestPreview().map({ args0 -> args0 }).orElse(null),
            environmentVariables = javaType.environmentVariables().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            framework = javaType.framework().map({ args0 -> args0 }).orElse(null),
            pullRequestEnvironmentName = javaType.pullRequestEnvironmentName().map({ args0 ->
                args0
            }).orElse(null),
            stage = javaType.stage().map({ args0 -> args0 }).orElse(null),
        )
    }
}
