@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amplify.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property condition Condition for a URL rewrite or redirect rule, such as a country code.
 * @property source Source pattern for a URL rewrite or redirect rule.
 * @property status Status code for a URL rewrite or redirect rule. Valid values: `200`, `301`, `302`, `404`, `404-200`.
 * @property target Target pattern for a URL rewrite or redirect rule.
 */
public data class AppCustomRule(
    public val condition: String? = null,
    public val source: String,
    public val status: String? = null,
    public val target: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.amplify.outputs.AppCustomRule): AppCustomRule =
            AppCustomRule(
                condition = javaType.condition().map({ args0 -> args0 }).orElse(null),
                source = javaType.source(),
                status = javaType.status().map({ args0 -> args0 }).orElse(null),
                target = javaType.target(),
            )
    }
}
