@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amplify.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property branchName Branch name for the production branch.
 * @property lastDeployTime Last deploy time of the production branch.
 * @property status Status code for a URL rewrite or redirect rule. Valid values: `200`, `301`, `302`, `404`, `404-200`.
 * @property thumbnailUrl Thumbnail URL for the production branch.
 */
public data class AppProductionBranch(
    public val branchName: String? = null,
    public val lastDeployTime: String? = null,
    public val status: String? = null,
    public val thumbnailUrl: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.amplify.outputs.AppProductionBranch):
            AppProductionBranch = AppProductionBranch(
            branchName = javaType.branchName().map({ args0 -> args0 }).orElse(null),
            lastDeployTime = javaType.lastDeployTime().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            thumbnailUrl = javaType.thumbnailUrl().map({ args0 -> args0 }).orElse(null),
        )
    }
}
