@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.amplify.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property branchName Branch name setting for the subdomain.
 * @property dnsRecord DNS record for the subdomain.
 * @property prefix Prefix setting for the subdomain.
 * @property verified Verified status of the subdomain.
 */
public data class DomainAssociationSubDomain(
    public val branchName: String,
    public val dnsRecord: String? = null,
    public val prefix: String,
    public val verified: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.amplify.outputs.DomainAssociationSubDomain):
            DomainAssociationSubDomain = DomainAssociationSubDomain(
            branchName = javaType.branchName(),
            dnsRecord = javaType.dnsRecord().map({ args0 -> args0 }).orElse(null),
            prefix = javaType.prefix(),
            verified = javaType.verified().map({ args0 -> args0 }).orElse(null),
        )
    }
}
