@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.aws.apigateway.AccountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a settings of an API Gateway Account. Settings is applied region-wide per `provider` block.
 * > **Note:** As there is no API method for deleting account settings or resetting it to defaults, destroying this resource will keep your account settings intact
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.apigateway.Account;
 * import com.pulumi.aws.apigateway.AccountArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("apigateway.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var cloudwatchRole = new Role("cloudwatchRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var demo = new Account("demo", AccountArgs.builder()
 *             .cloudwatchRoleArn(cloudwatchRole.arn())
 *             .build());
 *         final var cloudwatchPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions(
 *                     "logs:CreateLogGroup",
 *                     "logs:CreateLogStream",
 *                     "logs:DescribeLogGroups",
 *                     "logs:DescribeLogStreams",
 *                     "logs:PutLogEvents",
 *                     "logs:GetLogEvents",
 *                     "logs:FilterLogEvents")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var cloudwatchRolePolicy = new RolePolicy("cloudwatchRolePolicy", RolePolicyArgs.builder()
 *             .role(cloudwatchRole.id())
 *             .policy(cloudwatchPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import API Gateway Accounts using the word `api-gateway-account`. For example:
 * ```sh
 *  $ pulumi import aws:apigateway/account:Account demo api-gateway-account
 * ```
 * @property cloudwatchRoleArn ARN of an IAM role for CloudWatch (to allow logging & monitoring). See more [in AWS Docs](https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-stage-settings.html#how-to-stage-settings-console). Logging & monitoring can be enabled/disabled and otherwise tuned on the API Gateway Stage level.
 */
public data class AccountArgs(
    public val cloudwatchRoleArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.AccountArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.AccountArgs =
        com.pulumi.aws.apigateway.AccountArgs.builder()
            .cloudwatchRoleArn(cloudwatchRoleArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccountArgs].
 */
@PulumiTagMarker
public class AccountArgsBuilder internal constructor() {
    private var cloudwatchRoleArn: Output<String>? = null

    /**
     * @param value ARN of an IAM role for CloudWatch (to allow logging & monitoring). See more [in AWS Docs](https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-stage-settings.html#how-to-stage-settings-console). Logging & monitoring can be enabled/disabled and otherwise tuned on the API Gateway Stage level.
     */
    @JvmName("flnlykxnadwrvjak")
    public suspend fun cloudwatchRoleArn(`value`: Output<String>) {
        this.cloudwatchRoleArn = value
    }

    /**
     * @param value ARN of an IAM role for CloudWatch (to allow logging & monitoring). See more [in AWS Docs](https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-stage-settings.html#how-to-stage-settings-console). Logging & monitoring can be enabled/disabled and otherwise tuned on the API Gateway Stage level.
     */
    @JvmName("gdgtxbplhxqmmwba")
    public suspend fun cloudwatchRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchRoleArn = mapped
    }

    internal fun build(): AccountArgs = AccountArgs(
        cloudwatchRoleArn = cloudwatchRoleArn,
    )
}
