@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ApiKey].
 */
@PulumiTagMarker
public class ApiKeyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApiKeyArgs = ApiKeyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApiKeyArgsBuilder.() -> Unit) {
        val builder = ApiKeyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ApiKey {
        val builtJavaResource = com.pulumi.aws.apigateway.ApiKey(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ApiKey(builtJavaResource)
    }
}

/**
 * Provides an API Gateway API Key.
 * > **NOTE:** Since the API Gateway usage plans feature was launched on August 11, 2016, usage plans are now **required** to associate an API key with an API stage.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.ApiKey;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ApiKey("example");
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import API Gateway Keys using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:apigateway/apiKey:ApiKey example 8bklk8bl1k3sB38D9B3l0enyWT8c09B30lkq0blk
 * ```
 *
 */
public class ApiKey internal constructor(
    override val javaResource: com.pulumi.aws.apigateway.ApiKey,
) : KotlinCustomResource(javaResource, ApiKeyMapper) {
    /**
     * ARN
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Creation date of the API key
     */
    public val createdDate: Output<String>
        get() = javaResource.createdDate().applyValue({ args0 -> args0 })

    /**
     * An Amazon Web Services Marketplace customer identifier, when integrating with the Amazon Web Services SaaS Marketplace.
     */
    public val customerId: Output<String>?
        get() = javaResource.customerId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * API key description. Defaults to "Managed by Pulumi".
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * Whether the API key can be used by callers. Defaults to `true`.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Last update date of the API key
     */
    public val lastUpdatedDate: Output<String>
        get() = javaResource.lastUpdatedDate().applyValue({ args0 -> args0 })

    /**
     * Name of the API key.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Value of the API key. If specified, the value must be an alphanumeric string between 20 and 128 characters. If not specified, it will be automatically generated by AWS on creation.
     */
    public val `value`: Output<String>
        get() = javaResource.`value`().applyValue({ args0 -> args0 })
}

public object ApiKeyMapper : ResourceMapper<ApiKey> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apigateway.ApiKey::class == javaResource::class

    override fun map(javaResource: Resource): ApiKey = ApiKey(
        javaResource as
            com.pulumi.aws.apigateway.ApiKey,
    )
}

/**
 * @see [ApiKey].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApiKey].
 */
public suspend fun apiKey(name: String, block: suspend ApiKeyResourceBuilder.() -> Unit): ApiKey {
    val builder = ApiKeyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApiKey].
 * @param name The _unique_ name of the resulting resource.
 */
public fun apiKey(name: String): ApiKey {
    val builder = ApiKeyResourceBuilder()
    builder.name(name)
    return builder.build()
}
