@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Authorizer].
 */
@PulumiTagMarker
public class AuthorizerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AuthorizerArgs = AuthorizerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AuthorizerArgsBuilder.() -> Unit) {
        val builder = AuthorizerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Authorizer {
        val builtJavaResource = com.pulumi.aws.apigateway.Authorizer(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Authorizer(builtJavaResource)
    }
}

/**
 * Provides an API Gateway Authorizer.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.lambda.Function;
 * import com.pulumi.aws.lambda.FunctionArgs;
 * import com.pulumi.aws.apigateway.Authorizer;
 * import com.pulumi.aws.apigateway.AuthorizerArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.asset.FileArchive;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var demoRestApi = new RestApi("demoRestApi");
 *         final var invocationAssumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("apigateway.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var invocationRole = new Role("invocationRole", RoleArgs.builder()
 *             .path("/")
 *             .assumeRolePolicy(invocationAssumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var lambdaAssumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("lambda.amazonaws.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var lambda = new Role("lambda", RoleArgs.builder()
 *             .assumeRolePolicy(lambdaAssumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var authorizer = new Function("authorizer", FunctionArgs.builder()
 *             .code(new FileArchive("lambda-function.zip"))
 *             .role(lambda.arn())
 *             .handler("exports.example")
 *             .build());
 *         var demoAuthorizer = new Authorizer("demoAuthorizer", AuthorizerArgs.builder()
 *             .restApi(demoRestApi.id())
 *             .authorizerUri(authorizer.invokeArn())
 *             .authorizerCredentials(invocationRole.arn())
 *             .build());
 *         final var invocationPolicyPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("lambda:InvokeFunction")
 *                 .resources(authorizer.arn())
 *                 .build())
 *             .build());
 *         var invocationPolicyRolePolicy = new RolePolicy("invocationPolicyRolePolicy", RolePolicyArgs.builder()
 *             .role(invocationRole.id())
 *             .policy(invocationPolicyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(invocationPolicyPolicyDocument -> invocationPolicyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AWS API Gateway Authorizer using the `REST-API-ID/AUTHORIZER-ID`. For example:
 * ```sh
 *  $ pulumi import aws:apigateway/authorizer:Authorizer authorizer 12345abcde/example
 * ```
 *
 */
public class Authorizer internal constructor(
    override val javaResource: com.pulumi.aws.apigateway.Authorizer,
) : KotlinCustomResource(javaResource, AuthorizerMapper) {
    /**
     * ARN of the API Gateway Authorizer
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Credentials required for the authorizer. To specify an IAM Role for API Gateway to assume, use the IAM Role ARN.
     */
    public val authorizerCredentials: Output<String>?
        get() = javaResource.authorizerCredentials().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * TTL of cached authorizer results in seconds. Defaults to `300`.
     */
    public val authorizerResultTtlInSeconds: Output<Int>?
        get() = javaResource.authorizerResultTtlInSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Authorizer's Uniform Resource Identifier (URI). This must be a well-formed Lambda function URI in the form of `arn:aws:apigateway:{region}:lambda:path/{service_api}`,
     * e.g., `arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:012345678912:function:my-function/invocations`
     */
    public val authorizerUri: Output<String>?
        get() = javaResource.authorizerUri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Source of the identity in an incoming request. Defaults to `method.request.header.Authorization`. For `REQUEST` type, this may be a comma-separated list of values, including headers, query string parameters and stage variables - e.g., `"method.request.header.SomeHeaderName,method.request.querystring.SomeQueryStringName,stageVariables.SomeStageVariableName"`
     */
    public val identitySource: Output<String>?
        get() = javaResource.identitySource().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Validation expression for the incoming identity. For `TOKEN` type, this value should be a regular expression. The incoming token from the client is matched against this expression, and will proceed if the token matches. If the token doesn't match, the client receives a 401 Unauthorized response.
     */
    public val identityValidationExpression: Output<String>?
        get() = javaResource.identityValidationExpression().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the authorizer
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of the Amazon Cognito user pool ARNs. Each element is of this format: `arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}`.
     */
    public val providerArns: Output<List<String>>?
        get() = javaResource.providerArns().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * ID of the associated REST API
     */
    public val restApi: Output<String>
        get() = javaResource.restApi().applyValue({ args0 -> args0 })

    /**
     * Type of the authorizer. Possible values are `TOKEN` for a Lambda function using a single authorization token submitted in a custom header, `REQUEST` for a Lambda function using incoming request parameters, or `COGNITO_USER_POOLS` for using an Amazon Cognito user pool. Defaults to `TOKEN`.
     */
    public val type: Output<String>?
        get() = javaResource.type().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object AuthorizerMapper : ResourceMapper<Authorizer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apigateway.Authorizer::class == javaResource::class

    override fun map(javaResource: Resource): Authorizer = Authorizer(
        javaResource as
            com.pulumi.aws.apigateway.Authorizer,
    )
}

/**
 * @see [Authorizer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Authorizer].
 */
public suspend fun authorizer(name: String, block: suspend AuthorizerResourceBuilder.() -> Unit):
    Authorizer {
    val builder = AuthorizerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Authorizer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun authorizer(name: String): Authorizer {
    val builder = AuthorizerResourceBuilder()
    builder.name(name)
    return builder.build()
}
