@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.aws.apigateway.AuthorizerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an API Gateway Authorizer.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.lambda.Function;
 * import com.pulumi.aws.lambda.FunctionArgs;
 * import com.pulumi.aws.apigateway.Authorizer;
 * import com.pulumi.aws.apigateway.AuthorizerArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.asset.FileArchive;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var demoRestApi = new RestApi("demoRestApi");
 *         final var invocationAssumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("apigateway.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var invocationRole = new Role("invocationRole", RoleArgs.builder()
 *             .path("/")
 *             .assumeRolePolicy(invocationAssumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var lambdaAssumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("lambda.amazonaws.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var lambda = new Role("lambda", RoleArgs.builder()
 *             .assumeRolePolicy(lambdaAssumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var authorizer = new Function("authorizer", FunctionArgs.builder()
 *             .code(new FileArchive("lambda-function.zip"))
 *             .role(lambda.arn())
 *             .handler("exports.example")
 *             .build());
 *         var demoAuthorizer = new Authorizer("demoAuthorizer", AuthorizerArgs.builder()
 *             .restApi(demoRestApi.id())
 *             .authorizerUri(authorizer.invokeArn())
 *             .authorizerCredentials(invocationRole.arn())
 *             .build());
 *         final var invocationPolicyPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions("lambda:InvokeFunction")
 *                 .resources(authorizer.arn())
 *                 .build())
 *             .build());
 *         var invocationPolicyRolePolicy = new RolePolicy("invocationPolicyRolePolicy", RolePolicyArgs.builder()
 *             .role(invocationRole.id())
 *             .policy(invocationPolicyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(invocationPolicyPolicyDocument -> invocationPolicyPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AWS API Gateway Authorizer using the `REST-API-ID/AUTHORIZER-ID`. For example:
 * ```sh
 *  $ pulumi import aws:apigateway/authorizer:Authorizer authorizer 12345abcde/example
 * ```
 * @property authorizerCredentials Credentials required for the authorizer. To specify an IAM Role for API Gateway to assume, use the IAM Role ARN.
 * @property authorizerResultTtlInSeconds TTL of cached authorizer results in seconds. Defaults to `300`.
 * @property authorizerUri Authorizer's Uniform Resource Identifier (URI). This must be a well-formed Lambda function URI in the form of `arn:aws:apigateway:{region}:lambda:path/{service_api}`,
 * e.g., `arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:012345678912:function:my-function/invocations`
 * @property identitySource Source of the identity in an incoming request. Defaults to `method.request.header.Authorization`. For `REQUEST` type, this may be a comma-separated list of values, including headers, query string parameters and stage variables - e.g., `"method.request.header.SomeHeaderName,method.request.querystring.SomeQueryStringName,stageVariables.SomeStageVariableName"`
 * @property identityValidationExpression Validation expression for the incoming identity. For `TOKEN` type, this value should be a regular expression. The incoming token from the client is matched against this expression, and will proceed if the token matches. If the token doesn't match, the client receives a 401 Unauthorized response.
 * @property name Name of the authorizer
 * @property providerArns List of the Amazon Cognito user pool ARNs. Each element is of this format: `arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}`.
 * @property restApi ID of the associated REST API
 * @property type Type of the authorizer. Possible values are `TOKEN` for a Lambda function using a single authorization token submitted in a custom header, `REQUEST` for a Lambda function using incoming request parameters, or `COGNITO_USER_POOLS` for using an Amazon Cognito user pool. Defaults to `TOKEN`.
 */
public data class AuthorizerArgs(
    public val authorizerCredentials: Output<String>? = null,
    public val authorizerResultTtlInSeconds: Output<Int>? = null,
    public val authorizerUri: Output<String>? = null,
    public val identitySource: Output<String>? = null,
    public val identityValidationExpression: Output<String>? = null,
    public val name: Output<String>? = null,
    public val providerArns: Output<List<String>>? = null,
    public val restApi: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.AuthorizerArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.AuthorizerArgs =
        com.pulumi.aws.apigateway.AuthorizerArgs.builder()
            .authorizerCredentials(authorizerCredentials?.applyValue({ args0 -> args0 }))
            .authorizerResultTtlInSeconds(authorizerResultTtlInSeconds?.applyValue({ args0 -> args0 }))
            .authorizerUri(authorizerUri?.applyValue({ args0 -> args0 }))
            .identitySource(identitySource?.applyValue({ args0 -> args0 }))
            .identityValidationExpression(identityValidationExpression?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .providerArns(providerArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .restApi(restApi?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AuthorizerArgs].
 */
@PulumiTagMarker
public class AuthorizerArgsBuilder internal constructor() {
    private var authorizerCredentials: Output<String>? = null

    private var authorizerResultTtlInSeconds: Output<Int>? = null

    private var authorizerUri: Output<String>? = null

    private var identitySource: Output<String>? = null

    private var identityValidationExpression: Output<String>? = null

    private var name: Output<String>? = null

    private var providerArns: Output<List<String>>? = null

    private var restApi: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Credentials required for the authorizer. To specify an IAM Role for API Gateway to assume, use the IAM Role ARN.
     */
    @JvmName("abencflrheapmjok")
    public suspend fun authorizerCredentials(`value`: Output<String>) {
        this.authorizerCredentials = value
    }

    /**
     * @param value TTL of cached authorizer results in seconds. Defaults to `300`.
     */
    @JvmName("tscpihyavwukerhn")
    public suspend fun authorizerResultTtlInSeconds(`value`: Output<Int>) {
        this.authorizerResultTtlInSeconds = value
    }

    /**
     * @param value Authorizer's Uniform Resource Identifier (URI). This must be a well-formed Lambda function URI in the form of `arn:aws:apigateway:{region}:lambda:path/{service_api}`,
     * e.g., `arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:012345678912:function:my-function/invocations`
     */
    @JvmName("ouorhcjgswcfeyto")
    public suspend fun authorizerUri(`value`: Output<String>) {
        this.authorizerUri = value
    }

    /**
     * @param value Source of the identity in an incoming request. Defaults to `method.request.header.Authorization`. For `REQUEST` type, this may be a comma-separated list of values, including headers, query string parameters and stage variables - e.g., `"method.request.header.SomeHeaderName,method.request.querystring.SomeQueryStringName,stageVariables.SomeStageVariableName"`
     */
    @JvmName("qmdggatitvymxbuy")
    public suspend fun identitySource(`value`: Output<String>) {
        this.identitySource = value
    }

    /**
     * @param value Validation expression for the incoming identity. For `TOKEN` type, this value should be a regular expression. The incoming token from the client is matched against this expression, and will proceed if the token matches. If the token doesn't match, the client receives a 401 Unauthorized response.
     */
    @JvmName("globantgbdasypfg")
    public suspend fun identityValidationExpression(`value`: Output<String>) {
        this.identityValidationExpression = value
    }

    /**
     * @param value Name of the authorizer
     */
    @JvmName("mudiccidjqdfrkir")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value List of the Amazon Cognito user pool ARNs. Each element is of this format: `arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}`.
     */
    @JvmName("dysdmukrebrmmpav")
    public suspend fun providerArns(`value`: Output<List<String>>) {
        this.providerArns = value
    }

    @JvmName("pqcrdukllowuxjog")
    public suspend fun providerArns(vararg values: Output<String>) {
        this.providerArns = Output.all(values.asList())
    }

    /**
     * @param values List of the Amazon Cognito user pool ARNs. Each element is of this format: `arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}`.
     */
    @JvmName("hkinvqafxwdmybde")
    public suspend fun providerArns(values: List<Output<String>>) {
        this.providerArns = Output.all(values)
    }

    /**
     * @param value ID of the associated REST API
     */
    @JvmName("xmrcjgweodvlkxmg")
    public suspend fun restApi(`value`: Output<String>) {
        this.restApi = value
    }

    /**
     * @param value Type of the authorizer. Possible values are `TOKEN` for a Lambda function using a single authorization token submitted in a custom header, `REQUEST` for a Lambda function using incoming request parameters, or `COGNITO_USER_POOLS` for using an Amazon Cognito user pool. Defaults to `TOKEN`.
     */
    @JvmName("rhguokshoywdobha")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Credentials required for the authorizer. To specify an IAM Role for API Gateway to assume, use the IAM Role ARN.
     */
    @JvmName("cckcespewacsipeh")
    public suspend fun authorizerCredentials(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizerCredentials = mapped
    }

    /**
     * @param value TTL of cached authorizer results in seconds. Defaults to `300`.
     */
    @JvmName("epugvasbqjttmysm")
    public suspend fun authorizerResultTtlInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizerResultTtlInSeconds = mapped
    }

    /**
     * @param value Authorizer's Uniform Resource Identifier (URI). This must be a well-formed Lambda function URI in the form of `arn:aws:apigateway:{region}:lambda:path/{service_api}`,
     * e.g., `arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:012345678912:function:my-function/invocations`
     */
    @JvmName("oxyyqdmuyfutkhnx")
    public suspend fun authorizerUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizerUri = mapped
    }

    /**
     * @param value Source of the identity in an incoming request. Defaults to `method.request.header.Authorization`. For `REQUEST` type, this may be a comma-separated list of values, including headers, query string parameters and stage variables - e.g., `"method.request.header.SomeHeaderName,method.request.querystring.SomeQueryStringName,stageVariables.SomeStageVariableName"`
     */
    @JvmName("ywmmxvlvoayemxpm")
    public suspend fun identitySource(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identitySource = mapped
    }

    /**
     * @param value Validation expression for the incoming identity. For `TOKEN` type, this value should be a regular expression. The incoming token from the client is matched against this expression, and will proceed if the token matches. If the token doesn't match, the client receives a 401 Unauthorized response.
     */
    @JvmName("cbihcgjnchoupdfd")
    public suspend fun identityValidationExpression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityValidationExpression = mapped
    }

    /**
     * @param value Name of the authorizer
     */
    @JvmName("joqywgcltoeyyttr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value List of the Amazon Cognito user pool ARNs. Each element is of this format: `arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}`.
     */
    @JvmName("txlvvqhsxjjgunrb")
    public suspend fun providerArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerArns = mapped
    }

    /**
     * @param values List of the Amazon Cognito user pool ARNs. Each element is of this format: `arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}`.
     */
    @JvmName("nbepxctiimwvkbaj")
    public suspend fun providerArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.providerArns = mapped
    }

    /**
     * @param value ID of the associated REST API
     */
    @JvmName("pinjshcyawjlrrii")
    public suspend fun restApi(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restApi = mapped
    }

    /**
     * @param value Type of the authorizer. Possible values are `TOKEN` for a Lambda function using a single authorization token submitted in a custom header, `REQUEST` for a Lambda function using incoming request parameters, or `COGNITO_USER_POOLS` for using an Amazon Cognito user pool. Defaults to `TOKEN`.
     */
    @JvmName("rmqevputwndboony")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AuthorizerArgs = AuthorizerArgs(
        authorizerCredentials = authorizerCredentials,
        authorizerResultTtlInSeconds = authorizerResultTtlInSeconds,
        authorizerUri = authorizerUri,
        identitySource = identitySource,
        identityValidationExpression = identityValidationExpression,
        name = name,
        providerArns = providerArns,
        restApi = restApi,
        type = type,
    )
}
