@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.aws.apigateway.BasePathMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Connects a custom domain name registered via `aws.apigateway.DomainName`
 * with a deployed API so that its methods can be called via the
 * custom domain name.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.Stage;
 * import com.pulumi.aws.apigateway.StageArgs;
 * import com.pulumi.aws.apigateway.DomainName;
 * import com.pulumi.aws.apigateway.DomainNameArgs;
 * import com.pulumi.aws.apigateway.BasePathMapping;
 * import com.pulumi.aws.apigateway.BasePathMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleStage = new Stage("exampleStage", StageArgs.builder()
 *             .deployment(aws_api_gateway_deployment.example().id())
 *             .restApi(aws_api_gateway_rest_api.example().id())
 *             .stageName("example")
 *             .build());
 *         var exampleDomainName = new DomainName("exampleDomainName", DomainNameArgs.builder()
 *             .domainName("example.com")
 *             .certificateName("example-api")
 *             .certificateBody(Files.readString(Paths.get(String.format("%s/example.com/example.crt", path.module()))))
 *             .certificateChain(Files.readString(Paths.get(String.format("%s/example.com/ca.crt", path.module()))))
 *             .certificatePrivateKey(Files.readString(Paths.get(String.format("%s/example.com/example.key", path.module()))))
 *             .build());
 *         var exampleBasePathMapping = new BasePathMapping("exampleBasePathMapping", BasePathMappingArgs.builder()
 *             .restApi(aws_api_gateway_rest_api.example().id())
 *             .stageName(exampleStage.stageName())
 *             .domainName(exampleDomainName.domainName())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * For a non-root `base_path`:
 * Using `pulumi import`, import `aws_api_gateway_base_path_mapping` using the domain name and base path. For example:
 * For an empty `base_path` or, in other words, a root path (`/`):
 * ```sh
 *  $ pulumi import aws:apigateway/basePathMapping:BasePathMapping example example.com/
 * ```
 *  For a non-root `base_path`:
 * ```sh
 *  $ pulumi import aws:apigateway/basePathMapping:BasePathMapping example example.com/base-path
 * ```
 * @property basePath Path segment that must be prepended to the path when accessing the API via this mapping. If omitted, the API is exposed at the root of the given domain.
 * @property domainName Already-registered domain name to connect the API to.
 * @property restApi ID of the API to connect.
 * @property stageName Name of a specific deployment stage to expose at the given path. If omitted, callers may select any stage by including its name as a path element after the base path.
 */
public data class BasePathMappingArgs(
    public val basePath: Output<String>? = null,
    public val domainName: Output<String>? = null,
    public val restApi: Output<String>? = null,
    public val stageName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.BasePathMappingArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.BasePathMappingArgs =
        com.pulumi.aws.apigateway.BasePathMappingArgs.builder()
            .basePath(basePath?.applyValue({ args0 -> args0 }))
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .restApi(restApi?.applyValue({ args0 -> args0 }))
            .stageName(stageName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BasePathMappingArgs].
 */
@PulumiTagMarker
public class BasePathMappingArgsBuilder internal constructor() {
    private var basePath: Output<String>? = null

    private var domainName: Output<String>? = null

    private var restApi: Output<String>? = null

    private var stageName: Output<String>? = null

    /**
     * @param value Path segment that must be prepended to the path when accessing the API via this mapping. If omitted, the API is exposed at the root of the given domain.
     */
    @JvmName("whcpykmukigcofbr")
    public suspend fun basePath(`value`: Output<String>) {
        this.basePath = value
    }

    /**
     * @param value Already-registered domain name to connect the API to.
     */
    @JvmName("aabqyswrypbkqjtf")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value ID of the API to connect.
     */
    @JvmName("jcvpkcfvbtllajtk")
    public suspend fun restApi(`value`: Output<String>) {
        this.restApi = value
    }

    /**
     * @param value Name of a specific deployment stage to expose at the given path. If omitted, callers may select any stage by including its name as a path element after the base path.
     */
    @JvmName("ucdtrdbyfvfdpeab")
    public suspend fun stageName(`value`: Output<String>) {
        this.stageName = value
    }

    /**
     * @param value Path segment that must be prepended to the path when accessing the API via this mapping. If omitted, the API is exposed at the root of the given domain.
     */
    @JvmName("fdhqivvvsnlnowjt")
    public suspend fun basePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.basePath = mapped
    }

    /**
     * @param value Already-registered domain name to connect the API to.
     */
    @JvmName("rlxvehsaukepvige")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value ID of the API to connect.
     */
    @JvmName("qsywonxewxhmxekv")
    public suspend fun restApi(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restApi = mapped
    }

    /**
     * @param value Name of a specific deployment stage to expose at the given path. If omitted, callers may select any stage by including its name as a path element after the base path.
     */
    @JvmName("xvmyddspgedeqcqq")
    public suspend fun stageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stageName = mapped
    }

    internal fun build(): BasePathMappingArgs = BasePathMappingArgs(
        basePath = basePath,
        domainName = domainName,
        restApi = restApi,
        stageName = stageName,
    )
}
