@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.aws.apigateway.DocumentationPartArgs.builder
import com.pulumi.aws.apigateway.kotlin.inputs.DocumentationPartLocationArgs
import com.pulumi.aws.apigateway.kotlin.inputs.DocumentationPartLocationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a settings of an API Gateway Documentation Part.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.DocumentationPart;
 * import com.pulumi.aws.apigateway.DocumentationPartArgs;
 * import com.pulumi.aws.apigateway.inputs.DocumentationPartLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleRestApi = new RestApi("exampleRestApi");
 *         var exampleDocumentationPart = new DocumentationPart("exampleDocumentationPart", DocumentationPartArgs.builder()
 *             .location(DocumentationPartLocationArgs.builder()
 *                 .type("METHOD")
 *                 .method("GET")
 *                 .path("/example")
 *                 .build())
 *             .properties("{\"description\":\"Example description\"}")
 *             .restApiId(exampleRestApi.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import API Gateway documentation_parts using `REST-API-ID/DOC-PART-ID`. For example:
 * ```sh
 *  $ pulumi import aws:apigateway/documentationPart:DocumentationPart example 5i4e1ko720/3oyy3t
 * ```
 * @property location Location of the targeted API entity of the to-be-created documentation part. See below.
 * @property properties Content map of API-specific key-value pairs describing the targeted API entity. The map must be encoded as a JSON string, e.g., "{ \"description\": \"The API does ...\" }". Only Swagger-compliant key-value pairs can be exported and, hence, published.
 * @property restApiId ID of the associated Rest API
 */
public data class DocumentationPartArgs(
    public val location: Output<DocumentationPartLocationArgs>? = null,
    public val properties: Output<String>? = null,
    public val restApiId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.DocumentationPartArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.DocumentationPartArgs =
        com.pulumi.aws.apigateway.DocumentationPartArgs.builder()
            .location(location?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .properties(properties?.applyValue({ args0 -> args0 }))
            .restApiId(restApiId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DocumentationPartArgs].
 */
@PulumiTagMarker
public class DocumentationPartArgsBuilder internal constructor() {
    private var location: Output<DocumentationPartLocationArgs>? = null

    private var properties: Output<String>? = null

    private var restApiId: Output<String>? = null

    /**
     * @param value Location of the targeted API entity of the to-be-created documentation part. See below.
     */
    @JvmName("cttmnoixufrpilxs")
    public suspend fun location(`value`: Output<DocumentationPartLocationArgs>) {
        this.location = value
    }

    /**
     * @param value Content map of API-specific key-value pairs describing the targeted API entity. The map must be encoded as a JSON string, e.g., "{ \"description\": \"The API does ...\" }". Only Swagger-compliant key-value pairs can be exported and, hence, published.
     */
    @JvmName("rdvwnrxethjkobnd")
    public suspend fun properties(`value`: Output<String>) {
        this.properties = value
    }

    /**
     * @param value ID of the associated Rest API
     */
    @JvmName("qlcrlaboanqgqivx")
    public suspend fun restApiId(`value`: Output<String>) {
        this.restApiId = value
    }

    /**
     * @param value Location of the targeted API entity of the to-be-created documentation part. See below.
     */
    @JvmName("ctkiqtpoxrcomsjh")
    public suspend fun location(`value`: DocumentationPartLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param argument Location of the targeted API entity of the to-be-created documentation part. See below.
     */
    @JvmName("xwfhvxtsifvmlplj")
    public suspend fun location(argument: suspend DocumentationPartLocationArgsBuilder.() -> Unit) {
        val toBeMapped = DocumentationPartLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.location = mapped
    }

    /**
     * @param value Content map of API-specific key-value pairs describing the targeted API entity. The map must be encoded as a JSON string, e.g., "{ \"description\": \"The API does ...\" }". Only Swagger-compliant key-value pairs can be exported and, hence, published.
     */
    @JvmName("lrcpvbapketxapkd")
    public suspend fun properties(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value ID of the associated Rest API
     */
    @JvmName("jqwbkftsdnqjwrfd")
    public suspend fun restApiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restApiId = mapped
    }

    internal fun build(): DocumentationPartArgs = DocumentationPartArgs(
        location = location,
        properties = properties,
        restApiId = restApiId,
    )
}
