@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.aws.apigateway.DocumentationVersionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an API Gateway Documentation Version.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.DocumentationPart;
 * import com.pulumi.aws.apigateway.DocumentationPartArgs;
 * import com.pulumi.aws.apigateway.inputs.DocumentationPartLocationArgs;
 * import com.pulumi.aws.apigateway.DocumentationVersion;
 * import com.pulumi.aws.apigateway.DocumentationVersionArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleRestApi = new RestApi("exampleRestApi");
 *         var exampleDocumentationPart = new DocumentationPart("exampleDocumentationPart", DocumentationPartArgs.builder()
 *             .location(DocumentationPartLocationArgs.builder()
 *                 .type("API")
 *                 .build())
 *             .properties("{\"description\":\"Example\"}")
 *             .restApiId(exampleRestApi.id())
 *             .build());
 *         var exampleDocumentationVersion = new DocumentationVersion("exampleDocumentationVersion", DocumentationVersionArgs.builder()
 *             .version("example_version")
 *             .restApiId(exampleRestApi.id())
 *             .description("Example description")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleDocumentationPart)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import API Gateway documentation versions using `REST-API-ID/VERSION`. For example:
 * ```sh
 *  $ pulumi import aws:apigateway/documentationVersion:DocumentationVersion example 5i4e1ko720/example-version
 * ```
 * @property description Description of the API documentation version.
 * @property restApiId ID of the associated Rest API
 * @property version Version identifier of the API documentation snapshot.
 */
public data class DocumentationVersionArgs(
    public val description: Output<String>? = null,
    public val restApiId: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.DocumentationVersionArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.DocumentationVersionArgs =
        com.pulumi.aws.apigateway.DocumentationVersionArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .restApiId(restApiId?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DocumentationVersionArgs].
 */
@PulumiTagMarker
public class DocumentationVersionArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var restApiId: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Description of the API documentation version.
     */
    @JvmName("reppnshylnlfcupp")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value ID of the associated Rest API
     */
    @JvmName("yrwqnojwqjwnvqge")
    public suspend fun restApiId(`value`: Output<String>) {
        this.restApiId = value
    }

    /**
     * @param value Version identifier of the API documentation snapshot.
     */
    @JvmName("dpkaakrcjgkenwxh")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Description of the API documentation version.
     */
    @JvmName("houotxdesdwlcguk")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value ID of the associated Rest API
     */
    @JvmName("rcextetslccxuxct")
    public suspend fun restApiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restApiId = mapped
    }

    /**
     * @param value Version identifier of the API documentation snapshot.
     */
    @JvmName("aqqrahnpxhqpfaau")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): DocumentationVersionArgs = DocumentationVersionArgs(
        description = description,
        restApiId = restApiId,
        version = version,
    )
}
