@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.aws.apigateway.DomainNameArgs.builder
import com.pulumi.aws.apigateway.kotlin.inputs.DomainNameEndpointConfigurationArgs
import com.pulumi.aws.apigateway.kotlin.inputs.DomainNameEndpointConfigurationArgsBuilder
import com.pulumi.aws.apigateway.kotlin.inputs.DomainNameMutualTlsAuthenticationArgs
import com.pulumi.aws.apigateway.kotlin.inputs.DomainNameMutualTlsAuthenticationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Registers a custom domain name for use with AWS API Gateway. Additional information about this functionality
 * can be found in the [API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-custom-domains.html).
 * This resource just establishes ownership of and the TLS settings for
 * a particular domain name. An API can be attached to a particular path
 * under the registered domain name using
 * the `aws.apigateway.BasePathMapping` resource.
 * API Gateway domains can be defined as either 'edge-optimized' or 'regional'.  In an edge-optimized configuration,
 * API Gateway internally creates and manages a CloudFront distribution to route requests on the given hostname. In
 * addition to this resource it's necessary to create a DNS record corresponding to the given domain name which is an alias
 * (either Route53 alias or traditional CNAME) to the Cloudfront domain name exported in the `cloudfront_domain_name`
 * attribute.
 * In a regional configuration, API Gateway does not create a CloudFront distribution to route requests to the API, though
 * a distribution can be created if needed. In either case, it is necessary to create a DNS record corresponding to the
 * given domain name which is an alias (either Route53 alias or traditional CNAME) to the regional domain name exported in
 * the `regional_domain_name` attribute.
 * > **Note:** API Gateway requires the use of AWS Certificate Manager (ACM) certificates instead of Identity and Access Management (IAM) certificates in regions that support ACM. Regions that support ACM can be found in the [Regions and Endpoints Documentation](https://docs.aws.amazon.com/general/latest/gr/rande.html#acm_region). To import an existing private key and certificate into ACM or request an ACM certificate, see the `aws.acm.Certificate` resource.
 * > **Note:** The `aws.apigateway.DomainName` resource expects dependency on the `aws.acm.CertificateValidation` as
 * only verified certificates can be used. This can be made either explicitly by adding the
 * `depends_on = [aws_acm_certificate_validation&#46;cert]` attribute. Or implicitly by referring certificate ARN
 * from the validation resource where it will be available after the resource creation:
 * `regional_certificate_arn = aws_acm_certificate_validation.cert.certificate_arn`.
 * ## Example Usage
 * ### Edge Optimized (ACM Certificate)
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.DomainName;
 * import com.pulumi.aws.apigateway.DomainNameArgs;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import com.pulumi.aws.route53.inputs.RecordAliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleDomainName = new DomainName("exampleDomainName", DomainNameArgs.builder()
 *             .certificateArn(aws_acm_certificate_validation.example().certificate_arn())
 *             .domainName("api.example.com")
 *             .build());
 *         var exampleRecord = new Record("exampleRecord", RecordArgs.builder()
 *             .name(exampleDomainName.domainName())
 *             .type("A")
 *             .zoneId(aws_route53_zone.example().id())
 *             .aliases(RecordAliasArgs.builder()
 *                 .evaluateTargetHealth(true)
 *                 .name(exampleDomainName.cloudfrontDomainName())
 *                 .zoneId(exampleDomainName.cloudfrontZoneId())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Edge Optimized (IAM Certificate)
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.DomainName;
 * import com.pulumi.aws.apigateway.DomainNameArgs;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import com.pulumi.aws.route53.inputs.RecordAliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleDomainName = new DomainName("exampleDomainName", DomainNameArgs.builder()
 *             .domainName("api.example.com")
 *             .certificateName("example-api")
 *             .certificateBody(Files.readString(Paths.get(String.format("%s/example.com/example.crt", path.module()))))
 *             .certificateChain(Files.readString(Paths.get(String.format("%s/example.com/ca.crt", path.module()))))
 *             .certificatePrivateKey(Files.readString(Paths.get(String.format("%s/example.com/example.key", path.module()))))
 *             .build());
 *         var exampleRecord = new Record("exampleRecord", RecordArgs.builder()
 *             .zoneId(aws_route53_zone.example().id())
 *             .name(exampleDomainName.domainName())
 *             .type("A")
 *             .aliases(RecordAliasArgs.builder()
 *                 .name(exampleDomainName.cloudfrontDomainName())
 *                 .zoneId(exampleDomainName.cloudfrontZoneId())
 *                 .evaluateTargetHealth(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Regional (ACM Certificate)
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.DomainName;
 * import com.pulumi.aws.apigateway.DomainNameArgs;
 * import com.pulumi.aws.apigateway.inputs.DomainNameEndpointConfigurationArgs;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import com.pulumi.aws.route53.inputs.RecordAliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleDomainName = new DomainName("exampleDomainName", DomainNameArgs.builder()
 *             .domainName("api.example.com")
 *             .regionalCertificateArn(aws_acm_certificate_validation.example().certificate_arn())
 *             .endpointConfiguration(DomainNameEndpointConfigurationArgs.builder()
 *                 .types("REGIONAL")
 *                 .build())
 *             .build());
 *         var exampleRecord = new Record("exampleRecord", RecordArgs.builder()
 *             .name(exampleDomainName.domainName())
 *             .type("A")
 *             .zoneId(aws_route53_zone.example().id())
 *             .aliases(RecordAliasArgs.builder()
 *                 .evaluateTargetHealth(true)
 *                 .name(exampleDomainName.regionalDomainName())
 *                 .zoneId(exampleDomainName.regionalZoneId())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Regional (IAM Certificate)
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.DomainName;
 * import com.pulumi.aws.apigateway.DomainNameArgs;
 * import com.pulumi.aws.apigateway.inputs.DomainNameEndpointConfigurationArgs;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import com.pulumi.aws.route53.inputs.RecordAliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleDomainName = new DomainName("exampleDomainName", DomainNameArgs.builder()
 *             .certificateBody(Files.readString(Paths.get(String.format("%s/example.com/example.crt", path.module()))))
 *             .certificateChain(Files.readString(Paths.get(String.format("%s/example.com/ca.crt", path.module()))))
 *             .certificatePrivateKey(Files.readString(Paths.get(String.format("%s/example.com/example.key", path.module()))))
 *             .domainName("api.example.com")
 *             .regionalCertificateName("example-api")
 *             .endpointConfiguration(DomainNameEndpointConfigurationArgs.builder()
 *                 .types("REGIONAL")
 *                 .build())
 *             .build());
 *         var exampleRecord = new Record("exampleRecord", RecordArgs.builder()
 *             .name(exampleDomainName.domainName())
 *             .type("A")
 *             .zoneId(aws_route53_zone.example().id())
 *             .aliases(RecordAliasArgs.builder()
 *                 .evaluateTargetHealth(true)
 *                 .name(exampleDomainName.regionalDomainName())
 *                 .zoneId(exampleDomainName.regionalZoneId())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import API Gateway domain names using their `name`. For example:
 * ```sh
 *  $ pulumi import aws:apigateway/domainName:DomainName example dev.example.com
 * ```
 * @property certificateArn ARN for an AWS-managed certificate. AWS Certificate Manager is the only supported source. Used when an edge-optimized domain name is desired. Conflicts with `certificate_name`, `certificate_body`, `certificate_chain`, `certificate_private_key`, `regional_certificate_arn`, and `regional_certificate_name`.
 * @property certificateBody Certificate issued for the domain name being registered, in PEM format. Only valid for `EDGE` endpoint configuration type. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`.
 * @property certificateChain Certificate for the CA that issued the certificate, along with any intermediate CA certificates required to create an unbroken chain to a certificate trusted by the intended API clients. Only valid for `EDGE` endpoint configuration type. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`.
 * @property certificateName Unique name to use when registering this certificate as an IAM server certificate. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`. Required if `certificate_arn` is not set.
 * @property certificatePrivateKey Private key associated with the domain certificate given in `certificate_body`. Only valid for `EDGE` endpoint configuration type. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`.
 * @property domainName Fully-qualified domain name to register.
 * @property endpointConfiguration Configuration block defining API endpoint information including type. See below.
 * @property mutualTlsAuthentication Mutual TLS authentication configuration for the domain name. See below.
 * @property ownershipVerificationCertificateArn ARN of the AWS-issued certificate used to validate custom domain ownership (when `certificate_arn` is issued via an ACM Private CA or `mutual_tls_authentication` is configured with an ACM-imported certificate.)
 * @property regionalCertificateArn ARN for an AWS-managed certificate. AWS Certificate Manager is the only supported source. Used when a regional domain name is desired. Conflicts with `certificate_arn`, `certificate_name`, `certificate_body`, `certificate_chain`, and `certificate_private_key`.
 * When uploading a certificate, the following arguments are supported:
 * @property regionalCertificateName User-friendly name of the certificate that will be used by regional endpoint for this domain name. Conflicts with `certificate_arn`, `certificate_name`, `certificate_body`, `certificate_chain`, and `certificate_private_key`.
 * @property securityPolicy Transport Layer Security (TLS) version + cipher suite for this DomainName. Valid values are `TLS_1_0` and `TLS_1_2`. Must be configured to perform drift detection.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * When referencing an AWS-managed certificate, the following arguments are supported:
 */
public data class DomainNameArgs(
    public val certificateArn: Output<String>? = null,
    public val certificateBody: Output<String>? = null,
    public val certificateChain: Output<String>? = null,
    public val certificateName: Output<String>? = null,
    public val certificatePrivateKey: Output<String>? = null,
    public val domainName: Output<String>? = null,
    public val endpointConfiguration: Output<DomainNameEndpointConfigurationArgs>? = null,
    public val mutualTlsAuthentication: Output<DomainNameMutualTlsAuthenticationArgs>? = null,
    public val ownershipVerificationCertificateArn: Output<String>? = null,
    public val regionalCertificateArn: Output<String>? = null,
    public val regionalCertificateName: Output<String>? = null,
    public val securityPolicy: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.DomainNameArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.DomainNameArgs =
        com.pulumi.aws.apigateway.DomainNameArgs.builder()
            .certificateArn(certificateArn?.applyValue({ args0 -> args0 }))
            .certificateBody(certificateBody?.applyValue({ args0 -> args0 }))
            .certificateChain(certificateChain?.applyValue({ args0 -> args0 }))
            .certificateName(certificateName?.applyValue({ args0 -> args0 }))
            .certificatePrivateKey(certificatePrivateKey?.applyValue({ args0 -> args0 }))
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .endpointConfiguration(
                endpointConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .mutualTlsAuthentication(
                mutualTlsAuthentication?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .ownershipVerificationCertificateArn(
                ownershipVerificationCertificateArn?.applyValue({ args0 ->
                    args0
                }),
            )
            .regionalCertificateArn(regionalCertificateArn?.applyValue({ args0 -> args0 }))
            .regionalCertificateName(regionalCertificateName?.applyValue({ args0 -> args0 }))
            .securityPolicy(securityPolicy?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DomainNameArgs].
 */
@PulumiTagMarker
public class DomainNameArgsBuilder internal constructor() {
    private var certificateArn: Output<String>? = null

    private var certificateBody: Output<String>? = null

    private var certificateChain: Output<String>? = null

    private var certificateName: Output<String>? = null

    private var certificatePrivateKey: Output<String>? = null

    private var domainName: Output<String>? = null

    private var endpointConfiguration: Output<DomainNameEndpointConfigurationArgs>? = null

    private var mutualTlsAuthentication: Output<DomainNameMutualTlsAuthenticationArgs>? = null

    private var ownershipVerificationCertificateArn: Output<String>? = null

    private var regionalCertificateArn: Output<String>? = null

    private var regionalCertificateName: Output<String>? = null

    private var securityPolicy: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value ARN for an AWS-managed certificate. AWS Certificate Manager is the only supported source. Used when an edge-optimized domain name is desired. Conflicts with `certificate_name`, `certificate_body`, `certificate_chain`, `certificate_private_key`, `regional_certificate_arn`, and `regional_certificate_name`.
     */
    @JvmName("efgmexbbhejpbmkp")
    public suspend fun certificateArn(`value`: Output<String>) {
        this.certificateArn = value
    }

    /**
     * @param value Certificate issued for the domain name being registered, in PEM format. Only valid for `EDGE` endpoint configuration type. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`.
     */
    @JvmName("fgyeenbheiuutvsg")
    public suspend fun certificateBody(`value`: Output<String>) {
        this.certificateBody = value
    }

    /**
     * @param value Certificate for the CA that issued the certificate, along with any intermediate CA certificates required to create an unbroken chain to a certificate trusted by the intended API clients. Only valid for `EDGE` endpoint configuration type. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`.
     */
    @JvmName("fxlvchynidgwywjn")
    public suspend fun certificateChain(`value`: Output<String>) {
        this.certificateChain = value
    }

    /**
     * @param value Unique name to use when registering this certificate as an IAM server certificate. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`. Required if `certificate_arn` is not set.
     */
    @JvmName("ykerhcakjjqpqyal")
    public suspend fun certificateName(`value`: Output<String>) {
        this.certificateName = value
    }

    /**
     * @param value Private key associated with the domain certificate given in `certificate_body`. Only valid for `EDGE` endpoint configuration type. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`.
     */
    @JvmName("vhbeeswkmgfmoyqp")
    public suspend fun certificatePrivateKey(`value`: Output<String>) {
        this.certificatePrivateKey = value
    }

    /**
     * @param value Fully-qualified domain name to register.
     */
    @JvmName("bfkyoxpyqmwhxovr")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value Configuration block defining API endpoint information including type. See below.
     */
    @JvmName("ynwnueqtdackrxlm")
    public suspend fun endpointConfiguration(`value`: Output<DomainNameEndpointConfigurationArgs>) {
        this.endpointConfiguration = value
    }

    /**
     * @param value Mutual TLS authentication configuration for the domain name. See below.
     */
    @JvmName("mhmfrdcvrrjbhbav")
    public suspend
    fun mutualTlsAuthentication(`value`: Output<DomainNameMutualTlsAuthenticationArgs>) {
        this.mutualTlsAuthentication = value
    }

    /**
     * @param value ARN of the AWS-issued certificate used to validate custom domain ownership (when `certificate_arn` is issued via an ACM Private CA or `mutual_tls_authentication` is configured with an ACM-imported certificate.)
     */
    @JvmName("hpwvxepfbcsgiccl")
    public suspend fun ownershipVerificationCertificateArn(`value`: Output<String>) {
        this.ownershipVerificationCertificateArn = value
    }

    /**
     * @param value ARN for an AWS-managed certificate. AWS Certificate Manager is the only supported source. Used when a regional domain name is desired. Conflicts with `certificate_arn`, `certificate_name`, `certificate_body`, `certificate_chain`, and `certificate_private_key`.
     * When uploading a certificate, the following arguments are supported:
     */
    @JvmName("niwrshcbmnixitxl")
    public suspend fun regionalCertificateArn(`value`: Output<String>) {
        this.regionalCertificateArn = value
    }

    /**
     * @param value User-friendly name of the certificate that will be used by regional endpoint for this domain name. Conflicts with `certificate_arn`, `certificate_name`, `certificate_body`, `certificate_chain`, and `certificate_private_key`.
     */
    @JvmName("qjgxfwjefakabtdh")
    public suspend fun regionalCertificateName(`value`: Output<String>) {
        this.regionalCertificateName = value
    }

    /**
     * @param value Transport Layer Security (TLS) version + cipher suite for this DomainName. Valid values are `TLS_1_0` and `TLS_1_2`. Must be configured to perform drift detection.
     */
    @JvmName("uhwjwcdpbaxiqing")
    public suspend fun securityPolicy(`value`: Output<String>) {
        this.securityPolicy = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * When referencing an AWS-managed certificate, the following arguments are supported:
     */
    @JvmName("hqnvcrjtfspoxkbw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value ARN for an AWS-managed certificate. AWS Certificate Manager is the only supported source. Used when an edge-optimized domain name is desired. Conflicts with `certificate_name`, `certificate_body`, `certificate_chain`, `certificate_private_key`, `regional_certificate_arn`, and `regional_certificate_name`.
     */
    @JvmName("bfpjrfunmmchvdoj")
    public suspend fun certificateArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateArn = mapped
    }

    /**
     * @param value Certificate issued for the domain name being registered, in PEM format. Only valid for `EDGE` endpoint configuration type. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`.
     */
    @JvmName("bcdjpeesecpiduxa")
    public suspend fun certificateBody(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateBody = mapped
    }

    /**
     * @param value Certificate for the CA that issued the certificate, along with any intermediate CA certificates required to create an unbroken chain to a certificate trusted by the intended API clients. Only valid for `EDGE` endpoint configuration type. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`.
     */
    @JvmName("baskqxoodmldotwc")
    public suspend fun certificateChain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateChain = mapped
    }

    /**
     * @param value Unique name to use when registering this certificate as an IAM server certificate. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`. Required if `certificate_arn` is not set.
     */
    @JvmName("bkimwrqgmlwmbxet")
    public suspend fun certificateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateName = mapped
    }

    /**
     * @param value Private key associated with the domain certificate given in `certificate_body`. Only valid for `EDGE` endpoint configuration type. Conflicts with `certificate_arn`, `regional_certificate_arn`, and `regional_certificate_name`.
     */
    @JvmName("wafvfvceqeicueqb")
    public suspend fun certificatePrivateKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificatePrivateKey = mapped
    }

    /**
     * @param value Fully-qualified domain name to register.
     */
    @JvmName("auhforaldfoyqjsk")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value Configuration block defining API endpoint information including type. See below.
     */
    @JvmName("xrhbjrwsalywoigf")
    public suspend fun endpointConfiguration(`value`: DomainNameEndpointConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointConfiguration = mapped
    }

    /**
     * @param argument Configuration block defining API endpoint information including type. See below.
     */
    @JvmName("mksjjciajuppcbml")
    public suspend
    fun endpointConfiguration(argument: suspend DomainNameEndpointConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DomainNameEndpointConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.endpointConfiguration = mapped
    }

    /**
     * @param value Mutual TLS authentication configuration for the domain name. See below.
     */
    @JvmName("oixspetfaqqvhcwa")
    public suspend fun mutualTlsAuthentication(`value`: DomainNameMutualTlsAuthenticationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mutualTlsAuthentication = mapped
    }

    /**
     * @param argument Mutual TLS authentication configuration for the domain name. See below.
     */
    @JvmName("fjehroanfpojpbwt")
    public suspend
    fun mutualTlsAuthentication(argument: suspend DomainNameMutualTlsAuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped = DomainNameMutualTlsAuthenticationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.mutualTlsAuthentication = mapped
    }

    /**
     * @param value ARN of the AWS-issued certificate used to validate custom domain ownership (when `certificate_arn` is issued via an ACM Private CA or `mutual_tls_authentication` is configured with an ACM-imported certificate.)
     */
    @JvmName("clwyrksekaftxihm")
    public suspend fun ownershipVerificationCertificateArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ownershipVerificationCertificateArn = mapped
    }

    /**
     * @param value ARN for an AWS-managed certificate. AWS Certificate Manager is the only supported source. Used when a regional domain name is desired. Conflicts with `certificate_arn`, `certificate_name`, `certificate_body`, `certificate_chain`, and `certificate_private_key`.
     * When uploading a certificate, the following arguments are supported:
     */
    @JvmName("uvahylpeufixyykr")
    public suspend fun regionalCertificateArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regionalCertificateArn = mapped
    }

    /**
     * @param value User-friendly name of the certificate that will be used by regional endpoint for this domain name. Conflicts with `certificate_arn`, `certificate_name`, `certificate_body`, `certificate_chain`, and `certificate_private_key`.
     */
    @JvmName("vjmdsoaaecpidppj")
    public suspend fun regionalCertificateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regionalCertificateName = mapped
    }

    /**
     * @param value Transport Layer Security (TLS) version + cipher suite for this DomainName. Valid values are `TLS_1_0` and `TLS_1_2`. Must be configured to perform drift detection.
     */
    @JvmName("yubdqfbgobjyrfkw")
    public suspend fun securityPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityPolicy = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * When referencing an AWS-managed certificate, the following arguments are supported:
     */
    @JvmName("rpvophwsmyhbdpud")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * When referencing an AWS-managed certificate, the following arguments are supported:
     */
    @JvmName("ujxhoogriefinrnj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DomainNameArgs = DomainNameArgs(
        certificateArn = certificateArn,
        certificateBody = certificateBody,
        certificateChain = certificateChain,
        certificateName = certificateName,
        certificatePrivateKey = certificatePrivateKey,
        domainName = domainName,
        endpointConfiguration = endpointConfiguration,
        mutualTlsAuthentication = mutualTlsAuthentication,
        ownershipVerificationCertificateArn = ownershipVerificationCertificateArn,
        regionalCertificateArn = regionalCertificateArn,
        regionalCertificateName = regionalCertificateName,
        securityPolicy = securityPolicy,
        tags = tags,
    )
}
