@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.aws.apigateway.IntegrationResponseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an HTTP Method Integration Response for an API Gateway Resource.
 * > **Note:** Depends on having `aws.apigateway.Integration` inside your rest api. To ensure this
 * you might need to add an explicit `depends_on` for clean runs.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.RestApiArgs;
 * import com.pulumi.aws.apigateway.Resource;
 * import com.pulumi.aws.apigateway.ResourceArgs;
 * import com.pulumi.aws.apigateway.Method;
 * import com.pulumi.aws.apigateway.MethodArgs;
 * import com.pulumi.aws.apigateway.Integration;
 * import com.pulumi.aws.apigateway.IntegrationArgs;
 * import com.pulumi.aws.apigateway.MethodResponse;
 * import com.pulumi.aws.apigateway.MethodResponseArgs;
 * import com.pulumi.aws.apigateway.IntegrationResponse;
 * import com.pulumi.aws.apigateway.IntegrationResponseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myDemoAPI = new RestApi("myDemoAPI", RestApiArgs.builder()
 *             .description("This is my API for demonstration purposes")
 *             .build());
 *         var myDemoResource = new Resource("myDemoResource", ResourceArgs.builder()
 *             .restApi(myDemoAPI.id())
 *             .parentId(myDemoAPI.rootResourceId())
 *             .pathPart("mydemoresource")
 *             .build());
 *         var myDemoMethod = new Method("myDemoMethod", MethodArgs.builder()
 *             .restApi(myDemoAPI.id())
 *             .resourceId(myDemoResource.id())
 *             .httpMethod("GET")
 *             .authorization("NONE")
 *             .build());
 *         var myDemoIntegration = new Integration("myDemoIntegration", IntegrationArgs.builder()
 *             .restApi(myDemoAPI.id())
 *             .resourceId(myDemoResource.id())
 *             .httpMethod(myDemoMethod.httpMethod())
 *             .type("MOCK")
 *             .build());
 *         var response200 = new MethodResponse("response200", MethodResponseArgs.builder()
 *             .restApi(myDemoAPI.id())
 *             .resourceId(myDemoResource.id())
 *             .httpMethod(myDemoMethod.httpMethod())
 *             .statusCode("200")
 *             .build());
 *         var myDemoIntegrationResponse = new IntegrationResponse("myDemoIntegrationResponse", IntegrationResponseArgs.builder()
 *             .restApi(myDemoAPI.id())
 *             .resourceId(myDemoResource.id())
 *             .httpMethod(myDemoMethod.httpMethod())
 *             .statusCode(response200.statusCode())
 *             .responseTemplates(Map.of("application/xml", """
 * #set($inputRoot = $input.path('$'))
 * <?xml version="1.0" encoding="UTF-8"?>
 * <message>
 *     $inputRoot.body
 * </message>
 *             """))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_api_gateway_integration_response` using `REST-API-ID/RESOURCE-ID/HTTP-METHOD/STATUS-CODE`. For example:
 * ```sh
 *  $ pulumi import aws:apigateway/integrationResponse:IntegrationResponse example 12345abcde/67890fghij/GET/200
 * ```
 * @property contentHandling How to handle request payload content type conversions. Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT`. If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.
 * @property httpMethod HTTP method (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTIONS`, `ANY`).
 * @property resourceId API resource ID.
 * @property responseParameters Map of response parameters that can be read from the backend response. For example: `response_parameters = { "method.response.header.X-Some-Header" = "integration.response.header.X-Some-Other-Header" }`.
 * @property responseTemplates Map of templates used to transform the integration response body.
 * @property restApi ID of the associated REST API.
 * @property selectionPattern Regular expression pattern used to choose an integration response based on the response from the backend. Omit configuring this to make the integration the default one. If the backend is an `AWS` Lambda function, the AWS Lambda function error header is matched. For all other `HTTP` and `AWS` backends, the HTTP status code is matched.
 * @property statusCode HTTP status code.
 * The following arguments are optional:
 */
public data class IntegrationResponseArgs(
    public val contentHandling: Output<String>? = null,
    public val httpMethod: Output<String>? = null,
    public val resourceId: Output<String>? = null,
    public val responseParameters: Output<Map<String, String>>? = null,
    public val responseTemplates: Output<Map<String, String>>? = null,
    public val restApi: Output<String>? = null,
    public val selectionPattern: Output<String>? = null,
    public val statusCode: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.IntegrationResponseArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.IntegrationResponseArgs =
        com.pulumi.aws.apigateway.IntegrationResponseArgs.builder()
            .contentHandling(contentHandling?.applyValue({ args0 -> args0 }))
            .httpMethod(httpMethod?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .responseParameters(
                responseParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .responseTemplates(
                responseTemplates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .restApi(restApi?.applyValue({ args0 -> args0 }))
            .selectionPattern(selectionPattern?.applyValue({ args0 -> args0 }))
            .statusCode(statusCode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IntegrationResponseArgs].
 */
@PulumiTagMarker
public class IntegrationResponseArgsBuilder internal constructor() {
    private var contentHandling: Output<String>? = null

    private var httpMethod: Output<String>? = null

    private var resourceId: Output<String>? = null

    private var responseParameters: Output<Map<String, String>>? = null

    private var responseTemplates: Output<Map<String, String>>? = null

    private var restApi: Output<String>? = null

    private var selectionPattern: Output<String>? = null

    private var statusCode: Output<String>? = null

    /**
     * @param value How to handle request payload content type conversions. Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT`. If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.
     */
    @JvmName("hteoiobsaauixrcp")
    public suspend fun contentHandling(`value`: Output<String>) {
        this.contentHandling = value
    }

    /**
     * @param value HTTP method (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTIONS`, `ANY`).
     */
    @JvmName("hydyjgunijiutaop")
    public suspend fun httpMethod(`value`: Output<String>) {
        this.httpMethod = value
    }

    /**
     * @param value API resource ID.
     */
    @JvmName("fvyhflwsrvfvqhbk")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Map of response parameters that can be read from the backend response. For example: `response_parameters = { "method.response.header.X-Some-Header" = "integration.response.header.X-Some-Other-Header" }`.
     */
    @JvmName("kytrgkbrhxkcvxin")
    public suspend fun responseParameters(`value`: Output<Map<String, String>>) {
        this.responseParameters = value
    }

    /**
     * @param value Map of templates used to transform the integration response body.
     */
    @JvmName("rbtuebuelutlslww")
    public suspend fun responseTemplates(`value`: Output<Map<String, String>>) {
        this.responseTemplates = value
    }

    /**
     * @param value ID of the associated REST API.
     */
    @JvmName("cbivedgvkljjwyra")
    public suspend fun restApi(`value`: Output<String>) {
        this.restApi = value
    }

    /**
     * @param value Regular expression pattern used to choose an integration response based on the response from the backend. Omit configuring this to make the integration the default one. If the backend is an `AWS` Lambda function, the AWS Lambda function error header is matched. For all other `HTTP` and `AWS` backends, the HTTP status code is matched.
     */
    @JvmName("mvdlaiaipmvdbrlb")
    public suspend fun selectionPattern(`value`: Output<String>) {
        this.selectionPattern = value
    }

    /**
     * @param value HTTP status code.
     * The following arguments are optional:
     */
    @JvmName("osggtlhitbkimigw")
    public suspend fun statusCode(`value`: Output<String>) {
        this.statusCode = value
    }

    /**
     * @param value How to handle request payload content type conversions. Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT`. If this property is not defined, the response payload will be passed through from the integration response to the method response without modification.
     */
    @JvmName("qhqldomsksrfengo")
    public suspend fun contentHandling(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentHandling = mapped
    }

    /**
     * @param value HTTP method (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTIONS`, `ANY`).
     */
    @JvmName("rmrpuwvolxnwuvox")
    public suspend fun httpMethod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpMethod = mapped
    }

    /**
     * @param value API resource ID.
     */
    @JvmName("oodkefloyrxcppfi")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value Map of response parameters that can be read from the backend response. For example: `response_parameters = { "method.response.header.X-Some-Header" = "integration.response.header.X-Some-Other-Header" }`.
     */
    @JvmName("dymseesbeucsaslx")
    public suspend fun responseParameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseParameters = mapped
    }

    /**
     * @param values Map of response parameters that can be read from the backend response. For example: `response_parameters = { "method.response.header.X-Some-Header" = "integration.response.header.X-Some-Other-Header" }`.
     */
    @JvmName("iajoyqcujicffcss")
    public fun responseParameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.responseParameters = mapped
    }

    /**
     * @param value Map of templates used to transform the integration response body.
     */
    @JvmName("bqfgxitntgkpdnpf")
    public suspend fun responseTemplates(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseTemplates = mapped
    }

    /**
     * @param values Map of templates used to transform the integration response body.
     */
    @JvmName("xekiinmpjpjcmsca")
    public fun responseTemplates(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.responseTemplates = mapped
    }

    /**
     * @param value ID of the associated REST API.
     */
    @JvmName("lxllillutvhmbkoe")
    public suspend fun restApi(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restApi = mapped
    }

    /**
     * @param value Regular expression pattern used to choose an integration response based on the response from the backend. Omit configuring this to make the integration the default one. If the backend is an `AWS` Lambda function, the AWS Lambda function error header is matched. For all other `HTTP` and `AWS` backends, the HTTP status code is matched.
     */
    @JvmName("fmivixhbgkhwlpdb")
    public suspend fun selectionPattern(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selectionPattern = mapped
    }

    /**
     * @param value HTTP status code.
     * The following arguments are optional:
     */
    @JvmName("cayvwkeockvlnnfm")
    public suspend fun statusCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statusCode = mapped
    }

    internal fun build(): IntegrationResponseArgs = IntegrationResponseArgs(
        contentHandling = contentHandling,
        httpMethod = httpMethod,
        resourceId = resourceId,
        responseParameters = responseParameters,
        responseTemplates = responseTemplates,
        restApi = restApi,
        selectionPattern = selectionPattern,
        statusCode = statusCode,
    )
}
