@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [MethodResponse].
 */
@PulumiTagMarker
public class MethodResponseResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MethodResponseArgs = MethodResponseArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MethodResponseArgsBuilder.() -> Unit) {
        val builder = MethodResponseArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MethodResponse {
        val builtJavaResource = com.pulumi.aws.apigateway.MethodResponse(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MethodResponse(builtJavaResource)
    }
}

/**
 * Provides an HTTP Method Response for an API Gateway Resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.RestApiArgs;
 * import com.pulumi.aws.apigateway.Resource;
 * import com.pulumi.aws.apigateway.ResourceArgs;
 * import com.pulumi.aws.apigateway.Method;
 * import com.pulumi.aws.apigateway.MethodArgs;
 * import com.pulumi.aws.apigateway.Integration;
 * import com.pulumi.aws.apigateway.IntegrationArgs;
 * import com.pulumi.aws.apigateway.MethodResponse;
 * import com.pulumi.aws.apigateway.MethodResponseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myDemoAPI = new RestApi("myDemoAPI", RestApiArgs.builder()
 *             .description("This is my API for demonstration purposes")
 *             .build());
 *         var myDemoResource = new Resource("myDemoResource", ResourceArgs.builder()
 *             .restApi(myDemoAPI.id())
 *             .parentId(myDemoAPI.rootResourceId())
 *             .pathPart("mydemoresource")
 *             .build());
 *         var myDemoMethod = new Method("myDemoMethod", MethodArgs.builder()
 *             .restApi(myDemoAPI.id())
 *             .resourceId(myDemoResource.id())
 *             .httpMethod("GET")
 *             .authorization("NONE")
 *             .build());
 *         var myDemoIntegration = new Integration("myDemoIntegration", IntegrationArgs.builder()
 *             .restApi(myDemoAPI.id())
 *             .resourceId(myDemoResource.id())
 *             .httpMethod(myDemoMethod.httpMethod())
 *             .type("MOCK")
 *             .build());
 *         var response200 = new MethodResponse("response200", MethodResponseArgs.builder()
 *             .restApi(myDemoAPI.id())
 *             .resourceId(myDemoResource.id())
 *             .httpMethod(myDemoMethod.httpMethod())
 *             .statusCode("200")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_api_gateway_method_response` using `REST-API-ID/RESOURCE-ID/HTTP-METHOD/STATUS-CODE`. For example:
 * ```sh
 *  $ pulumi import aws:apigateway/methodResponse:MethodResponse example 12345abcde/67890fghij/GET/200
 * ```
 *
 */
public class MethodResponse internal constructor(
    override val javaResource: com.pulumi.aws.apigateway.MethodResponse,
) : KotlinCustomResource(javaResource, MethodResponseMapper) {
    /**
     * HTTP Method (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTIONS`, `ANY`)
     */
    public val httpMethod: Output<String>
        get() = javaResource.httpMethod().applyValue({ args0 -> args0 })

    /**
     * API resource ID
     */
    public val resourceId: Output<String>
        get() = javaResource.resourceId().applyValue({ args0 -> args0 })

    /**
     * Map of the API models used for the response's content type
     */
    public val responseModels: Output<Map<String, String>>?
        get() = javaResource.responseModels().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * Map of response parameters that can be sent to the caller.
     * For example: `response_parameters = { "method.response.header.X-Some-Header" = true }`
     * would define that the header `X-Some-Header` can be provided on the response.
     */
    public val responseParameters: Output<Map<String, Boolean>>?
        get() = javaResource.responseParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * ID of the associated REST API
     */
    public val restApi: Output<String>
        get() = javaResource.restApi().applyValue({ args0 -> args0 })

    /**
     * HTTP status code
     */
    public val statusCode: Output<String>
        get() = javaResource.statusCode().applyValue({ args0 -> args0 })
}

public object MethodResponseMapper : ResourceMapper<MethodResponse> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apigateway.MethodResponse::class == javaResource::class

    override fun map(javaResource: Resource): MethodResponse = MethodResponse(
        javaResource as
            com.pulumi.aws.apigateway.MethodResponse,
    )
}

/**
 * @see [MethodResponse].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MethodResponse].
 */
public suspend fun methodResponse(
    name: String,
    block: suspend MethodResponseResourceBuilder.() -> Unit,
): MethodResponse {
    val builder = MethodResponseResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MethodResponse].
 * @param name The _unique_ name of the resulting resource.
 */
public fun methodResponse(name: String): MethodResponse {
    val builder = MethodResponseResourceBuilder()
    builder.name(name)
    return builder.build()
}
