@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.aws.apigateway.MethodResponseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an HTTP Method Response for an API Gateway Resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.RestApiArgs;
 * import com.pulumi.aws.apigateway.Resource;
 * import com.pulumi.aws.apigateway.ResourceArgs;
 * import com.pulumi.aws.apigateway.Method;
 * import com.pulumi.aws.apigateway.MethodArgs;
 * import com.pulumi.aws.apigateway.Integration;
 * import com.pulumi.aws.apigateway.IntegrationArgs;
 * import com.pulumi.aws.apigateway.MethodResponse;
 * import com.pulumi.aws.apigateway.MethodResponseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myDemoAPI = new RestApi("myDemoAPI", RestApiArgs.builder()
 *             .description("This is my API for demonstration purposes")
 *             .build());
 *         var myDemoResource = new Resource("myDemoResource", ResourceArgs.builder()
 *             .restApi(myDemoAPI.id())
 *             .parentId(myDemoAPI.rootResourceId())
 *             .pathPart("mydemoresource")
 *             .build());
 *         var myDemoMethod = new Method("myDemoMethod", MethodArgs.builder()
 *             .restApi(myDemoAPI.id())
 *             .resourceId(myDemoResource.id())
 *             .httpMethod("GET")
 *             .authorization("NONE")
 *             .build());
 *         var myDemoIntegration = new Integration("myDemoIntegration", IntegrationArgs.builder()
 *             .restApi(myDemoAPI.id())
 *             .resourceId(myDemoResource.id())
 *             .httpMethod(myDemoMethod.httpMethod())
 *             .type("MOCK")
 *             .build());
 *         var response200 = new MethodResponse("response200", MethodResponseArgs.builder()
 *             .restApi(myDemoAPI.id())
 *             .resourceId(myDemoResource.id())
 *             .httpMethod(myDemoMethod.httpMethod())
 *             .statusCode("200")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_api_gateway_method_response` using `REST-API-ID/RESOURCE-ID/HTTP-METHOD/STATUS-CODE`. For example:
 * ```sh
 *  $ pulumi import aws:apigateway/methodResponse:MethodResponse example 12345abcde/67890fghij/GET/200
 * ```
 * @property httpMethod HTTP Method (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTIONS`, `ANY`)
 * @property resourceId API resource ID
 * @property responseModels Map of the API models used for the response's content type
 * @property responseParameters Map of response parameters that can be sent to the caller.
 * For example: `response_parameters = { "method.response.header.X-Some-Header" = true }`
 * would define that the header `X-Some-Header` can be provided on the response.
 * @property restApi ID of the associated REST API
 * @property statusCode HTTP status code
 */
public data class MethodResponseArgs(
    public val httpMethod: Output<String>? = null,
    public val resourceId: Output<String>? = null,
    public val responseModels: Output<Map<String, String>>? = null,
    public val responseParameters: Output<Map<String, Boolean>>? = null,
    public val restApi: Output<String>? = null,
    public val statusCode: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.MethodResponseArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.MethodResponseArgs =
        com.pulumi.aws.apigateway.MethodResponseArgs.builder()
            .httpMethod(httpMethod?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .responseModels(
                responseModels?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .responseParameters(
                responseParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .restApi(restApi?.applyValue({ args0 -> args0 }))
            .statusCode(statusCode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MethodResponseArgs].
 */
@PulumiTagMarker
public class MethodResponseArgsBuilder internal constructor() {
    private var httpMethod: Output<String>? = null

    private var resourceId: Output<String>? = null

    private var responseModels: Output<Map<String, String>>? = null

    private var responseParameters: Output<Map<String, Boolean>>? = null

    private var restApi: Output<String>? = null

    private var statusCode: Output<String>? = null

    /**
     * @param value HTTP Method (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTIONS`, `ANY`)
     */
    @JvmName("kejumqdfccbsnwwb")
    public suspend fun httpMethod(`value`: Output<String>) {
        this.httpMethod = value
    }

    /**
     * @param value API resource ID
     */
    @JvmName("vipplaslngvrfqef")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Map of the API models used for the response's content type
     */
    @JvmName("sxyqxgbeaqitsdgp")
    public suspend fun responseModels(`value`: Output<Map<String, String>>) {
        this.responseModels = value
    }

    /**
     * @param value Map of response parameters that can be sent to the caller.
     * For example: `response_parameters = { "method.response.header.X-Some-Header" = true }`
     * would define that the header `X-Some-Header` can be provided on the response.
     */
    @JvmName("yxivpiqojvfmutnx")
    public suspend fun responseParameters(`value`: Output<Map<String, Boolean>>) {
        this.responseParameters = value
    }

    /**
     * @param value ID of the associated REST API
     */
    @JvmName("hllfctbtkrqyjmvw")
    public suspend fun restApi(`value`: Output<String>) {
        this.restApi = value
    }

    /**
     * @param value HTTP status code
     */
    @JvmName("sykodtqnovarowha")
    public suspend fun statusCode(`value`: Output<String>) {
        this.statusCode = value
    }

    /**
     * @param value HTTP Method (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTIONS`, `ANY`)
     */
    @JvmName("hbfxhbbsdengmkia")
    public suspend fun httpMethod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpMethod = mapped
    }

    /**
     * @param value API resource ID
     */
    @JvmName("nsvqxunhsgclsbpk")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value Map of the API models used for the response's content type
     */
    @JvmName("uxeioomnmapxfhbg")
    public suspend fun responseModels(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseModels = mapped
    }

    /**
     * @param values Map of the API models used for the response's content type
     */
    @JvmName("ojdhbvhrjkwkkefu")
    public fun responseModels(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.responseModels = mapped
    }

    /**
     * @param value Map of response parameters that can be sent to the caller.
     * For example: `response_parameters = { "method.response.header.X-Some-Header" = true }`
     * would define that the header `X-Some-Header` can be provided on the response.
     */
    @JvmName("uassspmhbfhjeapa")
    public suspend fun responseParameters(`value`: Map<String, Boolean>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseParameters = mapped
    }

    /**
     * @param values Map of response parameters that can be sent to the caller.
     * For example: `response_parameters = { "method.response.header.X-Some-Header" = true }`
     * would define that the header `X-Some-Header` can be provided on the response.
     */
    @JvmName("rrqaulakxwedffcf")
    public fun responseParameters(vararg values: Pair<String, Boolean>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.responseParameters = mapped
    }

    /**
     * @param value ID of the associated REST API
     */
    @JvmName("mgwxnsxpdcvrdvpx")
    public suspend fun restApi(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restApi = mapped
    }

    /**
     * @param value HTTP status code
     */
    @JvmName("ylslgptyruxsssnl")
    public suspend fun statusCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statusCode = mapped
    }

    internal fun build(): MethodResponseArgs = MethodResponseArgs(
        httpMethod = httpMethod,
        resourceId = resourceId,
        responseModels = responseModels,
        responseParameters = responseParameters,
        restApi = restApi,
        statusCode = statusCode,
    )
}
