@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.aws.apigateway.MethodSettingsArgs.builder
import com.pulumi.aws.apigateway.kotlin.inputs.MethodSettingsSettingsArgs
import com.pulumi.aws.apigateway.kotlin.inputs.MethodSettingsSettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *  /* /*
 * Manages API Gateway Stage Method Settings. For example, CloudWatch logging and metrics.
 * > **NOTE:** We recommend using this resource in conjunction with the `aws.apigateway.Stage` resource instead of a stage managed by the `aws.apigateway.Deployment` resource optional `stage_name` argument. Stages managed by the `aws.apigateway.Deployment` resource are recreated on redeployment and this resource will require a second apply to recreate the method settings.
 * ## Example Usage
 * ### End-to-end
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.RestApiArgs;
 * import com.pulumi.aws.apigateway.Deployment;
 * import com.pulumi.aws.apigateway.DeploymentArgs;
 * import com.pulumi.aws.apigateway.Stage;
 * import com.pulumi.aws.apigateway.StageArgs;
 * import com.pulumi.aws.apigateway.MethodSettings;
 * import com.pulumi.aws.apigateway.MethodSettingsArgs;
 * import com.pulumi.aws.apigateway.inputs.MethodSettingsSettingsArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleRestApi = new RestApi("exampleRestApi", RestApiArgs.builder()
 *             .body(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("openapi", "3.0.1"),
 *                     jsonProperty("info", jsonObject(
 *                         jsonProperty("title", "example"),
 *                         jsonProperty("version", "1.0")
 *                     )),
 *                     jsonProperty("paths", jsonObject(
 *                         jsonProperty("/path1", jsonObject(
 *                             jsonProperty("get", jsonObject(
 *                                 jsonProperty("x-amazon-apigateway-integration", jsonObject(
 *                                     jsonProperty("httpMethod", "GET"),
 *                                     jsonProperty("payloadFormatVersion", "1.0"),
 *                                     jsonProperty("type", "HTTP_PROXY"),
 *                                     jsonProperty("uri", "https://ip-ranges.amazonaws.com/ip-ranges.json")
 *                                 ))
 *                             ))
 *                         ))
 *                     ))
 *                 )))
 *             .build());
 *         var exampleDeployment = new Deployment("exampleDeployment", DeploymentArgs.builder()
 *             .restApi(exampleRestApi.id())
 *             .triggers(Map.of("redeployment", exampleRestApi.body().applyValue(body -> serializeJson(
 *                 body)).applyValue(toJSON -> computeSHA1(toJSON))))
 *             .build());
 *         var exampleStage = new Stage("exampleStage", StageArgs.builder()
 *             .deployment(exampleDeployment.id())
 *             .restApi(exampleRestApi.id())
 *             .stageName("example")
 *             .build());
 *         var all = new MethodSettings("all", MethodSettingsArgs.builder()
 *             .restApi(exampleRestApi.id())
 *             .stageName(exampleStage.stageName())
 *             .methodPath("*/*")
 *             .settings(MethodSettingsSettingsArgs.builder()
 *                 .metricsEnabled(true)
 *                 .loggingLevel("ERROR")
 *                 .build())
 *             .build());
 *         var pathSpecific = new MethodSettings("pathSpecific", MethodSettingsArgs.builder()
 *             .restApi(exampleRestApi.id())
 *             .stageName(exampleStage.stageName())
 *             .methodPath("path1/GET")
 *             .settings(MethodSettingsSettingsArgs.builder()
 *                 .metricsEnabled(true)
 *                 .loggingLevel("INFO")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Off
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.MethodSettings;
 * import com.pulumi.aws.apigateway.MethodSettingsArgs;
 * import com.pulumi.aws.apigateway.inputs.MethodSettingsSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pathSpecific = new MethodSettings("pathSpecific", MethodSettingsArgs.builder()
 *             .restApi(aws_api_gateway_rest_api.example().id())
 *             .stageName(aws_api_gateway_stage.example().stage_name())
 *             .methodPath("path1/GET")
 *             .settings(MethodSettingsSettingsArgs.builder()
 *                 .loggingLevel("OFF")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Errors Only
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.MethodSettings;
 * import com.pulumi.aws.apigateway.MethodSettingsArgs;
 * import com.pulumi.aws.apigateway.inputs.MethodSettingsSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pathSpecific = new MethodSettings("pathSpecific", MethodSettingsArgs.builder()
 *             .restApi(aws_api_gateway_rest_api.example().id())
 *             .stageName(aws_api_gateway_stage.example().stage_name())
 *             .methodPath("path1/GET")
 *             .settings(MethodSettingsSettingsArgs.builder()
 *                 .loggingLevel("ERROR")
 *                 .metricsEnabled(true)
 *                 .dataTraceEnabled(false)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Errors and Info Logs
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.MethodSettings;
 * import com.pulumi.aws.apigateway.MethodSettingsArgs;
 * import com.pulumi.aws.apigateway.inputs.MethodSettingsSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pathSpecific = new MethodSettings("pathSpecific", MethodSettingsArgs.builder()
 *             .restApi(aws_api_gateway_rest_api.example().id())
 *             .stageName(aws_api_gateway_stage.example().stage_name())
 *             .methodPath("path1/GET")
 *             .settings(MethodSettingsSettingsArgs.builder()
 *                 .loggingLevel("INFO")
 *                 .metricsEnabled(true)
 *                 .dataTraceEnabled(false)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Full Request and Response Logs
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.MethodSettings;
 * import com.pulumi.aws.apigateway.MethodSettingsArgs;
 * import com.pulumi.aws.apigateway.inputs.MethodSettingsSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pathSpecific = new MethodSettings("pathSpecific", MethodSettingsArgs.builder()
 *             .restApi(aws_api_gateway_rest_api.example().id())
 *             .stageName(aws_api_gateway_stage.example().stage_name())
 *             .methodPath("path1/GET")
 *             .settings(MethodSettingsSettingsArgs.builder()
 *                 .loggingLevel("INFO")
 *                 .metricsEnabled(true)
 *                 .dataTraceEnabled(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_api_gateway_method_settings` using `REST-API-ID/STAGE-NAME/METHOD-PATH`. For example:
 * ```sh
 *  $ pulumi import aws:apigateway/methodSettings:MethodSettings example 12345abcde/example/test/GET
 * ```
 * @property methodPath Method path defined as `{resource_path}/{http_method}` for an individual method override, or `*/*` for overriding all methods in the stage. Ensure to trim any leading forward slashes in the path (e.g., `trimprefix(aws_api_gateway_resource.example.path, "/")`).
 * @property restApi ID of the REST API
 * @property settings Settings block, see below.
 * @property stageName Name of the stage
 */
public data class MethodSettingsArgs(
    public val methodPath: Output<String>? = null,
    public val restApi: Output<String>? = null,
    public val settings: Output<MethodSettingsSettingsArgs>? = null,
    public val stageName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.MethodSettingsArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.MethodSettingsArgs =
        com.pulumi.aws.apigateway.MethodSettingsArgs.builder()
            .methodPath(methodPath?.applyValue({ args0 -> args0 }))
            .restApi(restApi?.applyValue({ args0 -> args0 }))
            .settings(settings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .stageName(stageName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MethodSettingsArgs].
 */
@PulumiTagMarker
public class MethodSettingsArgsBuilder internal constructor() {
    private var methodPath: Output<String>? = null

    private var restApi: Output<String>? = null

    private var settings: Output<MethodSettingsSettingsArgs>? = null

    private var stageName: Output<String>? = null

    /**
     *  /*
     * @param value Method path defined as `{resource_path}/{http_method}` for an individual method override, or `*/*` for overriding all methods in the stage. Ensure to trim any leading forward slashes in the path (e.g., `trimprefix(aws_api_gateway_resource.example.path, "/")`).
     */
    @JvmName("dkymclbacydrdppa")
    public suspend fun methodPath(`value`: Output<String>) {
        this.methodPath = value
    }

    /**
     * @param value ID of the REST API
     */
    @JvmName("gqdqsryoqbaxumpc")
    public suspend fun restApi(`value`: Output<String>) {
        this.restApi = value
    }

    /**
     * @param value Settings block, see below.
     */
    @JvmName("ikjyeaddndfhrbll")
    public suspend fun settings(`value`: Output<MethodSettingsSettingsArgs>) {
        this.settings = value
    }

    /**
     * @param value Name of the stage
     */
    @JvmName("jqxcwhoekevqgbns")
    public suspend fun stageName(`value`: Output<String>) {
        this.stageName = value
    }

    /**
     *  /*
     * @param value Method path defined as `{resource_path}/{http_method}` for an individual method override, or `*/*` for overriding all methods in the stage. Ensure to trim any leading forward slashes in the path (e.g., `trimprefix(aws_api_gateway_resource.example.path, "/")`).
     */
    @JvmName("tvpvtaelrarrwwar")
    public suspend fun methodPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.methodPath = mapped
    }

    /**
     * @param value ID of the REST API
     */
    @JvmName("xsaulkrnnljeubmg")
    public suspend fun restApi(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restApi = mapped
    }

    /**
     * @param value Settings block, see below.
     */
    @JvmName("cvbswyspwadaejfd")
    public suspend fun settings(`value`: MethodSettingsSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param argument Settings block, see below.
     */
    @JvmName("iehhqiojbrifequu")
    public suspend fun settings(argument: suspend MethodSettingsSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = MethodSettingsSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    /**
     * @param value Name of the stage
     */
    @JvmName("kbmkanwtuigxhjgp")
    public suspend fun stageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stageName = mapped
    }

    internal fun build(): MethodSettingsArgs = MethodSettingsArgs(
        methodPath = methodPath,
        restApi = restApi,
        settings = settings,
        stageName = stageName,
    )
}
