@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Model].
 */
@PulumiTagMarker
public class ModelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ModelArgs = ModelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ModelArgsBuilder.() -> Unit) {
        val builder = ModelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Model {
        val builtJavaResource = com.pulumi.aws.apigateway.Model(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Model(builtJavaResource)
    }
}

/**
 * Provides a Model for a REST API Gateway.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.RestApiArgs;
 * import com.pulumi.aws.apigateway.Model;
 * import com.pulumi.aws.apigateway.ModelArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myDemoAPI = new RestApi("myDemoAPI", RestApiArgs.builder()
 *             .description("This is my API for demonstration purposes")
 *             .build());
 *         var myDemoModel = new Model("myDemoModel", ModelArgs.builder()
 *             .restApi(myDemoAPI.id())
 *             .description("a JSON schema")
 *             .contentType("application/json")
 *             .schema(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("type", "object")
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_api_gateway_model` using `REST-API-ID/NAME`. For example:
 * ```sh
 *  $ pulumi import aws:apigateway/model:Model example 12345abcde/example
 * ```
 *
 */
public class Model internal constructor(
    override val javaResource: com.pulumi.aws.apigateway.Model,
) : KotlinCustomResource(javaResource, ModelMapper) {
    /**
     * Content type of the model
     */
    public val contentType: Output<String>
        get() = javaResource.contentType().applyValue({ args0 -> args0 })

    /**
     * Description of the model
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the model
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * ID of the associated REST API
     */
    public val restApi: Output<String>
        get() = javaResource.restApi().applyValue({ args0 -> args0 })

    /**
     * Schema of the model in a JSON form
     */
    public val schema: Output<String>?
        get() = javaResource.schema().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ModelMapper : ResourceMapper<Model> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apigateway.Model::class == javaResource::class

    override fun map(javaResource: Resource): Model = Model(
        javaResource as
            com.pulumi.aws.apigateway.Model,
    )
}

/**
 * @see [Model].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Model].
 */
public suspend fun model(name: String, block: suspend ModelResourceBuilder.() -> Unit): Model {
    val builder = ModelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Model].
 * @param name The _unique_ name of the resulting resource.
 */
public fun model(name: String): Model {
    val builder = ModelResourceBuilder()
    builder.name(name)
    return builder.build()
}
