@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.aws.apigateway.ModelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Model for a REST API Gateway.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.RestApiArgs;
 * import com.pulumi.aws.apigateway.Model;
 * import com.pulumi.aws.apigateway.ModelArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myDemoAPI = new RestApi("myDemoAPI", RestApiArgs.builder()
 *             .description("This is my API for demonstration purposes")
 *             .build());
 *         var myDemoModel = new Model("myDemoModel", ModelArgs.builder()
 *             .restApi(myDemoAPI.id())
 *             .description("a JSON schema")
 *             .contentType("application/json")
 *             .schema(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("type", "object")
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_api_gateway_model` using `REST-API-ID/NAME`. For example:
 * ```sh
 *  $ pulumi import aws:apigateway/model:Model example 12345abcde/example
 * ```
 * @property contentType Content type of the model
 * @property description Description of the model
 * @property name Name of the model
 * @property restApi ID of the associated REST API
 * @property schema Schema of the model in a JSON form
 */
public data class ModelArgs(
    public val contentType: Output<String>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val restApi: Output<String>? = null,
    public val schema: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.ModelArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.ModelArgs =
        com.pulumi.aws.apigateway.ModelArgs.builder()
            .contentType(contentType?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .restApi(restApi?.applyValue({ args0 -> args0 }))
            .schema(schema?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ModelArgs].
 */
@PulumiTagMarker
public class ModelArgsBuilder internal constructor() {
    private var contentType: Output<String>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var restApi: Output<String>? = null

    private var schema: Output<String>? = null

    /**
     * @param value Content type of the model
     */
    @JvmName("uftuxsrtkqfesgau")
    public suspend fun contentType(`value`: Output<String>) {
        this.contentType = value
    }

    /**
     * @param value Description of the model
     */
    @JvmName("wlfaicipeiamanxm")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the model
     */
    @JvmName("wlxkalfmxyuwspxp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value ID of the associated REST API
     */
    @JvmName("tyiudfigwmvjulgh")
    public suspend fun restApi(`value`: Output<String>) {
        this.restApi = value
    }

    /**
     * @param value Schema of the model in a JSON form
     */
    @JvmName("cojtmfrncshbdndo")
    public suspend fun schema(`value`: Output<String>) {
        this.schema = value
    }

    /**
     * @param value Content type of the model
     */
    @JvmName("igeqfhkoifuhnqld")
    public suspend fun contentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value Description of the model
     */
    @JvmName("jdafpuvqfslfgcre")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the model
     */
    @JvmName("mbvndiflwkjjuqrs")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value ID of the associated REST API
     */
    @JvmName("kttjagdnykqtvytp")
    public suspend fun restApi(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restApi = mapped
    }

    /**
     * @param value Schema of the model in a JSON form
     */
    @JvmName("oxnswfuxineiccvo")
    public suspend fun schema(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    internal fun build(): ModelArgs = ModelArgs(
        contentType = contentType,
        description = description,
        name = name,
        restApi = restApi,
        schema = schema,
    )
}
