@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.aws.apigateway.ResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an API Gateway Resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.RestApiArgs;
 * import com.pulumi.aws.apigateway.Resource;
 * import com.pulumi.aws.apigateway.ResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myDemoAPI = new RestApi("myDemoAPI", RestApiArgs.builder()
 *             .description("This is my API for demonstration purposes")
 *             .build());
 *         var myDemoResource = new Resource("myDemoResource", ResourceArgs.builder()
 *             .restApi(myDemoAPI.id())
 *             .parentId(myDemoAPI.rootResourceId())
 *             .pathPart("mydemoresource")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_api_gateway_resource` using `REST-API-ID/RESOURCE-ID`. For example:
 * ```sh
 *  $ pulumi import aws:apigateway/resource:Resource example 12345abcde/67890fghij
 * ```
 * @property parentId ID of the parent API resource
 * @property pathPart Last path segment of this API resource.
 * @property restApi ID of the associated REST API
 */
public data class ResourceArgs(
    public val parentId: Output<String>? = null,
    public val pathPart: Output<String>? = null,
    public val restApi: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.ResourceArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.ResourceArgs =
        com.pulumi.aws.apigateway.ResourceArgs.builder()
            .parentId(parentId?.applyValue({ args0 -> args0 }))
            .pathPart(pathPart?.applyValue({ args0 -> args0 }))
            .restApi(restApi?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceArgs].
 */
@PulumiTagMarker
public class ResourceArgsBuilder internal constructor() {
    private var parentId: Output<String>? = null

    private var pathPart: Output<String>? = null

    private var restApi: Output<String>? = null

    /**
     * @param value ID of the parent API resource
     */
    @JvmName("ygiaykrjqvbewyuo")
    public suspend fun parentId(`value`: Output<String>) {
        this.parentId = value
    }

    /**
     * @param value Last path segment of this API resource.
     */
    @JvmName("xamgcebrairvhaes")
    public suspend fun pathPart(`value`: Output<String>) {
        this.pathPart = value
    }

    /**
     * @param value ID of the associated REST API
     */
    @JvmName("pfigfetofvqoaqxn")
    public suspend fun restApi(`value`: Output<String>) {
        this.restApi = value
    }

    /**
     * @param value ID of the parent API resource
     */
    @JvmName("wnhytowgjsyuiagq")
    public suspend fun parentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentId = mapped
    }

    /**
     * @param value Last path segment of this API resource.
     */
    @JvmName("pxncpfdpawkwmsfp")
    public suspend fun pathPart(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pathPart = mapped
    }

    /**
     * @param value ID of the associated REST API
     */
    @JvmName("sskotqvpysglxidk")
    public suspend fun restApi(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restApi = mapped
    }

    internal fun build(): ResourceArgs = ResourceArgs(
        parentId = parentId,
        pathPart = pathPart,
        restApi = restApi,
    )
}
