@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Response].
 */
@PulumiTagMarker
public class ResponseResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResponseArgs = ResponseArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResponseArgsBuilder.() -> Unit) {
        val builder = ResponseArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Response {
        val builtJavaResource = com.pulumi.aws.apigateway.Response(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Response(builtJavaResource)
    }
}

/**
 * Provides an API Gateway Gateway Response for a REST API Gateway.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.Response;
 * import com.pulumi.aws.apigateway.ResponseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new RestApi("main");
 *         var test = new Response("test", ResponseArgs.builder()
 *             .restApiId(main.id())
 *             .statusCode("401")
 *             .responseType("UNAUTHORIZED")
 *             .responseTemplates(Map.of("application/json", "{\"message\":$context.error.messageString}"))
 *             .responseParameters(Map.of("gatewayresponse.header.Authorization", "'Basic'"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_api_gateway_gateway_response` using `REST-API-ID/RESPONSE-TYPE`. For example:
 * ```sh
 *  $ pulumi import aws:apigateway/response:Response example 12345abcde/UNAUTHORIZED
 * ```
 *
 */
public class Response internal constructor(
    override val javaResource: com.pulumi.aws.apigateway.Response,
) : KotlinCustomResource(javaResource, ResponseMapper) {
    /**
     * Map of parameters (paths, query strings and headers) of the Gateway Response.
     */
    public val responseParameters: Output<Map<String, String>>?
        get() = javaResource.responseParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * Map of templates used to transform the response body.
     */
    public val responseTemplates: Output<Map<String, String>>?
        get() = javaResource.responseTemplates().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * Response type of the associated GatewayResponse.
     */
    public val responseType: Output<String>
        get() = javaResource.responseType().applyValue({ args0 -> args0 })

    /**
     * String identifier of the associated REST API.
     */
    public val restApiId: Output<String>
        get() = javaResource.restApiId().applyValue({ args0 -> args0 })

    /**
     * HTTP status code of the Gateway Response.
     */
    public val statusCode: Output<String>?
        get() = javaResource.statusCode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object ResponseMapper : ResourceMapper<Response> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apigateway.Response::class == javaResource::class

    override fun map(javaResource: Resource): Response = Response(
        javaResource as
            com.pulumi.aws.apigateway.Response,
    )
}

/**
 * @see [Response].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Response].
 */
public suspend fun response(name: String, block: suspend ResponseResourceBuilder.() -> Unit):
    Response {
    val builder = ResponseResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Response].
 * @param name The _unique_ name of the resulting resource.
 */
public fun response(name: String): Response {
    val builder = ResponseResourceBuilder()
    builder.name(name)
    return builder.build()
}
