@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.aws.apigateway.ResponseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an API Gateway Gateway Response for a REST API Gateway.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.Response;
 * import com.pulumi.aws.apigateway.ResponseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new RestApi("main");
 *         var test = new Response("test", ResponseArgs.builder()
 *             .restApiId(main.id())
 *             .statusCode("401")
 *             .responseType("UNAUTHORIZED")
 *             .responseTemplates(Map.of("application/json", "{\"message\":$context.error.messageString}"))
 *             .responseParameters(Map.of("gatewayresponse.header.Authorization", "'Basic'"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_api_gateway_gateway_response` using `REST-API-ID/RESPONSE-TYPE`. For example:
 * ```sh
 *  $ pulumi import aws:apigateway/response:Response example 12345abcde/UNAUTHORIZED
 * ```
 * @property responseParameters Map of parameters (paths, query strings and headers) of the Gateway Response.
 * @property responseTemplates Map of templates used to transform the response body.
 * @property responseType Response type of the associated GatewayResponse.
 * @property restApiId String identifier of the associated REST API.
 * @property statusCode HTTP status code of the Gateway Response.
 */
public data class ResponseArgs(
    public val responseParameters: Output<Map<String, String>>? = null,
    public val responseTemplates: Output<Map<String, String>>? = null,
    public val responseType: Output<String>? = null,
    public val restApiId: Output<String>? = null,
    public val statusCode: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apigateway.ResponseArgs> {
    override fun toJava(): com.pulumi.aws.apigateway.ResponseArgs =
        com.pulumi.aws.apigateway.ResponseArgs.builder()
            .responseParameters(
                responseParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .responseTemplates(
                responseTemplates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .responseType(responseType?.applyValue({ args0 -> args0 }))
            .restApiId(restApiId?.applyValue({ args0 -> args0 }))
            .statusCode(statusCode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResponseArgs].
 */
@PulumiTagMarker
public class ResponseArgsBuilder internal constructor() {
    private var responseParameters: Output<Map<String, String>>? = null

    private var responseTemplates: Output<Map<String, String>>? = null

    private var responseType: Output<String>? = null

    private var restApiId: Output<String>? = null

    private var statusCode: Output<String>? = null

    /**
     * @param value Map of parameters (paths, query strings and headers) of the Gateway Response.
     */
    @JvmName("xphtolltdwnkryen")
    public suspend fun responseParameters(`value`: Output<Map<String, String>>) {
        this.responseParameters = value
    }

    /**
     * @param value Map of templates used to transform the response body.
     */
    @JvmName("ekeemquhopvrgsdh")
    public suspend fun responseTemplates(`value`: Output<Map<String, String>>) {
        this.responseTemplates = value
    }

    /**
     * @param value Response type of the associated GatewayResponse.
     */
    @JvmName("mldhjywewfvciltu")
    public suspend fun responseType(`value`: Output<String>) {
        this.responseType = value
    }

    /**
     * @param value String identifier of the associated REST API.
     */
    @JvmName("evnlehyagutdfjmm")
    public suspend fun restApiId(`value`: Output<String>) {
        this.restApiId = value
    }

    /**
     * @param value HTTP status code of the Gateway Response.
     */
    @JvmName("tybouttmsragkjle")
    public suspend fun statusCode(`value`: Output<String>) {
        this.statusCode = value
    }

    /**
     * @param value Map of parameters (paths, query strings and headers) of the Gateway Response.
     */
    @JvmName("pfsmympnjeealnml")
    public suspend fun responseParameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseParameters = mapped
    }

    /**
     * @param values Map of parameters (paths, query strings and headers) of the Gateway Response.
     */
    @JvmName("ugmbrgdiubxovqhc")
    public fun responseParameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.responseParameters = mapped
    }

    /**
     * @param value Map of templates used to transform the response body.
     */
    @JvmName("fuwmmavakqjryoyi")
    public suspend fun responseTemplates(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseTemplates = mapped
    }

    /**
     * @param values Map of templates used to transform the response body.
     */
    @JvmName("jevutkbkyoxfpgre")
    public fun responseTemplates(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.responseTemplates = mapped
    }

    /**
     * @param value Response type of the associated GatewayResponse.
     */
    @JvmName("uiluvspwowaewfrj")
    public suspend fun responseType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseType = mapped
    }

    /**
     * @param value String identifier of the associated REST API.
     */
    @JvmName("hmrfxohkaqlfnljp")
    public suspend fun restApiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restApiId = mapped
    }

    /**
     * @param value HTTP status code of the Gateway Response.
     */
    @JvmName("pnfbelchglriyslq")
    public suspend fun statusCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statusCode = mapped
    }

    internal fun build(): ResponseArgs = ResponseArgs(
        responseParameters = responseParameters,
        responseTemplates = responseTemplates,
        responseType = responseType,
        restApiId = restApiId,
        statusCode = statusCode,
    )
}
