@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.aws.apigateway.kotlin.outputs.RestApiEndpointConfiguration
import com.pulumi.aws.apigateway.kotlin.outputs.RestApiEndpointConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [RestApi].
 */
@PulumiTagMarker
public class RestApiResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RestApiArgs = RestApiArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RestApiArgsBuilder.() -> Unit) {
        val builder = RestApiArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RestApi {
        val builtJavaResource = com.pulumi.aws.apigateway.RestApi(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RestApi(builtJavaResource)
    }
}

/**
 * Manages an API Gateway REST API. The REST API can be configured via [importing an OpenAPI specification](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api.html) in the `body` argument (with other arguments serving as overrides) or via other provider resources to manage the resources (`aws.apigateway.Resource` resource), methods (`aws.apigateway.Method` resource), integrations (`aws.apigateway.Integration` resource), etc. of the REST API. Once the REST API is configured, the `aws.apigateway.Deployment` resource can be used along with the `aws.apigateway.Stage` resource to publish the REST API.
 * > **Note:** Amazon API Gateway Version 1 resources are used for creating and deploying REST APIs. To create and deploy WebSocket and HTTP APIs, use Amazon API Gateway Version 2 resources.
 * !> **WARN:** When importing Open API Specifications with the `body` argument, by default the API Gateway REST API will be replaced with the Open API Specification thus removing any existing methods, resources, integrations, or endpoints. Endpoint mutations are asynchronous operations, and race conditions with DNS are possible. To overcome this limitation, use the `put_rest_api_mode` attribute and set it to `merge`.
 * ## Example Usage
 * ### OpenAPI Specification
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.RestApiArgs;
 * import com.pulumi.aws.apigateway.inputs.RestApiEndpointConfigurationArgs;
 * import com.pulumi.aws.apigateway.Deployment;
 * import com.pulumi.aws.apigateway.DeploymentArgs;
 * import com.pulumi.aws.apigateway.Stage;
 * import com.pulumi.aws.apigateway.StageArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleRestApi = new RestApi("exampleRestApi", RestApiArgs.builder()
 *             .body(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("openapi", "3.0.1"),
 *                     jsonProperty("info", jsonObject(
 *                         jsonProperty("title", "example"),
 *                         jsonProperty("version", "1.0")
 *                     )),
 *                     jsonProperty("paths", jsonObject(
 *                         jsonProperty("/path1", jsonObject(
 *                             jsonProperty("get", jsonObject(
 *                                 jsonProperty("x-amazon-apigateway-integration", jsonObject(
 *                                     jsonProperty("httpMethod", "GET"),
 *                                     jsonProperty("payloadFormatVersion", "1.0"),
 *                                     jsonProperty("type", "HTTP_PROXY"),
 *                                     jsonProperty("uri", "https://ip-ranges.amazonaws.com/ip-ranges.json")
 *                                 ))
 *                             ))
 *                         ))
 *                     ))
 *                 )))
 *             .endpointConfiguration(RestApiEndpointConfigurationArgs.builder()
 *                 .types("REGIONAL")
 *                 .build())
 *             .build());
 *         var exampleDeployment = new Deployment("exampleDeployment", DeploymentArgs.builder()
 *             .restApi(exampleRestApi.id())
 *             .triggers(Map.of("redeployment", exampleRestApi.body().applyValue(body -> serializeJson(
 *                 body)).applyValue(toJSON -> computeSHA1(toJSON))))
 *             .build());
 *         var exampleStage = new Stage("exampleStage", StageArgs.builder()
 *             .deployment(exampleDeployment.id())
 *             .restApi(exampleRestApi.id())
 *             .stageName("example")
 *             .build());
 *     }
 * }
 * ```
 * ### Resources
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.apigateway.Resource;
 * import com.pulumi.aws.apigateway.ResourceArgs;
 * import com.pulumi.aws.apigateway.Method;
 * import com.pulumi.aws.apigateway.MethodArgs;
 * import com.pulumi.aws.apigateway.Integration;
 * import com.pulumi.aws.apigateway.IntegrationArgs;
 * import com.pulumi.aws.apigateway.Deployment;
 * import com.pulumi.aws.apigateway.DeploymentArgs;
 * import com.pulumi.aws.apigateway.Stage;
 * import com.pulumi.aws.apigateway.StageArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleRestApi = new RestApi("exampleRestApi");
 *         var exampleResource = new Resource("exampleResource", ResourceArgs.builder()
 *             .parentId(exampleRestApi.rootResourceId())
 *             .pathPart("example")
 *             .restApi(exampleRestApi.id())
 *             .build());
 *         var exampleMethod = new Method("exampleMethod", MethodArgs.builder()
 *             .authorization("NONE")
 *             .httpMethod("GET")
 *             .resourceId(exampleResource.id())
 *             .restApi(exampleRestApi.id())
 *             .build());
 *         var exampleIntegration = new Integration("exampleIntegration", IntegrationArgs.builder()
 *             .httpMethod(exampleMethod.httpMethod())
 *             .resourceId(exampleResource.id())
 *             .restApi(exampleRestApi.id())
 *             .type("MOCK")
 *             .build());
 *         var exampleDeployment = new Deployment("exampleDeployment", DeploymentArgs.builder()
 *             .restApi(exampleRestApi.id())
 *             .triggers(Map.of("redeployment", Output.tuple(exampleResource.id(), exampleMethod.id(), exampleIntegration.id()).applyValue(values -> {
 *                 var exampleResourceId = values.t1;
 *                 var exampleMethodId = values.t2;
 *                 var exampleIntegrationId = values.t3;
 *                 return serializeJson(
 *                     jsonArray(
 *                         exampleResourceId,
 *                         exampleMethodId,
 *                         exampleIntegrationId
 *                     ));
 *             }).applyValue(toJSON -> computeSHA1(toJSON))))
 *             .build());
 *         var exampleStage = new Stage("exampleStage", StageArgs.builder()
 *             .deployment(exampleDeployment.id())
 *             .restApi(exampleRestApi.id())
 *             .stageName("example")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_api_gateway_rest_api` using the REST API ID. For example:
 * ```sh
 *  $ pulumi import aws:apigateway/restApi:RestApi example 12345abcde
 * ```
 *  ~> __NOTE:__ Resource import does not currently support the `body` attribute.
 */
public class RestApi internal constructor(
    override val javaResource: com.pulumi.aws.apigateway.RestApi,
) : KotlinCustomResource(javaResource, RestApiMapper) {
    /**
     * Source of the API key for requests. Valid values are `HEADER` (default) and `AUTHORIZER`. If importing an OpenAPI specification via the `body` argument, this corresponds to the [`x-amazon-apigateway-api-key-source` extension](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-api-key-source.html). If the argument value is provided and is different than the OpenAPI value, the argument value will override the OpenAPI value.
     */
    public val apiKeySource: Output<String>
        get() = javaResource.apiKeySource().applyValue({ args0 -> args0 })

    /**
     * ARN
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * List of binary media types supported by the REST API. By default, the REST API supports only UTF-8-encoded text payloads. If importing an OpenAPI specification via the `body` argument, this corresponds to the [`x-amazon-apigateway-binary-media-types` extension](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-binary-media-types.html). If the argument value is provided and is different than the OpenAPI value, the argument value will override the OpenAPI value.
     */
    public val binaryMediaTypes: Output<List<String>>
        get() = javaResource.binaryMediaTypes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * OpenAPI specification that defines the set of routes and integrations to create as part of the REST API. This configuration, and any updates to it, will replace all REST API configuration except values overridden in this resource configuration and other resource updates applied after this resource but before any `aws.apigateway.Deployment` creation. More information about REST API OpenAPI support can be found in the [API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api.html).
     */
    public val body: Output<String>?
        get() = javaResource.body().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Creation date of the REST API
     */
    public val createdDate: Output<String>
        get() = javaResource.createdDate().applyValue({ args0 -> args0 })

    /**
     * Description of the REST API. If importing an OpenAPI specification via the `body` argument, this corresponds to the `info.description` field. If the argument value is provided and is different than the OpenAPI value, the argument value will override the OpenAPI value.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * Whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint. Defaults to `false`. If importing an OpenAPI specification via the `body` argument, this corresponds to the [`x-amazon-apigateway-endpoint-configuration` extension `disableExecuteApiEndpoint` property](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-endpoint-configuration.html). If the argument value is `true` and is different than the OpenAPI value, the argument value will override the OpenAPI value.
     */
    public val disableExecuteApiEndpoint: Output<Boolean>
        get() = javaResource.disableExecuteApiEndpoint().applyValue({ args0 -> args0 })

    /**
     * Configuration block defining API endpoint configuration including endpoint type. Defined below.
     */
    public val endpointConfiguration: Output<RestApiEndpointConfiguration>
        get() = javaResource.endpointConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * Execution ARN part to be used in `lambda_permission`'s `source_arn`
     * when allowing API Gateway to invoke a Lambda function,
     * e.g., `arn:aws:execute-api:eu-west-2:123456789012:z4675bid1j`, which can be concatenated with allowed stage, method and resource path.
     */
    public val executionArn: Output<String>
        get() = javaResource.executionArn().applyValue({ args0 -> args0 })

    /**
     * Whether warnings while API Gateway is creating or updating the resource should return an error or not. Defaults to `false`
     */
    public val failOnWarnings: Output<Boolean>?
        get() = javaResource.failOnWarnings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Minimum response size to compress for the REST API. String containing an integer value between `-1` and `10485760` (10MB). `-1` will disable an existing compression configuration, and all other values will enable compression with the configured size. New resources can simply omit this argument to disable compression, rather than setting the value to `-1`. If importing an OpenAPI specification via the `body` argument, this corresponds to the [`x-amazon-apigateway-minimum-compression-size` extension](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-openapi-minimum-compression-size.html). If the argument value is provided and is different than the OpenAPI value, the argument value will override the OpenAPI value.
     */
    public val minimumCompressionSize: Output<String>
        get() = javaResource.minimumCompressionSize().applyValue({ args0 -> args0 })

    /**
     * Name of the REST API. If importing an OpenAPI specification via the `body` argument, this corresponds to the `info.title` field. If the argument value is different than the OpenAPI value, the argument value will override the OpenAPI value.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Map of customizations for importing the specification in the `body` argument. For example, to exclude DocumentationParts from an imported API, set `ignore` equal to `documentation`. Additional documentation, including other parameters such as `basepath`, can be found in the [API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api.html).
     */
    public val parameters: Output<Map<String, String>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * JSON formatted policy document that controls access to the API Gateway. For more information about building AWS IAM policy documents with Pulumi, see the AWS IAM Policy Document Guide. The provider will only perform drift detection of its value when present in a configuration. We recommend using the `aws.apigateway.RestApiPolicy` resource instead. If importing an OpenAPI specification via the `body` argument, this corresponds to the [`x-amazon-apigateway-policy` extension](https://docs.aws.amazon.com/apigateway/latest/developerguide/openapi-extensions-policy.html). If the argument value is provided and is different than the OpenAPI value, the argument value will override the OpenAPI value.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * Mode of the PutRestApi operation when importing an OpenAPI specification via the `body` argument (create or update operation). Valid values are `merge` and `overwrite`. If unspecificed, defaults to `overwrite` (for backwards compatibility). This corresponds to the [`x-amazon-apigateway-put-integration-method` extension](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-put-integration-method.html). If the argument value is provided and is different than the OpenAPI value, the argument value will override the OpenAPI value.
     */
    public val putRestApiMode: Output<String>?
        get() = javaResource.putRestApiMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource ID of the REST API's root
     */
    public val rootResourceId: Output<String>
        get() = javaResource.rootResourceId().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object RestApiMapper : ResourceMapper<RestApi> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apigateway.RestApi::class == javaResource::class

    override fun map(javaResource: Resource): RestApi = RestApi(
        javaResource as
            com.pulumi.aws.apigateway.RestApi,
    )
}

/**
 * @see [RestApi].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RestApi].
 */
public suspend fun restApi(name: String, block: suspend RestApiResourceBuilder.() -> Unit):
    RestApi {
    val builder = RestApiResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RestApi].
 * @param name The _unique_ name of the resulting resource.
 */
public fun restApi(name: String): RestApi {
    val builder = RestApiResourceBuilder()
    builder.name(name)
    return builder.build()
}
