@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apigateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RestApiPolicy].
 */
@PulumiTagMarker
public class RestApiPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RestApiPolicyArgs = RestApiPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RestApiPolicyArgsBuilder.() -> Unit) {
        val builder = RestApiPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RestApiPolicy {
        val builtJavaResource = com.pulumi.aws.apigateway.RestApiPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RestApiPolicy(builtJavaResource)
    }
}

/**
 * Provides an API Gateway REST API Policy.
 * > **Note:** Amazon API Gateway Version 1 resources are used for creating and deploying REST APIs. To create and deploy WebSocket and HTTP APIs, use Amazon API Gateway Version 2 resources.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apigateway.RestApi;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.apigateway.RestApiPolicy;
 * import com.pulumi.aws.apigateway.RestApiPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testRestApi = new RestApi("testRestApi");
 *         final var testPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers("*")
 *                     .build())
 *                 .actions("execute-api:Invoke")
 *                 .resources(testRestApi.executionArn())
 *                 .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                     .test("IpAddress")
 *                     .variable("aws:SourceIp")
 *                     .values("123.123.123.123/32")
 *                     .build())
 *                 .build())
 *             .build());
 *         var testRestApiPolicy = new RestApiPolicy("testRestApiPolicy", RestApiPolicyArgs.builder()
 *             .restApiId(testRestApi.id())
 *             .policy(testPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(testPolicyDocument -> testPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_api_gateway_rest_api_policy` using the REST API ID. For example:
 * ```sh
 *  $ pulumi import aws:apigateway/restApiPolicy:RestApiPolicy example 12345abcde
 * ```
 *
 */
public class RestApiPolicy internal constructor(
    override val javaResource: com.pulumi.aws.apigateway.RestApiPolicy,
) : KotlinCustomResource(javaResource, RestApiPolicyMapper) {
    /**
     * JSON formatted policy document that controls access to the API Gateway.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * ID of the REST API.
     */
    public val restApiId: Output<String>
        get() = javaResource.restApiId().applyValue({ args0 -> args0 })
}

public object RestApiPolicyMapper : ResourceMapper<RestApiPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apigateway.RestApiPolicy::class == javaResource::class

    override fun map(javaResource: Resource): RestApiPolicy = RestApiPolicy(
        javaResource as
            com.pulumi.aws.apigateway.RestApiPolicy,
    )
}

/**
 * @see [RestApiPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RestApiPolicy].
 */
public suspend fun restApiPolicy(
    name: String,
    block: suspend RestApiPolicyResourceBuilder.() -> Unit,
): RestApiPolicy {
    val builder = RestApiPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RestApiPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun restApiPolicy(name: String): RestApiPolicy {
    val builder = RestApiPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
